<?php $__env->startSection('styles'); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- PAGE-HEADER -->
    <div class="page-header">
        <h1 class="page-title">Order Status</h1>
        <div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Orders</a></li>
                <li class="breadcrumb-item active" aria-current="page">Order Status</li>
            </ol>
        </div>
    </div>
    <!-- PAGE-HEADER END -->

    <!-- ROW-1 OPEN -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['category-create','category-edit'])): ?>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Edit Order Status</h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                            <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                            <input id="status_id" name="status_id" type="hidden" value="">

                            <?php echo csrf_field(); ?>
                            <div class="form-row">
                                <div class="col-xl-6 mb-3">
                                    <label for="validationTooltip01">Status Name *</label>
                                    <input data-parsley-required-message="Status Name Required" type="text" class="form-control" disabled id="status">
                                </div>
                                <div class="col-xl-6 mb-3">
                                    <label for="validationTooltip01">Message EN *</label>
                                    <input data-parsley-required-message="Message EN Required" type="text" class="form-control" name="message_en" id="message_en">
                                </div>
                                <div class="col-xl-6 mb-3">
                                    <label for="validationTooltip01">Message AR *</label>
                                    <input data-parsley-required-message="Message AR Required" type="text" class="form-control" name="message_ar" id="message_ar">
                                </div>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-edit')): ?>
                                <a id="update_btn" style="display: none" href="#"
                                   onclick="createOrUpdate('update_status', 'createForm', '', 'table_datatable','')"
                                   class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- /ROW-1 CLOSED -->

    <!-- Row -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-list')): ?>
        <div class="row row-sm">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">View Categories</h3>
                        <div class="card-options">
                            <button type="button" onclick="$('#change_order').modal('show');"
                                    class="btn btn-sm btn-icon btn-facebook"><i class="fa fa-sort"></i>&nbsp;&nbsp;Change
                                Order</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered text-nowrap border-bottom dataTable no-footer "
                                   style="width: 100% !important;" id="table_datatable">
                                <thead class="text-center">
                                <tr>
                                    <th class="wd-15p border-bottom-0">#</th>
                                    <th class="wd-15p border-bottom-0">Status</th>
                                    <th class="wd-15p border-bottom-0">Message</th>
                                    <th class="wd-15p border-bottom-0">Message AR</th>
                                    <th class="wd-10p border-bottom-0">Actions</th>
                                </tr>
                                </thead>

                            </table>

                            <div class="col-sm-12 col-md-12">
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </div>
    <?php endif; ?>
    <!-- End Row -->



    <!-- ####################################delete Modal ########################### -->
    <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bolder">Delete</h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Do you want to delete the category ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button onclick="delete_item()" class="btn btn-primary">Delete</button>
                </div>
            </div>
        </div>
    </div>
    <!-- ################################ delete Modal################################## -->
    <!-- ############################################Change Sort  Order ##########################              -->

    <!-- ##################################################End Of Change View Order ############################ -->

    <!--  -->
    <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bolder" id="view_modal_title"></h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body" id="view_modal_body">

                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--  -->



<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    
    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css')); ?>">
    <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>

    <script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>

    
    <script>
        var token = $("meta[name=csrf-token]").attr("content");
        var public_url = "<?php echo e(url('/')); ?>/<?php echo e(env('ADMIN_PANEL_ROUTE')); ?>";
        var datatable_name = "table_datatable";
        $('#table_datatable').DataTable({
            "responsive": true,
            "serverSide": true,
            "ordering": true,
            "searching": true,
            "bLengthChange": true,
            "info": false,
            "bSort": true,
            "order": [
                [0, 'desc']
            ],
            "columnDefs": [{
                "targets": [0, 4],
                "orderable": true
            },
                {
                    "className": "text-center",
                    "targets": [0, 3, 4]
                },
                {
                    "className": "text-left",
                    "targets": []
                }

            ],
            "displayLength": 10,
            "ajax": {
                "url": public_url + "/status_datatable",
                "type": "post",
                "data": function(data) {
                    data._token = token;

                    return data;

                }
            },
            "AutoWidth": true,
            "columns": [{
                "data": "id",
                "name": "id"
            },
                {
                    "data": "status",
                    "name": "status"
                },
                {
                    "data": "message",
                    "name": "message"
                },
                {
                    "data": "message_ar",
                    "name": "message_ar"
                },
                {
                    "data": "id",
                    "name": "id"
                },
            ],

            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                var info = this.dataTable().api().page.info();
                var page = info.page;
                var length = info.length;
                var index = (page * length + (iDataIndex + 1));
                var action = "";
                if (aData.category_icon == "" || aData.category_icon == null) {
                    aData.category_icon = "no_image.png";
                }
                // var image = '<a href="/uploads/category_images/' + aData.category_icon +
                //     '" target="_blank"><img style="width:30px; height:30px" src="/uploads/category_images/' + aData
                //         .category_icon + '"></a>';
                //Edit Action
                var action = action + '&nbsp;<button title="View"  onclick=View(' + aData.id +
                    ') id="bEdit" type="button" class="btn btn-sm btn-success"><span class="fe fe-eye"> </span></button>';
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-edit')): ?>
                var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.id +
                    ') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
                <?php endif; ?>
                $('td:eq(0)', nRow).html(index);
                // $('td:eq(2)', nRow).html(image);
                $('td:eq(4)', nRow).html(action);
            }
        });

        // #################### View Section ############################
        function View(id) {
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": id
                },
                url: public_url + '/status_view',
                success: function(result) {
                    $('#view_modal_title').text('Delivery Status');
                    $('#view_modal_body').html(result);
                    $('#scrollingmodal').modal('show');
                }
            })
        }

        //#######################End Of View Section ##################
        // #################### Edit Section ############################
        function edit(id) {
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": id
                },
                url: public_url + '/edit_status',
                success: function(result) {
                    $('#status_id').val(result.id);
                    $('#status').val(result.status);
                    $('#message_en').val(result.message);
                    $('#message_ar').val(result.message_ar);

                    $('#create_btn').hide();
                    $('#update_btn').show();
                    $('#back-to-top').click();

                }
            })
        }
        // #################### End Of Edit Section ####################
        // #################### Delete Section ##########################
        function delete_modal(id) {
            $('#category_id').val(id);
            $('#smallmodal').modal('show');
        }

        function delete_item() {
            var id = $('#category_id').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": id
                },
                url: public_url + '/delete_category',
                success: function(result) {
                    $('#smallmodal').modal('hide');
                    toast(result, datatable_name);
                }
            })
        }
        // #################### End Of Delete Section ##################


        $(function() {
            $("#imageListId").sortable({
                update: function(event, ui) {
                    getIdsOfImages();
                } //end update
            });
        });

        function getIdsOfImages() {
            var values = [];
            $('.listitemClass').each(function(index) {
                values.push($(this).attr("id")
                    .replace("imageNo", ""));
            });

            $('#savebtnget').css('display', 'inline-block')
            $('#outputvalues').val(values);
        }

        function saveorder() {
            var catarray = $('#outputvalues').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "catarray": catarray
                },
                url: "<?php echo e(route('category_change_order')); ?>",
                success: function(result) {
                    $('#change_order').modal('hide');
                    toast(result, datatable_name);
                    setTimeout(function() {
                        location.reload();
                    }, 2000);

                }
            });
        }
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gocrispydmenus/public_html/albaitalkuwaiti.dmenus.com/resources/views/admin/order/delivery_status.blade.php ENDPATH**/ ?>