
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('assets/css/custom_style.css')); ?>" rel="stylesheet"/>
    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #1c1c1c;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #1c1c1c;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- PAGE-HEADER -->
    <div class="page-header">
        <h1 class="page-title">Manage Admin</h1>
        <div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="dashboard">Home</a></li>
                <li class="breadcrumb-item"><a href="dashboard">Master Setting</a></li>
                <li class="breadcrumb-item active" aria-current="page">Add/Edit Admin</li>
            </ol>
        </div>
    </div>
    <!-- PAGE-HEADER END -->

    <!-- ROW-1 OPEN -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user-create','user-edit'])): ?>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Add Admin</h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                            <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                            <input id="user_id" name="user_id" type="hidden" value="">

                            <?php echo csrf_field(); ?>
                            <div class="form-row">
                                <div class="form-group col-xl-4 mb-3">
                                    <label for="validationTooltip01">Select Branch</label>

                                    <select class="form-control" name="branch" id="branch">
                                        <option value="">Select</option>
                                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->address); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-xl-4 mb-3">
                                    <label for="validationTooltip01">Select Roles *</label>

                                    <select data-parsley-required-message="Roles required" required multiple="multiple"
                                            class="filter-multi" name="roles[]" id="roles">
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <option value="<?php echo e($role); ?>"><?php echo e($role); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-xl-4 mb-3">
                                    <label for="validationTooltip01">Name *</label>
                                    <input data-parsley-required-message="Name Required" type="text"
                                           class="form-control" name="name" id="name"
                                           value="" required>
                                </div>
                                <div class="col-xl-4 mb-3">
                                    <label for="validationTooltip01">Mobile *</label>
                                    <input data-parsley-required-message="Mobile Required" maxlength="8" type="text"
                                           class="form-control" name="mobile" id="mobile"
                                           value="" required>
                                </div>
                                <div class="col-xl-4 mb-3">
                                    <label for="validationTooltip01">Email * </label>
                                    <input type="text" class="form-control" name="email" id="email" value=""
                                           data-parsley-required-message="Email Required" required>
                                </div>
                                <div class="col-xl-4 mb-3">
                                    <label for="validationTooltip02">Profile Photo (150x150px)</label>
                                    <input type="file" data-parsley-required-message=""
                                           class="form-control custom-input-file" name="image" id="image" value="">
                                </div>

                                <div class="col-xl-4 mb-3">
                                    <label for="validationTooltip01">User Name * </label>
                                    <input type="text" data-parsley-required-message="User ID Required" minlength="8"
                                           maxlength="30" class="form-control" name="username" id="username" value=""
                                           required>
                                </div>
                                <div class="col-xl-4 mb-3">
                                    <label for="validationTooltip01">Password * </label>
                                    <input type="text" data-parsley-required-message="Password Required"
                                           class="form-control" name="password" id="password" value="" required>
                                </div>
                                <div class="col-xl-4 mb-3">
                                    <label for="validationTooltip01">Confirm Password * </label>
                                    <input type="text" data-parsley-required-message="Confirm Password Required"
                                           class="form-control" name="confirm_password" id="confirm_password" value=""
                                           required>
                                </div>


                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-create')): ?>
                                <a id="create_btn" href="#"
                                   onclick="createOrUpdate('add_user', 'createForm', '', 'table_datatable','')"
                                   class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-edit')): ?>
                                <a id="update_btn" style="display: none" href="#"
                                   onclick="createOrUpdate('update_user', 'createForm', '', 'table_datatable','')"
                                   class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- /ROW-1 CLOSED -->
    <!-- Row -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-list')): ?>
        <div class="row row-sm">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">View Admins</h3>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered text-nowrap border-bottom "
                                   style="width: 100% !important;" id="table_datatable">
                                <thead class="text-center">
                                <tr>
                                    <th class="wd-15p border-bottom-0">#</th>
                                    <th class="wd-15p border-bottom-0">User ID</th>
                                    <th class="wd-15p border-bottom-0">Name</th>
                                    <th class="wd-15p border-bottom-0">Mobile</th>
                                    <th class="wd-15p border-bottom-0">Email</th>
                                    <th class="wd-15p border-bottom-0">Status</th>
                                    <th class="wd-15p border-bottom-0"> Actions</th>
                                </tr>
                                </thead>

                            </table>
                            <div class="col-sm-12 col-md-12">
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </div>
    <?php endif; ?>

    <!-- End Row -->
    <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete</h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Do you want to delete.. ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button onclick="delete_item()" class="btn btn-primary">Delete</button>
                </div>
            </div>
        </div>
    </div>
    
    
    <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="view_modal_title"></h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body" id="view_modal_body">

                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    




<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    
    <script src="<?php echo e(asset('assets/jquery-datatable/jquery.min.js')); ?>"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css')); ?>">
    <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>
    
    <script>
        var token = $("meta[name=csrf-token]").attr("content");
        var public_url = "<?php echo e(url('/')); ?>/<?php echo e(env('ADMIN_PANEL_ROUTE')); ?>";
        var datatable_name = "table_datatable";
        $('#table_datatable').DataTable({
            "responsive": true,
            "serverSide": true,
            "ordering": true,
            "searching": true,
            "bLengthChange": true,
            "info": false,
            "bSort": true,
            "order": [
                [0, 'desc']
            ],
            "columnDefs": [{
                "targets": [0, 4],
                "orderable": true
            },
                {"className": "text-center", "targets": [0, 1, 5]},
                {"className": "text-left", "targets": [2, 3, 4]},
                {"orderable": false, "targets": [5, 6]}

            ],
            "displayLength": 10,
            "ajax": {
                "url": public_url + "/user_datatable",
                "type": "post",
                "data": function (data) {
                    data._token = token;

                    return data;

                }
            }, "AutoWidth": true,
            "columns": [
                {"data": "id", "name": "id"},
                {"data": "user_unique_id", "name": "user_unique_id"},
                {"data": "name", "name": "name"},
                {"data": "mobile", "name": "mobile"},
                {"data": "email", "name": "email"},
                {"data": "id", "name": "id"},
                {"data": "id", "name": "id"},
            ],

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                var info = this.dataTable().api().page.info();
                var page = info.page;
                var length = info.length;
                var index = (page * length + (iDataIndex + 1));
                var action = "";

                if (aData.user_attempt >= 5) {
                    var checked = "";
                } else {
                    var checked = "checked";
                }
                //View action
                var action = action + '&nbsp;<button title="View" onclick=view(' + aData.id + ') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
                //Toggle Button
                var toggle = '<label class="switch"><input onchange="change_active_status(' + aData.id + ',this)"  type="checkbox" ' + checked + '><span class="slider round"></span></label>';

                //Edit Action
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-edit')): ?>
                var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.id + ') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
                <?php endif; ?>
                //Delete Action
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-delete')): ?>
                var action = action + '&nbsp;<button title="Delete" onclick="delete_modal(' + aData.id + ')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
                <?php endif; ?>

                $('td:eq(0)', nRow).html(index);
                $('td:eq(5)', nRow).html(toggle);
                $('td:eq(6)', nRow).html(action);
            }
        });

        // #################### Edit Section ############################
        function edit(id) {
            $.ajax({
                type: 'POST',
                data: {"_token": token, "id": id},
                url: public_url + '/edit_user',
                success: function (result) {
                    $('#user_id').val(result.user.id);
                    $('#name').val(result.user.name);
                    $('#mobile').val(result.user.mobile);
                    $('#email').val(result.user.email);
                    $('#username').val(result.user.username);
                    $('#seller').val(result.user.seller_id);
                    var roles = result.userRole;
                    $('#branch').val(result.branches);
                    $select = $("#roles");
                    $(function () {
                        var roles_array = [];
                        $.each(roles, function (index, roles) {
                            roles_array.push(roles);
                        });
                        $select.multipleSelect();
                        $select.multipleSelect("setSelects", roles_array);
                    });
                    $('#password').attr('required', false).val('');
                    $('#confirm_password').attr('required', false).val('');
                    $('#create_btn').hide();
                    $('#update_btn').show();
                    $('#back-to-top').click();

                }
            })
        }

        // #################### End Of Edit Section ####################
        // #################### Delete Section ##########################
        function delete_modal(id) {
            $('#user_id').val(id);
            $('#smallmodal').modal('show');
        }

        function delete_item() {
            var id = $('#user_id').val();
            $.ajax({
                type: 'POST',
                data: {"_token": token, "id": id},
                url: public_url + '/delete_user',
                success: function (result) {
                    $('#smallmodal').modal('hide');
                    toast(result, datatable_name);
                }
            })
        }

        // #################### End Of Delete Section ##################
        // #################### View Section #########################
        function view(id) {
            $.ajax({
                type: 'POST',
                data: {"_token": token, "id": id},
                url: public_url + '/user_view',
                success: function (result) {
                    $('#view_modal_title').text('Admin Details');
                    $('#view_modal_body').html(result);
                    $('#scrollingmodal').modal('show');
                }
            })
        }

        //    #################### End Of View Section ##################

        //########################Change Active Inactive Function ######
        function change_active_status(id, element) {
            if ($(element).is(':checked')) {
                var attempt_count = 0;
            } else {
                var attempt_count = 5;

            }

            $.ajax({
                type: 'POST',
                data: {"_token": token, "id": id, "attempt_count": attempt_count},
                url: public_url + '/change_user_active_status',
                success: function (result) {
                    toast(result, datatable_name);

                }
            })


        }

        // #########################End Of Active Inactive Section #########
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gocrispydmenus/public_html/albaitalkuwaiti.dmenus.com/resources/views/admin/master_settings/add_user.blade.php ENDPATH**/ ?>