<?php $__env->startSection('styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">View Invoices</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="dashboard">Invoice</a></li>
            <li class="breadcrumb-item active" aria-current="page">View Invoices </li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- Row -->
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any('invoice-list')): ?>
<div class="row">
    <div id="print_order_div" style="display: none;"></div>  
    <div class="col-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title mb-0">View Invoices</h3>
            </div>
            <div class="card-body pt-4">
                <div class="grid-margin">
                    <div class="">
                        <div class="panel panel-primary">
                            <div class="tab-menu-heading border-0 p-0">
                                <div class="tabs-menu1">

                                    <ul class="nav panel-tabs product-sale">
                      
                                        <li class="px-2">



                                            <div class="input-group">
                                                <?php
                                                $from_date="";
                                                $to_date="";
                                                if(session('invoice_from_date_filter')){ 
                                                $date = DateTime::createFromFormat('Y-m-d',
                                                session('invoice_from_date_filter'));
                                                $from_date = $date->format('m/d/y');
                                                }

                                                if(session('invoice_to_date_filter')){
                                                $date = DateTime::createFromFormat('Y-m-d',
                                                session('invoice_to_date_filter'));
                                                $to_date = $date->format('m/d/y');
                                                }


                                                ?>




                                                <label class="form-label px-2">From :</label>
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div><input onchange="invoice_date_from_filter()"
                                                    class="form-control fc-datepicker from_date"
                                                    placeholder="MM/DD/YYYY" value="<?php echo e($from_date); ?>" type="text">
                                            </div>
                                        </li>


                                        <li class="px-2">
                                            <div class="input-group">
                                                <label class="form-label px-2">To :</label>
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div><input onchange="invoice_date_to_filter()"
                                                    class="form-control fc-datepicker to_date" value="<?php echo e($to_date); ?>"
                                                    placeholder="MM/DD/YYYY" type="text">
                                            </div>
                                        </li>


                                        <li>
                                            <button id="reset_btn" class="btn btn-danger"><i
                                                    class="fa fa-repeat"></i></button>
                                        </li>


                                    </ul>
                                </div>
                            </div>
                            <div class="panel-body tabs-menu-body border-0 pt-0">
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab5">
                                        <div class="table-responsive">
                                            <table class="table table-bordered text-nowrap border-bottom "
                                                style="width: 100% !important;" id="table_datatable"
                                                class="table table-bordered text-nowrap mb-0">
                                                <thead class="border-top text-center">
                                                    <tr>
                                                        <th class="bg-transparent border-bottom-0" style="width: 5%;">#
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Invoice ID</th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Date</th>

                                                        <th class="bg-transparent border-bottom-0">
                                                            time</th>

                                                        <th class="bg-transparent border-bottom-0">
                                                            Name</th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Sub Total</th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Discount</th>
                                                             <th class="bg-transparent border-bottom-0">
                                                            Grand Total</th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Action</th>
                                                    </tr>
                                                </thead>

                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<!-- End Row -->



<!------ Invoice Modal modal--------->
        <div class="modal fade" id="modaldemo8">
            <div class="modal-dialog modal-xl modal-dialog-centered text-center" role="document">
                <div class="modal-content modal-content-demo">
                    <div class="modal-header">
                        <h2 class="modal-title">Invoice Details</h2><button aria-label="Close" class="btn-close" data-bs-dismiss="modal"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body invoice_modal_body">
                    <div style="background-color: #f0f0f5 !important;" class="row invoice_view_modal_body">

        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn  btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
<!------ Invoice view modal--------->




<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script src="<?php echo e(asset('assets/jquery-datatable/jquery.min.js')); ?>"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css')); ?>">
<script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>



<!-- BOOTSTRAP-DATERANGEPICKER JS -->
<script src="<?php echo e(asset('assets/plugins/bootstrap-daterangepicker/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="<?php echo e(asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.js')); ?>"></script>

<!-- TIMEPICKER JS -->
<script src="<?php echo e(asset('assets/plugins/time-picker/jquery.timepicker.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/time-picker/toggles.min.js')); ?>"></script>


<script src="<?php echo e(asset('assets/plugins/multi/multi.min.js')); ?>"></script>

<!-- DATEPICKER JS -->
<script src="<?php echo e(asset('assets/plugins/date-picker/date-picker.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/date-picker/jquery-ui.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/input-mask/jquery.maskedinput.js')); ?>"></script>

<!-- FORMELEMENTS JS -->
<script src="<?php echo e(asset('assets/js/formelementadvnced.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/form-elements.js')); ?>"></script>
<script>
var token = $("meta[name=csrf-token]").attr("content");

var datatable_name = "table_datatable";
var url = "<?php echo e(url('/')); ?>";
var view_invoice_url="<?php echo e(route('view_invoice')); ?>";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": true,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [8],
            "orderable": false
        },
        {
            "className": "text-center",
            "targets": [0, 1, 2,3, 8]
        },
        {
            "className": "text-left",
            "targets": [4]
        },
        {
            "className": "text-end",
            "targets": [5,6,7]
        },

    ],
    "displayLength": 10,
    "ajax": {
        "url": "<?php echo e(route('invoice_datattable')); ?>",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "invoice_id",
            "name": "invoice_id"
        },
        {
            "data": "inventory_unique_id",
            "name": "inventory_unique_id"
        },
        {
            "data": "invoice_date",
            "name": "invoice_date"
        },
        {
            "data": "invoice_time",
            "name": "invoice_time"
        },
        {
            "data": "invoice_customer_name",
            "name": "invoice_customer_name"
        },
        {
            "data": "invoice_sub_total",
            "name": "invoice_sub_total"
        },
        {
            "data": "invoice_discount_amount",
            "name": "invoice_discount_amount"
        },
        {
            "data": "invoice_grand_total",
            "name": "invoice_grand_total"
        },
        {
            "data": "invoice_id",
            "name": "invoice_id"
        },
    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var time = tConvert(aData.invoice_time);
        var action = "";

        if(aData.invoice_customer_name){
            var customer_name=aData.invoice_customer_name;
        }
        else{
            var customer_name='Guest';
        }


        var action = action + '&nbsp;<button title="View"  onclick=view_invoice(' + aData.invoice_id +
            ') id="bEdit" data-bs-effect="effect-fall" data-bs-toggle="modal" href="#modaldemo8" type="button" class="btn btn-sm btn-success"><span class="fe fe-eye"> </span></button>';
        
        var action = action + '&nbsp;<button title="Print"  onclick=print_invoice(' + aData.invoice_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-warning"><span class="fa fa-print"> </span></button>';


        $('td:eq(0)', nRow).html(index);
        $('td:eq(3)', nRow).html(time);
        $('td:eq(4)', nRow).html(customer_name);
        $('td:eq(5)', nRow).html(parseInt(aData.invoice_sub_total).toFixed(2));
        $('td:eq(6)', nRow).html(parseInt(aData.invoice_discount_amount).toFixed(2));
        $('td:eq(7)', nRow).html(parseInt(aData.invoice_grand_total).toFixed(2));
        $('td:eq(8)', nRow).html(action);






    }
});



function tConvert(time) {
    // Check correct time format and split into components
    time = time.toString().match(/^([01]\d|2[0-3])(:)([0-5]\d)(:[0-5]\d)?$/) || [time];

    if (time.length > 1) { // If time format correct
        time = time.slice(1); // Remove full string match value
        time[5] = +time[0] < 12 ? '  AM' : '  PM'; // Set AM/PM
        time[0] = +time[0] % 12 || 12; // Adjust hours
    }
    return time.join(''); // return adjusted time or original string
}







$('#reset_btn').click(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token
        },
        url: "<?php echo e(route('reset_session')); ?>",
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
            $('.from_date').val('');
            $('.to_date').val('');

        }
    })
});


function invoice_date_from_filter() {
    var from_date = $('.from_date').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "from_date": from_date
        },
        url: "<?php echo e(route('invoice_from_date_filter')); ?>",
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);

        }
    })

}

function invoice_date_to_filter() {
    var to_date = $('.to_date').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "to_date": to_date
        },
        url: "<?php echo e(route('invoice_to_date_filter')); ?>",
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);

        }
    })
}


function view_invoice(invoice_id) {
    $.ajax({
        type: "POST",
        data: {
            _token: token,
            id: invoice_id,
        },
        url: view_invoice_url,
        success: function (result) {
            $(".invoice_view_modal_body").html(result);
        },
    });
    // $("#view-invoice-modal").modal("show");
}


function print_invoice(invoice_id) {
    var src = url + "/admin/invoice-print/" + invoice_id;
    $("#print_order_div").html('<iframe src="' + src + '"></iframe>');
}


</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gocrispydmenus/public_html/albaitalkuwaiti.dmenus.com/resources/views/admin/inventory/index.blade.php ENDPATH**/ ?>