

        <?php $__env->startSection('styles'); ?>

        <?php $__env->stopSection(); ?>

            <?php $__env->startSection('content'); ?>

                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Customers</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                         <li class="breadcrumb-item"><a href="javascript:void(0)">Customers</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Add Customers</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['customer-create','customer-edit'])): ?>
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Customer</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                                                    <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                                                    <input id="customer_id" name="customer_id" type="hidden" value="">

                                                    <?php echo csrf_field(); ?>
                                                <div class="form-row">

                                                    <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Customer Name *</label>
                                                        <input data-parsley-required-message="Customer Name Required" type="text" class="form-control" name="customer_name" id="customer_name"
                                                            value="" required>

                                                    </div>


                                                        <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Mobile *</label>
                                                        <input data-parsley-required-message="Mobile Number Required" type="text" class="form-control" name="mobile_number" id="mobile_number" minlength="8" maxlength="11"
                                                            value="" required>
                                                    </div>
                                                         <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Email ID *</label>
                                                        <input type="email" class="form-control" name="email" id="email" value=""  data-parsley-required-message="Email Required" Required>
                                                    </div>


                                                     <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Address</label>
                                                        <textarea name="address" id="address" class="form-control"></textarea>
                                                    </div>


                                                </div>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-create')): ?>
                                                <a id="create_btn" href="#" onclick="createOrUpdate('add_customer', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-edit')): ?>
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('update_customer', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                                                <?php endif; ?>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                             <?php endif; ?>
                            <!-- /ROW-1 CLOSED -->

                               <!-- Row -->
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-list')): ?>
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View Customers</h3>
                                        <div class="card-options">
                                            <a href="/admin/download_customer" class="btn btn-success" style="color: white"><i class="fa fa-download"></i>&nbsp;Export Customer</a>
                                        </div>

                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                             <table  class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Customer ID</th>
                                                        <th class="wd-15p border-bottom-0">Name</th>
                                                        <th class="wd-15p border-bottom-0">Mobile</th>
                                                        <th class="wd-15p border-bottom-0">Email ID</th>
                                                        <th class="wd-10p border-bottom-0">Actions</th>
                                                    </tr>
                                                </thead>

                                            </table>

                                            <div class="col-sm-12 col-md-12">
                                        </div>
                                        </div>
                                    </div>


                                </div>

                            </div>
                        </div>
                        <?php endif; ?>
                        <!-- End Row -->

                         <!-- Modal -->



                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete the Customer ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn btn-primary">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>


                         
            <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" style="font-weight: bold;" id="view_modal_title">Customer Details</h5>
                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                    </div>
                    <div class="modal-body"  id="view_modal_body">

                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
            




            <?php $__env->stopSection(); ?>
              <?php $__env->startSection('scripts'); ?>

   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.min.js')); ?>"></script>
   <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css')); ?>">
   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js?v1111111111113')); ?>"></script>
 
        <script>
    var public_url="<?php echo e(url('/')); ?>/<?php echo e(env('ADMIN_PANEL_ROUTE')); ?>";
    var token = $("meta[name=csrf-token]").attr("content");
    var datatable_name="table_datatable";
    var coloumn_data=['customer_id','customer_unique_id','customer_name','customer_mob','customer_mail_id','customer_id'];
    var coloumn_array=[];
    for (let i = 0; i <coloumn_data.length; i++) {
        coloumn_array.push({"data": ""+coloumn_data[i]+"", "name": ""+coloumn_data[i]+""});
    }
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": false,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,coloumn_data.length-1],
           },
           {"className": "text-center", "targets": [0,1]},
           {"className": "text-left", "targets": [2,3,4]},
           {"orderable": false, "targets": [5]}

       ],
       "displayLength":10,
       "ajax": {
           "url":  public_url+"/customer_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;

               return data;

           }
       }, "AutoWidth": true,
       "columns":coloumn_array,

      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          var created_at=aData.created_at.substring(0, 10);
            //View Function
            var action=action+'&nbsp;<a title="View"  href="customer_orders/'+aData.customer_id+'" type="button" class="btn btn-sm custom-btn-warning">Orders</a>';
            //var action=action+'&nbsp;<a title="View"  href="cart_activities/'+aData.customer_id+'" type="button" class="btn btn-sm custom-btn-warning">Cart Activities</a>';
            var action=action+'&nbsp;<button title="View"  onclick="" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
            //Edit Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-edit')): ?>
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.customer_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            <?php endif; ?>
            //Delete Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-delete')): ?>
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.customer_id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            <?php endif; ?>
            $('td:eq(0)', nRow).html(index);
            $('td:eq(5)', nRow).html(action).addClass('text-center');

 }
 });

//        // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: public_url+'/edit_customer',
                    success: function (result) {
                        $('#customer_id').val(result.customer_id);
                        $('#customer_name').val(result.customer_name);
                        $('#mobile_number').val(result.customer_mob);
                        $('#email').val(result.customer_mail_id);
                        $('#q_id').val(result.customer_q_id);
                        $('#company_name').val(result.company_name);
                        $('#address').val(result.customer_address);
                        $('#address').val(result.customer_address);
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#token_status').val(1);
                        $('#back-to-top').click();
                        }
                })
                }
//       // #################### End Of Edit Section ####################
//      // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#customer_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#customer_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: public_url+'/delete_customer',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
//      // #################### End Of Delete Section ##################

        // #########################View Section ##########################
        function View(id){
            $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: public_url+'/view_customer',
                        success: function (result) {
                           $('#view_modal_body').html(result);
                           $('#scrollingmodal').modal('show');
                        }
                    })
        }
        // ###############################################################

        </script>
        <?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dmenus/public_html/albaitalkuwaiti.dmenus.com/resources/views/admin/customers/index.blade.php ENDPATH**/ ?>