
<?php $__env->startSection('styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
input:checked+.slider {
    background-color: <?php echo session('layout_data')->admin_theme_color;
    ?> !important;
}
</style>

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Recipies</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="/dashboard">Recipies</a></li>
            <li class="breadcrumb-item active" aria-current="page">Manage Recipe</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['recipe-create','recipe-edit'])): ?>
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Recipe</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createrecipeForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                    <input id="recipe_id" name="recipe_id" type="hidden" value="">

                    <?php echo csrf_field(); ?>
                    <div class="form-row">

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Select Category *</label>
                            <select data-parsley-required-message="Choose Category" type="text" class="form-control"
                                name="category" id="category" required>
                                <option value="">--Choose Category--</option>
                                <?php $__currentLoopData = $data['categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->category_id); ?>"><?php echo e($category->category_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>










                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Select Recipe Type *</label>
                            <select class="form-control" name="recipe_type" id="recipe_type"
                                data-parsley-required-message="Choose Recipe Type" required>
                                <option value="">--Choose Recipe Type--</option>
                                <option value="1">Veg</option>
                                <option value="2">Non-veg</option>

                            </select>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Item No. *</label>
                            <input data-parsley-required-message="Item No. Required" type="text"
                                   class="form-control" name="item_no" id="item_no" value="" required>

                        </div>
                        <?php $__currentLoopData = $data['available_languages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $available_language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Recipe Name
                                <?php echo e($available_language['language_short_code']); ?> *</label>
                            <input required
                                data-parsley-required-message="Recipe Name <?php echo e($available_language['language_name']); ?> Required"
                                type="text" class="form-control"
                                name="recipe_name_<?php echo e($available_language['language_id']); ?>"
                                id="recipe_name_<?php echo e($available_language['language_id']); ?>" value="">

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        <div class="col-xl-2 mb-3">
                            <label for="validationTooltip01">Price (<?php echo e(session('layout_data')->currency); ?>)
                                *</label>
                            <input data-parsley-required-message="Recipe Price Required" type="text"
                                class="form-control" name="recipe_price" id="recipe_price" value="" required>

                        </div>

                        <div class="col-xl-2 mb-3">
                            <label for="validationTooltip01">Offer Price (<?php echo e(session('layout_data')->currency); ?>)
                            </label>
                            <input type="text" class="form-control" name="recipe_offer_price" id="recipe_offer_price"
                                value="">

                        </div>



                        <?php $__currentLoopData = $data['available_languages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $available_language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Description
                                <?php echo e($available_language['language_short_code']); ?></label>
                            <textarea class="form-control" name="description_<?php echo e($available_language['language_id']); ?>"
                                id="description_<?php echo e($available_language['language_id']); ?>"> </textarea>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        <div class="col-xl-2 mb-3">
                            <label for="validationTooltip01">Preparation Time(Mints)
                            </label>
                            <input type="text" class="form-control" name="recipe_preparation_time"
                                id="recipe_preparation_time" value="">

                        </div>

                        <div class="col-xl-2 mb-3">
                            <label for="validationTooltip01">Stock Reminder *
                            </label>
                            <input type="text" class="form-control" name="stock_reminder" id="stock_reminder" value=""
                                required data-parsley-required-message="Recipe Stock Reminder Required">

                        </div>

                        <div class="col-xl-2 mb-3">
                            <label for="validationTooltip01">Stock *
                            </label>
                            <input type="text" class="form-control" name="stock" id="stock" value="" required
                                data-parsley-required-message="Recipe Stock  Required">

                        </div>



                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Recipe Title Image (<?php echo e(env('RECIPE_IMAGE_SIZE')); ?>px)
                                *</label>
                            <input type="file" data-parsley-required-message="Recipe Image Required" accept=".jpg,.png"
                                class="form-control custom-input-file" name="image" id="image" value="">
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Recipe Sub Image 1 (<?php echo e(env('RECIPE_IMAGE_SIZE')); ?>px)</label>
                            <input type="file" class="form-control custom-input-file" name="sub_image_1"
                                id="sub_image_1" value="">
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Recipe Sub Image 2 (<?php echo e(env('RECIPE_IMAGE_SIZE')); ?>px)</label>
                            <input type="file" class="form-control custom-input-file" name="sub_image_2"
                                id="sub_image_2" value="">
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Recipe Sub Image 3 (<?php echo e(env('RECIPE_IMAGE_SIZE')); ?>px)</label>
                            <input type="file" class="form-control custom-input-file" name="sub_image_3"
                                id="sub_image_3" value="">
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Recipe Sub Image 4 (<?php echo e(env('RECIPE_IMAGE_SIZE')); ?>px)</label>
                            <input type="file" class="form-control custom-input-file" name="sub_image_4"
                                id="sub_image_4" value="">
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Recipe Sub Image 5 (<?php echo e(env('RECIPE_IMAGE_SIZE')); ?>px)</label>
                            <input type="file" class="form-control custom-input-file" name="sub_image_5"
                                id="sub_image_5" value="">
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Recipe Video</label>
                            <input type="file" class="form-control custom-input-file" name="video" id="video" value="">
                        </div>


                    </div>

                    <!-- /ROW-1 CLOSED -->
                    <div class="row">


                        <div class="col-md-12 panel-group1" id="accordion1">































































































































                        </div>


                    </div>

                    <!-- Row -->
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recipe-create')): ?>
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('<?php echo e(route('add_recipe')); ?>', 'createrecipeForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recipe-edit')): ?>
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('<?php echo e(route('update_recipe')); ?>', 'createrecipeForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recipe-list')): ?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Recipies</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-xl-3 mb-2">
                    </div>
                    <div class="col-xl-3 mb-2">
                        <label class="form-label"> Recipe Type</label>
                        <select class="form-control select2 form-select recipe_type_filter"
                            data-placeholder="Recipe Type">
                            <option value="0">--Choose Recipe Type--</option>
                            <option <?php if(session('admin_recipe_type_filter') && session('admin_recipe_type_filter')==1): ?>
                                Selected <?php endif; ?> value="1">Veg</option>
                            <option <?php if(session('admin_recipe_type_filter') && session('admin_recipe_type_filter')==2): ?>
                                Selected <?php endif; ?> value="2">Non-veg</option>
                        </select>
                    </div>

                    <div class="col-xl-3 mb-2">
                        <label class="form-label">Choose Category</label>
                        <select class="form-control select2 form-select category_filter"
                            data-placeholder="Choose Category">
                            <option value="0">--Choose Category--</option>
                            <?php $__currentLoopData = $data['categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(session('admin_category_filter') &&
                            session('admin_category_filter')==$category->category_id): ?>
                            <?php $selected="Selected"; ?>
                            <?php else: ?>
                            <?php $selected=""; ?>
                            <?php endif; ?>
                            <option <?php echo e($selected); ?> value="<?php echo e($category->category_id); ?>"><?php echo e($category->category_name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-xl-3 mb-2">

                        <label class="form-label">&nbsp</label>
                        <?php if(session('admin_recipe_most_recommended')): ?>
                        <?php $most_recommended_class_name="btn-primary"; ?>
                        <?php else: ?>
                        <?php $most_recommended_class_name=""; ?>
                        <?php endif; ?>
                        <a href="javascript:void(0)"
                            class="btn btn-outline-primary pr-2 <?php echo e($most_recommended_class_name); ?> most_recommended">Most
                            Recommended</a>
                        <a href="javascript:void(0)" class="btn btn-danger  reset_filter"><i
                                class="fa fa-refresh"></i></a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom" id="table_datatable">
                        <thead class="text-center">
                            <tr>
                                <th class="wd-10p border-bottom-0">#</th>
                                <th class="wd-10p border-bottom-0">Recipe Name</th>
                                <th class="wd-10p border-bottom-0">Price</th>
                                <th class="wd-10p border-bottom-0">Icon</th>
                                <th class="wd-10p border-bottom-0">Status</th>
                                <th class="wd-10p border-bottom-0">Actions</th>
                            </tr>
                        </thead>


                    </table>
                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
<?php endif; ?>
<!-- End Row -->

<!-- Modal -->
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete the Recipe ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" style="font-weight: bold;" id="view_modal_title">Recipe Details</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body" id="view_modal_body">

            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>




<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script src="<?php echo e(asset('assets/jquery-datatable/jquery.min.js')); ?>"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css')); ?>">
<script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>


<!-- INTERNAL multi js-->
<script src="<?php echo e(asset('assets/plugins/multi/multi.min.js')); ?>"></script>

<script>
var token = $("meta[name=csrf-token]").attr("content");
var datatable_name = "table_datatable";
var add_on_array = <?php echo json_encode($data['add_ons']); ?>;
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": true,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [3, 4, 5],
            "orderable": false
        },
        {
            "className": "text-center",
            "targets": [0, 3, 4, 5]
        },
        {
            "className": "text-left",
            "targets": [1]
        },
        {
            "className": "text-end",
            "targets": [2]
        }

    ],
    "displayLength": 10,
    "ajax": {
        "url": "<?php echo e(route('recipe_datatable')); ?>",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "recipe_id",
            "name": "recipe_id"
        },
        {
            "data": "recipe_name",
            "name": "recipe_name"
        },
        {
            "data": "recipe_price",
            "name": "recipe_price"
        },
        {
            "data": "recipe_image",
            "name": "recipe_image"
        },
        {
            "data": "recipe_active_status",
            "name": "recipe_active_status"
        },

        {
            "data": "recipe_id",
            "name": "recipe_id"
        },
    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";
        //Change Active Status Section
        if (aData.recipe_active_status == 0) {

            var change_status =
                '<label class="switch"><input type="checkbox"  onclick="change_recipe_status(' + aData
                .recipe_id + ',1)"><span class="slider"></span></label>';
        } else {
            var change_status =
                '<label class="switch"><input type="checkbox" onclick="change_recipe_status(' + aData
                .recipe_id + ',0)" checked ><span class="slider"></span></label>';
        }


        //End Of Change Active Section
        if (aData.recipe_image == "" || aData.recipe_image == null) {
            aData.recipe_image = "no_image.png";
        }
        var image = '<a style="cursor: pointer;" href="/uploads/recipe_images/' + aData.recipe_image +
            '" target="_blank"><img style="width:30px; height:30px" src="/uploads/recipe_images/' + aData
            .recipe_image + '"></a>';
        //View Function
        var action = action + '&nbsp;<button title="Edit"  onclick=view(' + aData.recipe_id +
            ') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
        //Edit Action
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recipe-edit')): ?>
        var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.recipe_id +
            ') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
        <?php endif; ?>
        //Delete Action
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recipe-delete')): ?>
        var action = action + '&nbsp;<button title="Delete" onclick="delete_modal(' + aData.recipe_id +
            ')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
        <?php endif; ?>
        if (aData.recipe_offer_price && aData.recipe_offer_price > 0 && aData.recipe_offer_price < aData
            .recipe_price) {
            var price_label =
                "<span class='me-2 fw-bold fs-13'>" + aData.recipe_offer_price.toFixed(2) +
                " <?php echo e(session('layout_data')->currency); ?>/</span><span><del class='fs-13 fw-bold text-muted'>" +
                aData.recipe_price.toFixed(2) + "</del></span>";
        } else {
            var price_label =
                "<span class='me-2 fw-bold fs-13'>" + aData.recipe_price.toFixed(2) +
                " <?php echo e(session('layout_data')->currency); ?></span>";
        }

        $('td:eq(0)', nRow).html(index);
        $('td:eq(2)', nRow).html(price_label);
        $('td:eq(3)', nRow)
            .html(image);
        $('td:eq(4)', nRow).html(change_status);
        $('td:eq(5)', nRow).html(action);
    }
});

// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "<?php echo e(route('edit_recipe')); ?>",
        success: function(result) {

            var subcategory = result.recipe_subcategory_id;

            // #############Subcategory  Fetching##############
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": result.recipe_category_id
                },
                url: "<?php echo e(route('fetch_subcategory')); ?>",
                success: function(data) {
                    var subcatgories = data.subcatgories;
                    $('#sub_category').html(
                        '<option value="">-- Choose Subcategory --</option>');
                    for (let i = 0; i < subcatgories.length; i++) {
                        if (subcatgories[i].subcategory_id == subcategory) {
                            var selected = "Selected";
                        } else {
                            var selected = "";
                        }
                        $('#sub_category').append('<option  ' + selected + ' value="' +
                            subcatgories[i].subcategory_id + '">' + subcatgories[i]
                            .subcategory_name + '</option>')
                    }

                }
            })
            // End Of Subcategory Fetching
            //recipe name
            var multi_languae = JSON.parse(result.recipe_name_multi_language);
            $.each(multi_languae, function(index, value) {
                $('#recipe_name_' + index).val(value);
            });
            //End Of Recipe Name

            //recipe Description
            var multi_languae = JSON.parse(result.recipe_description_multi_language);
            $.each(multi_languae, function(index, value) {
                $('#description_' + index).val(value);
            });
            //End Of Recipe Description
            $('#recipe_id').val(result.recipe_id);
            $('#category').val(result.recipe_category_id);
            $('#subcategory').val(result.recipe_subcategory_id);
            $('#item_no').val(result.item_no);
            $('#recipe_type').val(result.recipe_veg_or_non);
            $('#recipe_price').val(result.recipe_price);
            $('#recipe_offer_price').val(result.recipe_offer_price);
            $('#recipe_preparation_time').val(result.recipe_preparation_time);
            $('#stock_reminder').val(result.recipe_stock_reminder);
            $('#stock').val(result.recipe_stock);
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();
            //recipe Variant Section
            var recipe_variants = result.recipe_variants;
            // var recipe_variants = $.parseJSON(recipe_variants);
            $('#variant_type_tbody').html('');

            if (recipe_variants.length > 0) {

                $('.recipe_varient_colapse').addClass('show');

            } else {

                $('.recipe_varient_colapse').removeClass('show');

            }

            $.each(recipe_variants, function(index, value) {



                if (value['default_status'] == 1) {

                    var default_checked = "checked";

                } else {

                    var default_checked = "";

                }

                var rowCount = $("#variant_type_tbody tr").length;

                var new_count = rowCount + 1;

                $('#variant_type_tbody').append(
                    '<tr><td class="text-center"><div class="form-check"><input class="form-check-input default_recipe_class" type="checkbox" ' +
                    default_checked +
                    ' onclick="check_default_recipe(this)" name="default_recipe" value="' +
                    new_count +
                    '" id="flexCheckDefault"></label></div></td><td><input type="text" class="form-control" name="variant_name[]" value="' +
                    value['varient_name'] +
                    '"> </td><td><input type="number" class="form-control" name="variant_price[]" value="' +
                    value['varient_price'] +
                    '"></td><td class="text-center"><i class="fa fa-close" onclick="remove_row(this)"></i></td></tr>'
                );
            });
            //End Of Variant Section
            //Recipe Property Section
            var recipe_properties = result.recipe_properties;
            var recipe_properties = $.parseJSON(recipe_properties);
            $('#properties_tbody').html('');
            $.each(recipe_properties, function(index, value) {
                $('.recipe_property_colapse').addClass('show');
                $('#properties_tbody').append(
                    '<tr><td><input type="text" class="form-control" name="property_name[]" value="' +
                    value +
                    '"> </td> <td class="text-center"><i class="fa fa-close" onclick="remove_row(this)"></i></td></tr>'
                );


            });


            //End Of Recipe propery Section
            //Recipe Add On Section
            var total_add_on = result.total_add_on;
            var recipe_add_on = $.parseJSON(result.recipe_add_ons);
            set_add_on_options(total_add_on, recipe_add_on)
            //End Of Recipe add O Section

        }
    })
}
// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#recipe_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#recipe_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "<?php echo e(route('delete_recipe')); ?>",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, datatable_name);
        }
    })
}
// #################### End Of Delete Section ##################


//  ###########################Categiry Change ################
$('#category').change(function() {
    var id = $('#category').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "<?php echo e(route('fetch_subcategory')); ?>",
        success: function(result) {
            var subcatgories = result.subcatgories;
            var breeds = result.breed;
            $('#sub_category').html('<option value="">-- Choose Subcategory --</option>');
            for (let i = 0; i < subcatgories.length; i++) {
                $('#sub_category').append('<option value="' + subcatgories[i].subcategory_id +
                    '">' + subcatgories[i].subcategory_name + '</option>')
            }
        }
    })
});

//  ###########################END OF CATEGORY CHANGE###########
//###################View Function##############################
function view(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "<?php echo e(route('view_recipe')); ?>",
        success: function(result) {
            $('#view_modal_body').html(result);
            $('#scrollingmodal').modal('show');
        }
    })
}


//###################End View Function##############################
//####################Active function #############################
function change_recipe_status(recipe_id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "recipe_id": recipe_id,
            "status": status
        },
        url: "<?php echo e(route('change_status')); ?>",
        success: function(result) {
            toast(result, datatable_name);
        }
    })
}
//  ####################End Of Active Function#######################

// ####################Check Most Recommended##########
function change_recommeded_status(recipe_id) {
    if ($('#recommend_check_nox').is(':checked') == true) {
        var check_status = 1;
    } else {
        var check_status = 0;
    }
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "recipe_id": recipe_id,
            "check_status": check_status
        },
        url: "<?php echo e(route('change_recommended_status')); ?>",
        success: function(result) {
            toast(result, datatable_name);
        }
    })

}

// ####################End Of Check Most Recommended##########
// ######################Category Filter #####################
$('.category_filter').change(function() {
    var category_id = $(this).val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "category_id": category_id,
        },
        url: "<?php echo e(route('category_wise_filter')); ?>",
        success: function(result) {
            toast(result, datatable_name);
        }
    })
});

// ####################End Of Category Filter ################
// ###########################Recipe Type Filetr##############
$('.recipe_type_filter').change(function() {
    var recipe_type = $(this).val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "recipe_type": recipe_type,
        },
        url: "<?php echo e(route('recipe_type_filter')); ?>",
        success: function(result) {
            toast(result, datatable_name);
        }
    })
});
// #####################End Of Recipe Type Filter ############
// #############most_recommended Filter ###################
$('.most_recommended').click(function() {

    if ($(this).hasClass('btn-primary')) {
        $(this).removeClass('btn-primary');
        var status = "false";
    } else {
        $(this).addClass('btn-primary');
        var status = "true";
    }


    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "status": status
        },
        url: "<?php echo e(route('most_recommended_filter')); ?>",
        success: function(result) {
            toast(result, datatable_name);
        }
    })
});
// #############End most_recommended Filter ###################

// #######################Reset The Recipe Filter ##############
$('.reset_filter').click(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,

        },
        url: "<?php echo e(route('reset_recipe_filter')); ?>",
        success: function(result) {
            $('.category_filter').val(0).trigger('change');
            $('.recipe_type_filter').val(0).trigger('change');
            $('.most_recommended').removeClass('btn-primary');
            toast(result, datatable_name);
        }
    })

})

// ########################End Of Reset The Recipe Filter ############

// ################################Select Add On Option ################
function set_to_mutliselect() {

    var l = document.getElementById("recipe_add_on");
    multi(l, {
        non_selected_header: "Choose Adds on",
        selected_header: "Selected Adds On",
        options: [1, 2],

    }), l = document.getElementById("recipe_add_on1"), multi(l, {
        enable_search: !0
    })
}
set_to_mutliselect();
// ########################### End Of Select Add On Op;ton ##################

function set_add_on_options(total_add_on, recipe_add_on) {
    var option = "";
    for (var i = 0; i < total_add_on.length; i++) {
        // $('.recipe_add_on_colapse').addClass('show');
        var add_on_name = total_add_on[i]['add_on_name'];
        var add_on_id = total_add_on[i]['add_on_id'];
        option = option + '<option  value="' + add_on_id + '">' + add_on_name + '</option>'
    }
    $('.add_on_option_div').html(
        '<label for="validationTooltip02">Choose Add On(Optional)</label><select name="recipe_add_on[]" multiple id="recipe_add_on">' +
        option + '<select>');
    $('#recipe_add_on').val(recipe_add_on);
    set_to_mutliselect();

}


//Add New Row Section
function add_types_row() {
    var rowCount = $("#variant_type_tbody tr").length;
    var new_count = rowCount + 1;
    $('#variant_type_tbody').append(
        '<tr><td class="text-center"><div class="form-check"><input class="form-check-input default_recipe_class" type="checkbox" onclick="check_default_recipe(this)" name="default_recipe" value="' +
        new_count +
        '" id="flexCheckDefault"></label></div></td><td><input type="text" class="form-control" name="variant_name[]"> </td><td><input type="number" class="form-control" name="variant_price[]"></td><td class="text-center"><i class="fa fa-close" onclick="remove_row(this)"></i></td> </tr>'
    );


}

function add_property_row() {
    $('#properties_tbody').append(
        '<tr><td><input type="text" class="form-control" name="property_name[]"> </td><td class="text-center"><i class="fa fa-close" onclick="remove_row(this)"></i></td></tr>'
    );

}

function remove_row(element) {
    $(element).closest("tr").remove();
}
// $('.panel-collapse').removeClass('show');

function check_default_recipe(element) {

    $('.default_recipe_class').prop('checked', false);
    $(element).prop('checked', true);

}
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gocrispydmenus/public_html/resources/views/admin/recipe/index.blade.php ENDPATH**/ ?>