

<?php $__env->startSection('styles'); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- PAGE-HEADER -->
    <div class="page-header">
        <h1 class="page-title">Promotional Offers</h1>
        <div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Recipies</a></li>
                <li class="breadcrumb-item active" aria-current="page">Promotional Offers</li>
            </ol>
        </div>
    </div>
    <!-- PAGE-HEADER END -->

    <!-- ROW-1 OPEN -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['category-create','category-edit'])): ?>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Add Promotional Offers</h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                            <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                            <input id="category_id" name="category_id" type="hidden" value="">

                            <?php echo csrf_field(); ?>
                            <div class="form-row">
                                <div class="col-xl-3 mb-3">
                                    <label for="validationTooltip01">Title *</label>
                                    <input
                                        data-parsley-required-message="Title Required" type="text" class="form-control"
                                        name="title" id="title" value="" required>
                                </div>

                                <div class="col-xl-3 mb-3">
                                    <label for="validationTooltip01">Description *</label>
                                    <input
                                        data-parsley-required-message="Description Required"
                                        type="text" class="form-control" name="description" id="description" value=""
                                        required>
                                </div>

                                <div class="col-xl-3 mb-3">
                                    <label for="validationTooltip02">From Date *</label>
                                    <input type="date" data-parsley-required-message="From Date Requied" required
                                           class="form-control" name="from_date" id="from_date"
                                           value="">
                                </div>
                                <div class="col-xl-3 mb-3">
                                    <label for="validationTooltip02">To Date *</label>
                                    <input type="date" data-parsley-required-message="To Date Requied" required
                                           class="form-control" name="to_date" id="to_date"
                                           value="">
                                </div>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-create')): ?>
                                <a id="create_btn" href="#"
                                   onclick="createOrUpdate('add_promotional_offers', 'createForm', '', 'table_datatable','')"
                                   class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-edit')): ?>
                                <a id="update_btn" style="display: none" href="#"
                                   onclick="createOrUpdate('update_promotional_offers', 'createForm', '', 'table_datatable','')"
                                   class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- /ROW-1 CLOSED -->

    <!-- Row -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-list')): ?>
        <div class="row row-sm">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">View Promotional Ofers</h3>
                        
                        
                        
                        
                        
                        
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered text-nowrap border-bottom dataTable no-footer "
                                   style="width: 100% !important;" id="table_datatable">
                                <thead class="text-center">
                                <tr>
                                    <th class="wd-15p border-bottom-0">#</th>
                                    <th class="wd-15p border-bottom-0">Name</th>
                                    <th class="wd-15p border-bottom-0">Description</th>
                                    <th class="wd-15p border-bottom-0">From Date</th>
                                    <th class="wd-15p border-bottom-0">To Date</th>
                                    <th class="wd-10p border-bottom-0">Actions</th>
                                </tr>
                                </thead>

                            </table>

                            <div class="col-sm-12 col-md-12">
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </div>
    <?php endif; ?>
    <!-- End Row -->



    <!-- ####################################delete Modal ########################### -->
    <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bolder">Delete</h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Do you want to delete the category ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button onclick="delete_item()" class="btn btn-primary">Delete</button>
                </div>
            </div>
        </div>
    </div>
    <!-- ################################ delete Modal################################## -->
    <!-- ############################################Change Sort  Order ##########################              -->
    <div class="modal  fade" id="change_order" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">

                    <h5 class="modal-title fw-bolder">Change Category Sort Order</h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">


                    <div id="imageListId" class="row">
                        <?php $__currentLoopData = $category_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catmodal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div id="imageNo<?php echo e($catmodal->category_id); ?>"
                                 class="col-md-12 col-lg-6 col-xl-3 listitemClass">
                                <div class="thumbnail text-center">
                                    <a href="javascript:void(0)">
                                        <img src="<?php echo e(asset('/uploads/category_images/'.$catmodal->category_icon)); ?>"
                                             alt="thumb1" class="thumbimg">
                                    </a>
                                    <div class="caption ">
                                        <h4><strong><?php echo e($catmodal->category_name); ?></strong></h4>
                                    </div>
                                </div>
                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <input type="hidden" id="outputvalues">

                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-primary" data-bs-dismiss="modal" onclick="saveorder()">Update Order</button>
                </div>
            </div>
        </div>
    </div>
    <!-- ##################################################End Of Change View Order ############################ -->

    <!--  -->
    <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bolder" id="view_modal_title"></h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body" id="view_modal_body">

                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--  -->



<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    
    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css')); ?>">
    <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>

    <script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>

    
    <script>
        var token = $("meta[name=csrf-token]").attr("content");
        var public_url = "<?php echo e(url('/')); ?>/<?php echo e(env('ADMIN_PANEL_ROUTE')); ?>";
        var datatable_name = "table_datatable";
        $('#table_datatable').DataTable({
            "responsive": true,
            "serverSide": true,
            "ordering": true,
            "searching": true,
            "bLengthChange": true,
            "info": false,
            "bSort": true,
            "order": [
                [0, 'desc']
            ],
            "columnDefs": [{
                "targets": [0, 4],
                "orderable": true
            },
                {
                    "className": "text-center",
                    "targets": [0, 2, 3, 4]
                },
                {
                    "className": "text-left",
                    "targets": []
                }

            ],
            "displayLength": 10,
            "ajax": {
                "url": public_url + "/promotional_offers_datatable",
                "type": "post",
                "data": function (data) {
                    data._token = token;

                    return data;

                }
            },
            "AutoWidth": true,
            "columns": [
                {
                    "data": "id",
                    "name": "id"
                },
                {
                    "data": "title",
                    "name": "title"
                },
                {
                    "data": "description",
                    "name": "description"
                },
                {
                    "data": "from_date",
                    "name": "from_date"
                },
                {
                    "data": "to_date",
                    "name": "to_date"
                },
                {
                    "data": "id",
                    "name": "id"
                },
            ],

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                var info = this.dataTable().api().page.info();
                var page = info.page;
                var length = info.length;
                var index = (page * length + (iDataIndex + 1));
                var action = "";
                // if (aData.category_icon == "" || aData.category_icon == null) {
                //     aData.category_icon = "no_image.png";
                // }
                // var image = '<a href="/uploads/category_images/' + aData.category_icon +
                //     '" target="_blank"><img style="width:30px; height:30px" src="/uploads/category_images/' + aData
                //         .category_icon + '"></a>';
                //Edit Action
                var action = action + '&nbsp;<button title="View"  onclick=View(' + aData.id +
                    ') id="bEdit" type="button" class="btn btn-sm btn-success"><span class="fe fe-eye"> </span></button>';
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-edit')): ?>
                var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.id +
                    ') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
                <?php endif; ?>
                //Delete Action




                $('td:eq(0)', nRow).html(index);
                //$('td:eq(2)', nRow).html(image);
                $('td:eq(5)', nRow).html(action);
            }
        });

        // #################### View Section ############################
        function View(id) {
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": id
                },
                url: public_url + '/promotional_offers_view',
                success: function (result) {
                    $('#view_modal_title').text('Promotional Offers Details');
                    $('#view_modal_body').html(result);
                    $('#scrollingmodal').modal('show');
                }
            })
        }

        //#######################End Of View Section ##################
        // #################### Edit Section ############################
        function edit(id) {
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": id
                },
                url: public_url + '/edit_promotional_offers',
                success: function (result) {
                    $('#category_id').val(result.id);
                    $('#title').val(result.title);
                    $('#description').val(result.description);
                    $('#to_date').val(result.to_date);
                    $('#from_date').val(result.from_date);

                    $('#create_btn').hide();
                    $('#update_btn').show();
                    $('#back-to-top').click();

                }
            })
        }

        // #################### End Of Edit Section ####################
        // #################### Delete Section ##########################
        function delete_modal(id) {
            $('#category_id').val(id);
            $('#smallmodal').modal('show');
        }

        function delete_item() {
            var id = $('#category_id').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": id
                },
                url: public_url + '/delete_category',
                success: function (result) {
                    $('#smallmodal').modal('hide');
                    toast(result, datatable_name);
                }
            })
        }

        // #################### End Of Delete Section ##################


        $(function () {
            $("#imageListId").sortable({
                update: function (event, ui) {
                    getIdsOfImages();
                } //end update
            });
        });

        function getIdsOfImages() {
            var values = [];
            $('.listitemClass').each(function (index) {
                values.push($(this).attr("id")
                    .replace("imageNo", ""));
            });

            $('#savebtnget').css('display', 'inline-block')
            $('#outputvalues').val(values);
        }

        function saveorder() {
            var catarray = $('#outputvalues').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "catarray": catarray
                },
                url: "<?php echo e(route('category_change_order')); ?>",
                success: function (result) {
                    $('#change_order').modal('hide');
                    toast(result, datatable_name);
                    setTimeout(function () {
                        location.reload();
                    }, 2000);

                }
            });
        }
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gocrispydmenus/public_html/albaitalkuwaiti.dmenus.com/resources/views/admin/recipe/promotional_offers/index.blade.php ENDPATH**/ ?>