<?php

use App\Http\Controllers\Controller;
use App\Http\Controllers\authController;
use App\Http\Controllers\LoyaltyProgramController;
use App\Http\Controllers\userController;
use App\Http\Controllers\rolesController;
use App\Http\Controllers\pdfController;
use App\Http\Controllers\excelController;
use App\Http\Controllers\permisionController;
use App\Http\Controllers\websiteController;
use App\Http\Controllers\customerController;
use App\Http\Controllers\reportController;
use App\Http\Controllers\layoutController;
use App\Http\Controllers\languageController;
use App\Http\Controllers\apiController;
use App\Http\Controllers\subscriptionController;
use App\Http\Controllers\categoryController;
use App\Http\Controllers\subcategoryController;
use App\Http\Controllers\recipeController;
use App\Http\Controllers\tableController;
use App\Http\Controllers\pointController;
use App\Http\Controllers\giftcardController;
use App\Http\Controllers\promocodeController;
use App\Http\Controllers\promotionController;
use App\Http\Controllers\sectionController;
use App\Http\Controllers\recipe_add_on_Controller;
use App\Http\Controllers\imageresolutionController;
use App\Http\Controllers\orderController;
use App\Http\Controllers\bannerController;
use App\Http\Controllers\stockController;
use App\Http\Controllers\posController;
use App\Http\Controllers\inventoryController;
use App\Http\Controllers\RecipeImportController;

####################################Website Section #######################################

Route::middleware([website::class])->group(
    function () {
        Route::get('/', [websiteController::class, 'index'])->name('website_home');
        Route::get('/menu', [websiteController::class, 'menu'])->name('website_menu');
        Route::get('/search/{search_key}', [websiteController::class, 'search'])->name('search');
        Route::get('category/{category_link}', [websiteController::class, 'category_page'])->name('website_category');
        Route::get('recipe/{recipe_link}', [websiteController::class, 'recipe_page'])->name('recipe_page');
        Route::get('view-cart', [websiteController::class, 'view_cart'])->name('view_cart');
        Route::post('website_recipe_filter', [websiteController::class, 'website_recipe_filter'])->name('website_recipe_filter');
        Route::post('/search_item', [websiteController::class, 'search_item'])->name('search_item');
        Route::get('/checkout', [websiteController::class, 'checkout'])->name('checkout');
//order trancking
        Route::get('/order_tracking/{id}', [websiteController::class, 'order_tracking'])->name('website_home');

//Cart Section
        Route::post('/cart_basic_details', [websiteController::class, 'cart_basic_details'])->name('cart_basic_details');
        Route::post('/add_to_cart', [websiteController::class, 'add_to_cart'])->name('add_to_cart');
        Route::post('/change_cart_quantity', [websiteController::class, 'change_cart_quantity'])->name('change_cart_quantity');
        Route::post('/remove_from_cart', [websiteController::class, 'remove_from_cart'])->name('remove_from_cart');
        Route::post('/get_cart_items', [websiteController::class, 'get_cart_items'])->name('get_cart_items');
        Route::post('/update_customize_section', [websiteController::class, 'update_customize_section'])->name('update_customize_section');
        Route::post('/change_cart_addon', [websiteController::class, 'change_cart_addon'])->name('change_cart_addon');
        Route::post('/check_promocode', [websiteController::class, 'check_promocode'])->name('check_promocode');
        Route::post('/create_order', [websiteController::class, 'create_order'])->name('create_order');
        Route::post('/proceed_to_ckeckout', [websiteController::class, 'proceed_to_ckeckout'])->name('proceed_to_ckeckout');

        Route::get('order-success', [websiteController::class, 'order_success'])->name('order_success')->middleware('ordersuccess');
        Route::post('/modify_order', [websiteController::class, 'modify_order'])->name('modify_order');
        Route::post('/cancel_order_by_customer', [websiteController::class, 'cancel_order_by_customer'])->name('cancel_order_by_customer');


    });


Route::get('signout', [authController::class, 'signOut'])->name('signout');
Route::any('payment_response', [orderController::class, 'payment_response'])->name('payment_response');
Route::any('payment/{order_id}/{amount}', [websiteController::class, 'payment'])->name('payment');
Route::any('tesspayment/{order_id}/{amount}', [websiteController::class, 'tesspayment'])->name('tesspayment');

####################################End Of Website Section ################################
####################################Admin Secion ###########################################

Route::group(['namespace' => env('ADMIN_PANEL_ROUTE'), 'prefix' => env('ADMIN_PANEL_ROUTE')], function () {
    Route::get('', [authController::class, 'index'])->name('login');
    Route::post('/custom-login', [authController::class, 'customLogin'])->name('login.custom');
    // Route::get('dashboard', [authController::class, 'dashboard'])->middleware('auth_check');

    Route::middleware([auth_check::class])->group(
        function () {
            Route::get('dashboard', [authController::class, 'dashboard']);
            Route::get('signout', [authController::class, 'signOut'])->name('signout');
            Route::post('set_light_mode', [Controller::class, 'set_light_mode'])->name('set_light_mode');
            Route::post('set_side_menu_view', [Controller::class, 'set_side_menu_view'])->name('set_side_menu_view');
            Route::post('set_sound_status', [Controller::class, 'set_sound_status'])->name('set_sound_status');
            Route::post('check_active_notification', [Controller::class, 'check_active_notification'])->name('check_active_notification');
            Route::post('update_active_notification', [Controller::class, 'update_active_notification'])->name('update_active_notification');
            Route::post('get_table_datas', [Controller::class, 'get_table_datas'])->name('get_table_datas');
            Route::post('update_table_status', [Controller::class, 'update_table_status'])->name('update_table_status');

            ###############################Profile Edit##################################
            Route::get('users', [userController::class, 'index']);
            Route::post('/update_user_details', [userController::class, 'update_user_details']);
            Route::post('/update_password', [userController::class, 'update_password']);
            ######################################################################
            ###############################Manage User##################################
            Route::get('bulk_order', [orderController::class, 'bulk_order'])->name('bulk_order');
            Route::post('add_bulk_order', [orderController::class, 'add_bulk_order'])->name('add_bulk_order');
            Route::get('manage-working-time', [userController::class, 'manage_working_time'])->name('manage_working_time');
            Route::post('update_working_time', [userController::class, 'update_working_time'])->name('update_working_time');
            Route::get('manage-off-days', [userController::class, 'manage_off_days'])->name('manage_off_days');
            Route::post('update_off_days', [userController::class, 'update_off_days'])->name('update_off_days');
            Route::get('manage-users', [userController::class, 'manage_user'])->name('manage_user');
            Route::post('add_user', [userController::class, 'add_user'])->name('add_user');
            Route::post('/user_datatable', [userController::class, 'user_datatable']);
            Route::post('/delete_user', [userController::class, 'delete_user']);
            Route::post('/edit_user', [userController::class, 'edit_user']);
            Route::post('/update_user', [userController::class, 'update_user']);
            Route::post('/user_view', [userController::class, 'user_view']);
            Route::post('/change_user_active_status', [userController::class, 'change_user_active_status']);
            ###############################Manage User##################################

            ###############################Manage Roles##################################
            Route::get('manage-roles', [rolesController::class, 'index']);
            Route::post('/roles_datatable', [rolesController::class, 'roles_datatable']);
            Route::post('/add_role', [rolesController::class, 'add_role']);
            Route::post('/edit_role', [rolesController::class, 'edit_role']);
            Route::post('/update_role', [rolesController::class, 'update_role']);
            Route::post('/delete_role', [rolesController::class, 'delete_role']);
            Route::post('/role_view', [rolesController::class, 'role_view']);
            ######################################################################


            ################################## User Activity Log##################
            Route::get('user-activity', [userController::class, 'user_activity'])->name('user_activity');
            Route::post('user_activity_datatable', [userController::class, 'user_activity_datatable'])->name('user_activity_datatable');
            Route::post('filter_user', [userController::class, 'filter_user'])->name('filter_user');

            ##################################End of User Activity Log##################


            // #####################################banner Section #######################
            Route::get('banner', [bannerController::class, 'index'])->name('banner');
            Route::post('/add_banner', [bannerController::class, 'add_banner'])->name('add_banner');
            Route::post('/banner_datatable', [bannerController::class, 'banner_datatable'])->name('banner_datatable');
            Route::post('/change_banner_status', [bannerController::class, 'change_banner_status'])->name('change_banner_status');
            Route::post('/edit_banner', [bannerController::class, 'edit_banner'])->name('edit_banner');
            Route::post('/update_banner', [bannerController::class, 'update_banner'])->name('update_banner');
            Route::post('/delete_banner', [bannerController::class, 'delete_banner'])->name('delete_banner');
            Route::post('/view_banner', [bannerController::class, 'view_banner'])->name('view_banner');
            Route::post('/banner_change_order', [bannerController::class, 'banner_change_order'])->name('banner_change_order');

            // #############################End Of Banner Section  #####################################

            #########################  Customers###################################
            Route::any('download_customer', [customerController::class, 'download_customer'])->name('download.customer');
            Route::get('customers', [customerController::class, 'index'])->name('customers');
            Route::post('/add_customer', [customerController::class, 'add_customer']);
            Route::post('/customer_datatable', [customerController::class, 'customer_datatable']);
            Route::post('/edit_customer', [customerController::class, 'edit_customer']);
            Route::post('/update_customer', [customerController::class, 'update_customer']);
            Route::post('/delete_customer', [customerController::class, 'delete_customer']);
            Route::post('/view_customer', [customerController::class, 'view_customer']);
            Route::get('/customer_orders/{id}', [customerController::class, 'customer_orders']);
            Route::get('/cart_activities/{id}', [customerController::class, 'cart_activities']);
            #######################################################################


            Route::post('/get_tracking', [orderController::class, 'get_tracking']);
            Route::post('/get_tracking2', [orderController::class, 'get_tracking2']);
            Route::post('/change_tracking', [orderController::class, 'change_tracking']);
            Route::post('/change_tracking2', [orderController::class, 'change_tracking2']);
            Route::post('/change_branch', [orderController::class, 'change_branch']);

            #################################Language###############################
            Route::get('add-language', [languageController::class, 'index']);
            Route::post('/add_language', [languageController::class, 'add_language']);
            Route::post('/language_datatable', [languageController::class, 'language_datatable']);
            Route::post('/edit_language', [languageController::class, 'edit_language']);
            Route::post('/update_language', [languageController::class, 'update_language']);
            Route::post('/delete_language', [languageController::class, 'delete_language']);
            Route::post('/change_language_active_status', [languageController::class, 'change_language_active_status']);


            #################################End Language#############################

            Route::get('promotional_offers', [categoryController::class, 'promotional_offers'])->name('promotional_offers');
            Route::post('/add_promotional_offers', [categoryController::class, 'add_promotional_offers']);
            Route::post('/promotional_offers_datatable', [categoryController::class, 'promotional_offers_datatable']);
            Route::post('/promotional_offers_view', [categoryController::class, 'promotional_offers_view'])->name('promotional_offers_view');
            Route::post('/edit_promotional_offers', [categoryController::class, 'edit_promotional_offers']);
            Route::post('/update_promotional_offers', [categoryController::class, 'update_promotional_offers']);

            Route::get('visitors', [\App\Http\Controllers\customerController::class, 'visitors'])->name('visitors');
            Route::post('visitors_datatable', [\App\Http\Controllers\customerController::class, 'visitors_datatable'])->name('visitors_datatable');

            Route::get('payment_method', [\App\Http\Controllers\FaqController::class, 'payment_method'])->name('payment_method');
            Route::post('add_payment_method', [\App\Http\Controllers\FaqController::class, 'add_payment_method'])->name('add_payment_method');
            Route::post('payment_method_datatable', [\App\Http\Controllers\FaqController::class, 'payment_method_datatable'])->name('payment_method_datatable');
            Route::post('edit_payment_method', [\App\Http\Controllers\FaqController::class, 'edit_payment_method'])->name('edit_payment_method');
            Route::post('update_payment_method', [\App\Http\Controllers\FaqController::class, 'update_payment_method'])->name('update_payment_method');
            Route::post('delete_payment_method', [\App\Http\Controllers\FaqController::class, 'delete_payment_method'])->name('delete_payment_method');
            Route::post('change_status_payment', [\App\Http\Controllers\FaqController::class, 'change_status_payment'])->name('change_status_payment');

            Route::get('faq', [\App\Http\Controllers\FaqController::class, 'index'])->name('faq');
            Route::post('/add_faq', [\App\Http\Controllers\FaqController::class, 'add_faq']);
            Route::post('/faq_datatable', [\App\Http\Controllers\FaqController::class, 'faq_datatable']);
            Route::post('/faq_view', [\App\Http\Controllers\FaqController::class, 'faq_view'])->name('faq_view');
            Route::post('/edit_faq', [\App\Http\Controllers\FaqController::class, 'edit_faq']);
            Route::post('/update_faq', [\App\Http\Controllers\FaqController::class, 'update_faq']);
            Route::post('/delete_faq', [\App\Http\Controllers\FaqController::class, 'delete_faq']);

            Route::prefix('loyalty')->group(function () {
                Route::get('/', [LoyaltyProgramController::class, 'index'])->name('loyalty.index');
                Route::get('/create', [LoyaltyProgramController::class, 'create'])->name('loyalty.create');
                Route::post('/store', [LoyaltyProgramController::class, 'store'])->name('loyalty.store');
                Route::get('/edit/{id}', [LoyaltyProgramController::class, 'edit'])->name('loyalty.edit');
                Route::post('/update/{id}', [LoyaltyProgramController::class, 'update'])->name('loyalty.update');
                Route::get('/delete/{id}', [LoyaltyProgramController::class, 'destroy'])->name('loyalty.delete');
            });


            Route::get('/messages', [\App\Http\Controllers\FaqController::class, 'messages'])->name('messages');
            Route::post('/update_messages', [\App\Http\Controllers\FaqController::class, 'update_messages'])->name('update_messages');

            ################################categories###############################
            Route::get('categories', [categoryController::class, 'index'])->name('category');
            Route::post('/add_category', [categoryController::class, 'add_category']);
            Route::post('/category_datatable', [categoryController::class, 'category_datatable']);
            Route::post('/edit_category', [categoryController::class, 'edit_category']);
            Route::post('/update_category', [categoryController::class, 'update_category']);
            Route::post('/delete_category', [categoryController::class, 'delete_category']);
            Route::post('/category_change_order', [categoryController::class, 'change_order'])->name('category_change_order');
            Route::post('/category_view', [categoryController::class, 'category_view'])->name('category_view');
            ################################End Of categories###############################
            ################################Subcategories###############################
            Route::get('subcategories', [subcategoryController::class, 'index'])->name('subcategory');
            Route::post('/add_subcategory', [subcategoryController::class, 'add_subcategory'])->name('add_subcategory');
            Route::post('/subcategory_datatable', [subcategoryController::class, 'subcategory_datatable'])->name('subcategory_datatable');
            Route::post('/edit_subcategory', [subcategoryController::class, 'edit_subcategory'])->name('edit_subcategory');
            Route::post('/update_subcategory', [subcategoryController::class, 'update_subcategory']);
            Route::post('/delete_subcategory', [subcategoryController::class, 'delete_subcategory'])->name('delete_subcategory');
            Route::post('/sub_category_change_order', [subcategoryController::class, 'change_order'])->name('subcategory_change_order');
            Route::post('/subcategory_view', [subcategoryController::class, 'subcategory_view'])->name('subcategory_view');
            ################################End Of Subcategories###############################

            ##########################Recipe  Secton#####################################
            Route::get('recipies', [recipeController::class, 'index'])->name('recipe');
            Route::post('recipe_datatable', [recipeController::class, 'recipe_datatable'])->name('recipe_datatable');
            Route::post('fetch_subcategory', [recipeController::class, 'fetch_subcategory'])->name('fetch_subcategory');
            Route::post('add_recipe', [recipeController::class, 'add_recipe'])->name('add_recipe');
            Route::post('delete_recipe', [recipeController::class, 'delete_recipe'])->name('delete_recipe');
            Route::post('edit_recipe', [recipeController::class, 'edit_recipe'])->name('edit_recipe');
            Route::post('update_recipe', [recipeController::class, 'update_recipe'])->name('update_recipe');
            Route::post('/view_recipe', [recipeController::class, 'view_recipe'])->name('view_recipe');
            Route::post('/change_status', [recipeController::class, 'change_status'])->name('change_status');
            Route::post('/change_recommended_status', [recipeController::class, 'change_recommended_status'])->name('change_recommended_status');
            Route::post('/category_wise_filter', [recipeController::class, 'category_wise_filter'])->name('category_wise_filter');
            Route::post('/recipe_type_filter', [recipeController::class, 'recipe_type_filter'])->name('recipe_type_filter');
            Route::post('/most_recommended_filter', [recipeController::class, 'most_recommended_filter'])->name('most_recommended_filter');
            Route::post('/reset_recipe_filter', [recipeController::class, 'reset_recipe_filter'])->name('reset_recipe_filter');
            #######################################################################
            ################################Table Section #############################
            Route::get('recipe_adds_on', [recipe_add_on_Controller::class, 'index'])->name('recipe_adds_on');
            Route::post('add_add_on_recipe', [recipe_add_on_Controller::class, 'add_add_on_recipe'])->name('add_add_on_recipe');
            Route::post('add_on_datatable', [recipe_add_on_Controller::class, 'add_on_datatable'])->name('add_on_datatable');
            Route::post('view_add_on', [recipe_add_on_Controller::class, 'view_add_on'])->name('view_add_on');
            Route::post('change_add_on__status', [recipe_add_on_Controller::class, 'change_add_on__status'])->name('change_add_on__status');
            Route::post('edit_add_on', [recipe_add_on_Controller::class, 'edit_add_on'])->name('edit_add_on');
            Route::post('update_add_on_recipe', [recipe_add_on_Controller::class, 'update_add_on_recipe'])->name('update_add_on_recipe');
            Route::post('delete_add_on', [recipe_add_on_Controller::class, 'delete_add_on'])->name('delete_add_on');


            ################################ End Table Section ##########################

            ################################Table Section #############################
            Route::get('manage_table', [tableController::class, 'index'])->name('manage_table');
            Route::post('/add_table', [tableController::class, 'add_table'])->name('add_table');
            Route::post('/table_datatable', [tableController::class, 'table_datatable'])->name('table_datatable');
            Route::post('/change_table_status', [tableController::class, 'change_table_status'])->name('change_table_status');
            Route::post('/edit_table', [tableController::class, 'edit_table'])->name('edit_table');
            Route::post('/update_table', [tableController::class, 'update_table'])->name('update_table');
            Route::post('/delete_res_table', [tableController::class, 'delete_res_table'])->name('delete_res_table');
            #############################End OfTable Section #############################

            #############################Points###############################
            Route::get('/manage_points', [pointController::class, 'index'])->name('manage_points');
            Route::post('/update_points', [pointController::class, 'update_points'])->name('update_points');
            ##################################################################


            #################################manage-layout###############################
            Route::get('layout', [layoutController::class, 'index']);
            Route::post('add_website_layout', [layoutController::class, 'add_website_layout'])->name('add_website_layout');
            #################################End Of layout###############################
            #############################Gift Card###############################
            Route::get('manage_giftcard', [giftcardController::class, 'index'])->name('manage_giftcard');
            Route::post('/add_giftcard', [giftcardController::class, 'add_giftcard'])->name('add_giftcard');
            Route::post('/giftcard_datatable', [giftcardController::class, 'giftcard_datatable'])->name('giftcard_datatable');
            Route::post('/change_giftcard_status', [giftcardController::class, 'change_giftcard_status'])->name('change_giftcard_status');
            Route::post('/edit_giftcard', [giftcardController::class, 'edit_giftcard'])->name('edit_giftcard');
            Route::post('/update_giftcard', [giftcardController::class, 'update_giftcard'])->name('update_giftcard');
            Route::post('/delete_giftcard', [giftcardController::class, 'delete_giftcard'])->name('delete_giftcard');
            ##################################################################

            ############################Promocodes ###############################
            Route::get('manage_promocode', [promocodeController::class, 'index'])->name('manage_promocode');
            Route::post('/add_promocode', [promocodeController::class, 'add_promocode'])->name('add_promocode');
            Route::post('/change_promocode_status', [promocodeController::class, 'change_promocode_status'])->name('change_promocode_status');
            Route::post('/edit_promocode', [promocodeController::class, 'edit_promocode'])->name('edit_promocode');
            Route::post('/update_promocode', [promocodeController::class, 'update_promocode'])->name('update_promocode');
            Route::post('/delete_promocode', [promocodeController::class, 'delete_promocode'])->name('delete_promocode');
            Route::post('/promocode_datatable', [promocodeController::class, 'promocode_datatable'])->name('promocode_datatable');
            ##################################################################

            ############################ Promotions ######################
            Route::get('manage-promotions', [promotionController::class, 'index'])->name('manage-promotions');
            Route::post('/add_promotion', [promotionController::class, 'add_promotion'])->name('add_promotion');
            Route::post('/promotion_datatable', [promotionController::class, 'promotion_datatable'])->name('promotion_datatable');
            Route::post('/change_promotion_status', [promotionController::class, 'change_promotion_status'])->name('change_promotion_status');
            Route::post('/edit_promotion', [promotionController::class, 'edit_promotion'])->name('edit_promotion');
            Route::post('/update_promotion', [promotionController::class, 'update_promotion'])->name('update_promotion');
            Route::post('/delete_promotion', [promotionController::class, 'delete_promotion'])->name('delete_promotion');
            ##################################################################
            ############################ Section ######################
            Route::get('section', [sectionController::class, 'index'])->name('section');
            Route::post('/add_section', [sectionController::class, 'add_section'])->name('add_section');
            Route::post('/section_datatable', [sectionController::class, 'section_datatable'])->name('section_datatable');
            Route::post('/change_section_status', [sectionController::class, 'change_section_status'])->name('change_section_status');
            Route::post('/edit_section', [sectionController::class, 'edit_section'])->name('edit_section');
            Route::post('/update_section', [sectionController::class, 'update_section'])->name('update_section');
            Route::post('/delete_section', [sectionController::class, 'delete_section'])->name('delete_section');
            Route::post('/section_view', [sectionController::class, 'section_view'])->name('section_view');
            Route::post('/section_remove_recipe', [sectionController::class, 'section_remove_recipe'])->name('section_remove_recipe');

            ##################################################################

            #######################################Order Section ################
            Route::get('bulk_delivery_note', [orderController::class, 'bulk_delivery_note'])->name('bulk_delivery_note');
            Route::post('update_delivery_note', [orderController::class, 'update_delivery_note'])->name('update_delivery_note');
            Route::get('view-bulk-orders', [orderController::class, 'bulk_order_index'])->name('view-bulk-orders');
            Route::get('view-orders', [orderController::class, 'index'])->name('view-orders');
            Route::post('order_datattable', [orderController::class, 'order_datattable'])->name('order_datattable');
            Route::post('bulk_order_datattable', [orderController::class, 'bulk_order_datattable'])->name('bulk_order_datattable');
            Route::post('order_datattable2', [orderController::class, 'order_datattable2'])->name('order_datattable2');
            Route::post('view-order2', [orderController::class, 'vieworder2'])->name('view-order2');
            Route::post('view-order', [orderController::class, 'vieworder'])->name('view-order');
            Route::post('order_from_date_filter', [orderController::class, 'order_from_date_filter'])->name('order_from_date_filter');
            Route::post('order_to_date_filter', [orderController::class, 'order_to_date_filter'])->name('order_to_date_filter');
            Route::post('change_status2', [orderController::class, 'change_status2'])->name('change_status2');
            Route::post('cancel_order', [orderController::class, 'cancel_order'])->name('cancel_order');
            Route::post('cancel_order2', [orderController::class, 'cancel_order2'])->name('cancel_order2');
            Route::post('approve_order', [orderController::class, 'approve_order'])->name('approve_order');
            Route::get('print_order', [orderController::class, 'print_order'])->name('print_order');
            Route::get('order_status', [orderController::class, 'order_status'])->name('order_status');
            Route::post('status_datatable', [orderController::class, 'status_datatable'])->name('status_datatable');
            Route::post('edit_status', [orderController::class, 'edit_status'])->name('edit_status');
            Route::post('update_status', [orderController::class, 'update_status'])->name('update_status');
            Route::post('status_view', [orderController::class, 'status_view'])->name('status_view');


            ############################End Of Order Sectiion ###############


            ############################ Import from Excel ###############
            Route::get('/import-recipes', [RecipeImportController::class, 'showImportForm'])->name('import-recipes');
            Route::post('/import-recipes-post', [RecipeImportController::class, 'import'])->name('import-recipes.post');
            Route::get('/import-recipes-post', [RecipeImportController::class, 'import'])->name('import-recipes.post');
            ############################ End of Import from Excel ###############


            Route::post('from_date_filter', [Controller::class, 'from_date_filter'])->name('from_date_filter');
            Route::post('to_date_filter', [Controller::class, 'to_date_filter'])->name('to_date_filter');
            Route::post('reset_session', [userController::class, 'reset_session'])->name('reset_session');


            #########################API Section ############################
            Route::get('automation-integration', [apiController::class, 'index'])->name('automation-integration');
            Route::post('update_automation_integration', [apiController::class, 'update_api_integration'])->name('update_automation_integration');
            ########################End Of API Section ####################
#########################Manage Subscription ################
            Route::get('manage-subscription', [subscriptionController::class, 'index'])->name('manage-subscription');
            Route::post('add_subscription', [subscriptionController::class, 'add_subscription'])->name('add_subscription');
            Route::post('subscription_datatable', [subscriptionController::class, 'subscription_datatable'])->name('subscription_datatable');
            Route::post('edit_subscription', [subscriptionController::class, 'edit_subscription'])->name('edit_subscription');
            Route::post('update_subscription', [subscriptionController::class, 'update_subscription'])->name('update_subscription');
            Route::post('delete_subscription', [subscriptionController::class, 'delete_subscription'])->name('delete_subscription');
            Route::post('view_subscritpion', [subscriptionController::class, 'view_subscritpion'])->name('view_subscritpion');
            ##########################End Of Manage Subscription ###########
##########################Subscription Packages ################
            Route::get('subscription-packages', [subscriptionController::class, 'subscription_packages'])->name('subscription-packages');
            Route::post('subscribe', [subscriptionController::class, 'subscribe'])->name('subscribe');
            Route::get('subscription-history', [subscriptionController::class, 'subscription_history'])->name('subscription-history');
            #######################End Of Subscription Packages########
####################Manage Subscription ###################
            Route::get('custom-subscription', [subscriptionController::class, 'custom_subscription'])->name('custom-subscription');
            Route::post('add_custom_subscription', [subscriptionController::class, 'add_custom_subscription'])->name('add_custom_subscription');
            Route::post('subscription_history_datatable', [subscriptionController::class, 'subscription_history_datatable'])->name('subscription_history_datatable');
            ################End Of Manage Subscription ###############

            ####################Manage Image Resolution ###################
            Route::get('manage-image-resolutions', [imageresolutionController::class, 'index'])->name('manage-image-resolutions');
            Route::post('image_resolution_update', [imageresolutionController::class, 'image_resolution_update'])->name('image_resolution_update');
            ################End Of Manage Image Resolution ###############

            ##############################Stock Section#####################


            Route::get('stock', [stockController::class, 'index'])->name('stock');
            Route::post('stock_datatable', [stockController::class, 'stock_datatable'])->name('stock_datatable');
            Route::post('update_stock', [stockController::class, 'update_stock'])->name('update_stock');

            //Stock log Section
            Route::get('stock-log', [stockController::class, 'stock_log'])->name('stock-log');
            Route::post('stock_log_datatable', [stockController::class, 'stock_log_datatable'])->name('stock_log_datatable');
            //End Of Stock Log Section

            ##########################End of Stock Section#####################



            ####################Report Section##########################
            Route::group(['namespace' => 'report', 'prefix' => 'report'], function () {
                //daily Report Section
                Route::get('daily_wise', [reportController::class, 'daily_wise'])->name('daily_wise');
                Route::post('daily_wise_datatable', [reportController::class, 'daily_wise_datatable'])->name('daily_wise_datatable');
                Route::get('daily_report_excel_export', [reportController::class, 'daily_report_excel_export'])->name('daily_report_excel_export');
                Route::get('daily_report_pdf_export', [reportController::class, 'daily_report_pdf_export'])->name('daily_report_pdf_export');

                //End Of Daily report Section
                //Monthly Report Section
                Route::get('monthly_wise', [reportController::class, 'monthly_wise'])->name('monthly_wise');
                Route::post('month_wise_datatable', [reportController::class, 'month_wise_datatable'])->name('month_wise_datatable');
                Route::get('monthly_report_excel_export', [reportController::class, 'monthly_report_excel_export'])->name('monthly_report_excel_export');
                Route::get('monthly_report_pdf_export', [reportController::class, 'monthly_report_pdf_export'])->name('monthly_report_pdf_export');
                //End Of Monthly Report Section

                //Customer Wise Report
                Route::get('customer_wise', [reportController::class, 'customer_wise'])->name('customer_wise');
                Route::post('customer_wise_datatable', [reportController::class, 'customer_wise_datatable'])->name('customer_wise_datatable');
                Route::get('customer_report_excel_export', [reportController::class, 'customer_report_excel_export'])->name('customer_report_excel_export');
                Route::get('customer_report_pdf_export', [reportController::class, 'customer_report_pdf_export'])->name('customer_report_pdf_export');

                //End Of Customer wise Report
                //Item Wise Report
                Route::get('item_wise', [reportController::class, 'item_wise'])->name('item_wise_report');
                Route::post('most_sold_item_datatable', [reportController::class, 'most_sold_item_datatable'])->name('most_sold_item_datatable');
                Route::get('sold_item_excel_export', [reportController::class, 'sold_item_excel_export'])->name('sold_item_excel_export');
                Route::get('sold_item_pdf_export', [reportController::class, 'sold_item_pdf_export'])->name('sold_item_pdf_export');

                //End Of Item Wise Report


                ########################################Sale Report Section #############################
                //daily Report Section
                Route::get('daily_wise_sale', [reportController::class, 'daily_wise_sale'])->name('daily_wise_sale');
                Route::post('daily_wise_datatable_sale', [reportController::class, 'daily_wise_datatable_sale'])->name('daily_wise_datatable_sale');
                Route::get('daily_report_excel_export_sale', [reportController::class, 'daily_report_excel_export_sale'])->name('daily_report_excel_export_sale');
                Route::get('daily_report_pdf_export_sale', [reportController::class, 'daily_report_pdf_export_sale'])->name('daily_report_pdf_export_sale');

                //End Of Daily report Section

                //Monthly Sale Report Section
                Route::get('monthly_wise_sale', [reportController::class, 'monthly_wise_sale'])->name('monthly_wise_sale');
                Route::post('month_wise_datatable_sale', [reportController::class, 'month_wise_datatable_sale'])->name('month_wise_datatable_sale');
                Route::get('monthly_report_excel_export_sale', [reportController::class, 'monthly_report_excel_export_sale'])->name('monthly_report_excel_export_sale');
                Route::get('monthly_report_pdf_exports_sale', [reportController::class, 'monthly_report_pdf_exports_sale'])->name('monthly_report_pdf_export_sale');
                //End Of Monthly Sale Report Section

                //Item Wise Report
                Route::get('item_wise_report_sale', [reportController::class, 'item_wise_report_sale'])->name('item_wise_report_sale');
                Route::post('most_sold_item_datatable_sale', [reportController::class, 'most_sold_item_datatable_sale'])->name('most_sold_item_datatable_sale');
                Route::get('sold_item_excel_export_sale', [reportController::class, 'sold_item_excel_export_sale'])->name('sold_item_excel_export_sale');
                Route::get('sold_item_pdf_export_sale', [reportController::class, 'sold_item_pdf_export_sale'])->name('sold_item_pdf_export_sale');

                //End Of Item Wise Report


                ########################################End Of Sale Report #############################


            });

            ###################end of Report Section ##################

            ####################################################Pos Section ###############################
            Route::get('pos', [posController::class, 'pos'])->name('pos_module');
            Route::post('pos_categories', [posController::class, 'pos_categories'])->name('pos_categories');
            Route::post('category_wise_item', [posController::class, 'category_wise_item'])->name('category_wise_item');
            Route::post('recipe_wise_varient', [posController::class, 'recipe_wise_varient'])->name('recipe_wise_varient');
            Route::post('search_term', [posController::class, 'search_term'])->name('search_term');
            Route::post('add_customer_via_pos', [posController::class, 'add_customer_via_pos'])->name('add_customer_via_pos');
            Route::post('customer_autocomplete', [posController::class, 'customer_autocomplete'])->name('customer_autocomplete');
            Route::post('offer_code_fetching', [posController::class, 'offer_code_fetching'])->name('offer_code_fetching');
            Route::post('create_invoice', [posController::class, 'create_invoice'])->name('create_invoice');
            Route::get('order-invoice/{order_id}', [posController::class, 'order_invoice'])->name('order-invoice');
            Route::post('recent_invoices', [posController::class, 'recent_invoices'])->name('recent_invoices');

            ################################################### END OF POS SECTION ########################

            ########################################Invoice Section ###############################
            Route::get('invoice', [inventoryController::class, 'index'])->name('invoice');
            Route::get('invoice-print/{invoice_id}', [inventoryController::class, 'invoice_print'])->name('invoice-print');
            Route::post('view_invoice', [inventoryController::class, 'view_invoice'])->name('view_invoice');
            Route::post('invoice_datattable', [inventoryController::class, 'invoice_datattable'])->name('invoice_datattable');
            Route::post('invoice_from_date_filter', [inventoryController::class, 'invoice_from_date_filter'])->name('invoice_from_date_filter');
            Route::post('invoice_to_date_filter', [inventoryController::class, 'invoice_to_date_filter'])->name('invoice_to_date_filter');

            ######################################End Of Invoice Section #######################


        });


});

Route::get('/page-not-found', [websiteController::class, 'not_found_404'])->name('404')->middleware('website');;;
Route::get('/{permalink}', [websiteController::class, 'not_found_404'])->name('not_found_404')->middleware('website');;;










// use App\Http\Livewire\About;
// use App\Http\Livewire\Accordion;
// use App\Http\Livewire\AddProduct;
// use App\Http\Livewire\Alerts;
// use App\Http\Livewire\AvatarRadius;
// use App\Http\Livewire\AvatarRound;
// use App\Http\Livewire\Avatarsquare;
// use App\Http\Livewire\Badge;
// use App\Http\Livewire\Blog;
// use App\Http\Livewire\BlogDetails;
// use App\Http\Livewire\BlogPost;
// use App\Http\Livewire\Breadcrumbs;
// use App\Http\Livewire\Buttons;
// use App\Http\Livewire\Calendar;
// use App\Http\Livewire\Calendar2;
// use App\Http\Livewire\Cards;
// use App\Http\Livewire\Carousel;
// use App\Http\Livewire\Cart;
// use App\Http\Livewire\Chart;
// use App\Http\Livewire\ChartChartist;
// use App\Http\Livewire\ChartDonut;
// use App\Http\Livewire\ChartEchart;
// use App\Http\Livewire\ChartFlot;
// use App\Http\Livewire\ChartLine;
// use App\Http\Livewire\ChartMorris;
// use App\Http\Livewire\ChartNvd3;
// use App\Http\Livewire\ChartPie;
// use App\Http\Livewire\Charts;
// use App\Http\Livewire\Chat;
// use App\Http\Livewire\Checkout;
// use App\Http\Livewire\Colors;
// use App\Http\Livewire\Construction;
// use App\Http\Livewire\Counters;
// use App\Http\Livewire\CryptoCurrencies;
// use App\Http\Livewire\Datatable;
// use App\Http\Livewire\Dropdown;
// use App\Http\Livewire\Editprofile;
// use App\Http\Livewire\EditTable;
// use App\Http\Livewire\EmailCompose;
// use App\Http\Livewire\EmailInbox;
// use App\Http\Livewire\EmailRead;
// use App\Http\Livewire\Emptypage;
// use App\Http\Livewire\Error400;
// use App\Http\Livewire\Error401;
// use App\Http\Livewire\Error403;
// use App\Http\Livewire\Error404;
// use App\Http\Livewire\Error500;
// use App\Http\Livewire\Error503;
// use App\Http\Livewire\Faq;
// use App\Http\Livewire\FileAttachments;
// use App\Http\Livewire\FileManager;
// use App\Http\Livewire\FilemanagerDetails;
// use App\Http\Livewire\FilemanagerList;
// use App\Http\Livewire\Footers;
// use App\Http\Livewire\ForgotPassword;
// use App\Http\Livewire\FormAdvanced;
// use App\Http\Livewire\FormEditor;
// use App\Http\Livewire\FormElements;
// use App\Http\Livewire\FormLayouts;
// use App\Http\Livewire\FormValidation;
// use App\Http\Livewire\FormWizard;
// use App\Http\Livewire\Gallery;
// use App\Http\Livewire\Icons;
// use App\Http\Livewire\Icons10;
// use App\Http\Livewire\Icons11;
// use App\Http\Livewire\Icons2;
// use App\Http\Livewire\Icons3;
// use App\Http\Livewire\Icons4;
// use App\Http\Livewire\Icons5;
// use App\Http\Livewire\Icons6;
// use App\Http\Livewire\Icons7;
// use App\Http\Livewire\Icons8;
// use App\Http\Livewire\Icons9;
// use App\Http\Livewire\Index;
// use App\Http\Livewire\Invoice;
// use App\Http\Livewire\Listgroup;
// use App\Http\Livewire\Loaders;
// use App\Http\Livewire\Lockscreen;
// use App\Http\Livewire\Login;
// use App\Http\Livewire\Maps;
// use App\Http\Livewire\Maps1;
// use App\Http\Livewire\Maps2;
// use App\Http\Livewire\Mediaobject;
// use App\Http\Livewire\Modal;
// use App\Http\Livewire\Navigation;
// use App\Http\Livewire\Notify;
// use App\Http\Livewire\NotifyList;
// use App\Http\Livewire\Offcanvas;
// use App\Http\Livewire\Pagination;
// use App\Http\Livewire\Panels;
// use App\Http\Livewire\Pricing;
// use App\Http\Livewire\Profile;
// use App\Http\Livewire\Progress;
// use App\Http\Livewire\Rangeslider;
// use App\Http\Livewire\Rating;
// use App\Http\Livewire\Register;
// use App\Http\Livewire\Scroll;
// use App\Http\Livewire\Scrollspy;
// use App\Http\Livewire\Search;
// use App\Http\Livewire\Services;
// use App\Http\Livewire\Settings;
// use App\Http\Livewire\Shop;
// use App\Http\Livewire\ShopDescription;
// use App\Http\Livewire\Sweetalert;
// use App\Http\Livewire\Switcher1;
// use App\Http\Livewire\Switcher2;
// use App\Http\Livewire\Tables;
// use App\Http\Livewire\Tabs;
// use App\Http\Livewire\Tags;
// use App\Http\Livewire\Terms;
// use App\Http\Livewire\Thumbnails;
// use App\Http\Livewire\Timeline;
// use App\Http\Livewire\Toast;
// use App\Http\Livewire\Tooltipandpopover;
// use App\Http\Livewire\Treeview;
// use App\Http\Livewire\Typography;
// use App\Http\Livewire\UsersList;
// use App\Http\Livewire\Widgets;
// use App\Http\Livewire\Wishlist;
// use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('livewire.index');
// });
// Route::get('index', Index::class);
// Route::get('about', About::class);
// Route::get('accordion', Accordion::class);
// Route::get('add-product', AddProduct::class);
// Route::get('alerts', Alerts::class);
// Route::get('avatar-radius', AvatarRadius::class);
// Route::get('avatar-round', AvatarRound::class);
// Route::get('avatarsquare', Avatarsquare::class);
// Route::get('badge', Badge::class);
// Route::get('blog-details', BlogDetails::class);
// Route::get('blog-post', BlogPost::class);
// Route::get('blog', Blog::class);
// Route::get('breadcrumbs', Breadcrumbs::class);
// Route::get('buttons', Buttons::class);
// Route::get('calendar', Calendar::class);
// Route::get('calendar2', Calendar2::class);
// Route::get('cards', Cards::class);
// Route::get('carousel', Carousel::class);
// Route::get('cart', Cart::class);
// Route::get('chart-chartist', ChartChartist::class);
// Route::get('chart-donut', ChartDonut::class);
// Route::get('chart-echart', ChartEchart::class);
// Route::get('chart-flot', ChartFlot::class);
// Route::get('chart-line', ChartLine::class);
// Route::get('chart-morris', ChartMorris::class);
// Route::get('chart-nvd3', ChartNvd3::class);
// Route::get('chart-pie', ChartPie::class);
// Route::get('chart', Chart::class);
// Route::get('charts', Charts::class);
// Route::get('chat', Chat::class);
// Route::get('checkout', Checkout::class);
// Route::get('colors', Colors::class);
// Route::get('construction', Construction::class);
// Route::get('counters', Counters::class);
// Route::get('crypto-currencies', CryptoCurrencies::class);
// Route::get('datatable', Datatable::class);
// Route::get('dropdown', Dropdown::class);
// Route::get('edit-table', EditTable::class);
// Route::get('editprofile', Editprofile::class);
// Route::get('email-compose', EmailCompose::class);
// Route::get('email-inbox', EmailInbox::class);
// Route::get('email-read', EmailRead::class);
// Route::get('emptypage', Emptypage::class);
// Route::get('error400', Error400::class);
// Route::get('error401', Error401::class);
// Route::get('error403', Error403::class);
// Route::get('error404', Error404::class);
// Route::get('error500', Error500::class);
// Route::get('error503', Error503::class);
// Route::get('faq', Faq::class);
// Route::get('file-attachments', FileAttachments::class);
// Route::get('file-manager', FileManager::class);
// Route::get('filemanager-details', FilemanagerDetails::class);
// Route::get('filemanager-list', FilemanagerList::class);
// Route::get('footers', Footers::class);
// Route::get('forgot-password', ForgotPassword::class);
// Route::get('form-advanced', FormAdvanced::class);
// Route::get('form-editor', FormEditor::class);
// Route::get('form-elements', FormElements::class);
// Route::get('form-layouts', FormLayouts::class);
// Route::get('form-validation', FormValidation::class);
// Route::get('form-wizard', FormWizard::class);
// Route::get('gallery', Gallery::class);
// Route::get('icons', Icons::class);
// Route::get('icons2', Icons2::class);
// Route::get('icons3', Icons3::class);
// Route::get('icons4', Icons4::class);
// Route::get('icons5', Icons5::class);
// Route::get('icons6', Icons6::class);
// Route::get('icons7', Icons7::class);
// Route::get('icons8', Icons8::class);
// Route::get('icons9', Icons9::class);
// Route::get('icons10', Icons10::class);
// Route::get('icons11', Icons11::class);
// Route::get('invoice', Invoice::class);
// Route::get('listgroup', Listgroup::class);
// Route::get('loaders', Loaders::class);
// Route::get('lockscreen', Lockscreen::class);
// Route::get('login', Login::class);
// Route::get('maps', Maps::class);
// Route::get('maps1', Maps1::class);
// Route::get('maps2', Maps2::class);
// Route::get('mediaobject', Mediaobject::class);
// Route::get('modal', Modal::class);
// Route::get('navigation', Navigation::class);
// Route::get('notify-list', NotifyList::class);
// Route::get('notify', Notify::class);
// Route::get('offcanvas', Offcanvas::class);
// Route::get('pagination', Pagination::class);
// Route::get('panels', Panels::class);
// Route::get('pricing', Pricing::class);
// Route::get('profile', Profile::class);
// Route::get('progress', Progress::class);
// Route::get('rangeslider', Rangeslider::class);
// Route::get('rating', Rating::class);
// Route::get('register', Register::class);
// Route::get('scroll', Scroll::class);
// Route::get('scrollspy', Scrollspy::class);
// Route::get('search', Search::class);
// Route::get('services', Services::class);
// Route::get('settings', Settings::class);
// Route::get('shop-description', ShopDescription::class);
// Route::get('shop', Shop::class);
// Route::get('sweetalert', Sweetalert::class);
// Route::get('switcher1', Switcher1::class);
// Route::get('switcher2', Switcher2::class);
// Route::get('tables', Tables::class);
// Route::get('tabs', Tabs::class);
// Route::get('tags', Tags::class);
// Route::get('terms', Terms::class);
// Route::get('thumbnails', Thumbnails::class);
// Route::get('timeline', Timeline::class);
// Route::get('toast', Toast::class);
// Route::get('tooltipandpopover', Tooltipandpopover::class);
// Route::get('treeview', Treeview::class);
// Route::get('typography', Typography::class);
// Route::get('users-list', UsersList::class);
// Route::get('widgets', Widgets::class);
// Route::get('wishlist', Wishlist::class);

