<?php

use App\Http\Controllers\API\ApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\chatbotController ;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/



Route::post('get_form_data', [chatbotController::class, 'get_form_data']);

Route::post('save_form_data', [chatbotController::class, 'save_form_data']);

Route::post('customer_login', [ApiController::class, 'customer_login']);
Route::get('get_category/{menu}', [ApiController::class, 'get_category']);
Route::get('get_sub_category/{id}', [ApiController::class, 'get_sub_category']);
Route::get('get_products_from_sub_category/{id}', [ApiController::class, 'get_products_from_sub_category']);
Route::get('products_details/{id}', [ApiController::class, 'products_details']);
Route::post('save_customer_details', [ApiController::class, 'save_customer_details']);
Route::post('get_location', [ApiController::class, 'get_location']);
Route::post('add_to_cart', [ApiController::class, 'add_to_cart']);
Route::post('modify_cart', [ApiController::class, 'modify_cart']);
Route::post('modify_this', [ApiController::class, 'modify_this']);
Route::post('update_quantity', [ApiController::class, 'update_quantity']);
Route::post('checkout', [ApiController::class, 'checkout']);
Route::post('update_delivery_type', [ApiController::class, 'update_delivery_type']);
Route::post('update_address', [ApiController::class, 'update_address']);
Route::post('update_phone_number', [ApiController::class, 'update_phone_number']);
Route::post('make_payment', [ApiController::class, 'make_payment']);
Route::post('show_my_cart', [ApiController::class, 'show_my_cart']);
Route::post('clear_cart', [ApiController::class, 'clear_cart']);
Route::post('track_my_order', [ApiController::class, 'track_my_order']);
Route::get('get_branches', [ApiController::class, 'get_branches']);
Route::post('save_add_on_items', [ApiController::class, 'save_add_on_items']);
Route::post('delete_product_form_cart', [ApiController::class, 'delete_product_form_cart']);
Route::post('get_address', [ApiController::class, 'get_address']);
Route::post('save_note', [ApiController::class, 'save_note']);
Route::post('previous_orders', [ApiController::class, 'previous_orders']);
Route::post('cancel_order', [ApiController::class, 'cancel_order']);
Route::post('menu_details', [ApiController::class, 'menu_details']);
Route::post('ar/menu_details', [ApiController::class, 'menu_details_ar']);
Route::post('faq', [ApiController::class, 'faq']);
Route::get('get_faq', [ApiController::class, 'get_faq']);
Route::post('talk_to_agent', [ApiController::class, 'talk_to_agent']);
Route::post('order_again', [ApiController::class, 'order_again']);
Route::post('update_branch', [ApiController::class, 'update_branch']);
Route::post('previous_address', [ApiController::class, 'previous_address']);
Route::any('payment_response', [ApiController::class, 'payment_response']);
Route::any('payment_success', [ApiController::class, 'payment_success']);
Route::any('payment_failed', [ApiController::class, 'payment_failed']);
Route::any('send-payment-status', [ApiController::class, 'send_payment_status']);
Route::any('send-feedback', [ApiController::class, 'send_feedback']);


