@php

$layout=session('layout_data');
$website_name=$layout['website_name'];
$webste_logo=$layout['webste_logo'];
$website_icon=$layout['website_icon'];
$theme_color=$layout['theme_color'];
$website_title=$layout['website_title'];
$meta_data=$layout['meta_data'];
$developed_by=$layout['developed_by'];
$developer_link=$layout['developer_link'];
$currency=$layout['currency'];
$language_id=session('website_language');

//Custom Breadcrumbs Array
$bread_crumbs=[];
$bread_crumbs[0]=['label'=>'Home','link'=>route('website_home')];
$bread_crumbs[1]=['label'=>'Menu','link'=>route('website_menu')];
// $bread_crumbs[2]=['label'=>'search','link'=>'/search'];
$bread_crumbs[2]=['label'=>'Orders','link'=>'/search/Not Found'];


$recent_order=$data['recent_orders']; //Recent Order Details
$order_id="";

@endphp
@extends('website.includes.layout')
@section('content')






  <section class="bg-white error-404 w-100 pt-5 py-sm-5 position-relative d-flex flex-column">
    <div
      class="container py-5 d-flex align-items-center justify-content-center flex-column error-message-container">
      <div class="order-placed position-relative d-flex align-items-center justify-content-center flex-column">
        <img src="/website/images/order-placed.png" class="img-fluid">
        <h3 class="text-greem">Order Placed</h3>
        <i class="fa fa-check check-icon-custom text-custom"></i>
      </div>
      <p class="fs-4 text-center">Your order has been confirmed.</p>
      <a href="#"  class="btn btn-default mt-5 view_order_btn">View Order </a>
    </div>
    @if(count($recent_order)>0)
    @php 
    $order_id=$recent_order[0]['order_id'];
    $order_date=$recent_order[0]['order_date'];
    $order_time=$recent_order[0]['order_time'];
    $order_unique_id=$recent_order[0]['order_unique_id'];
    $order_customer_name=$recent_order[0]['order_customer_name'];
    $order_customer_mob=$recent_order[0]['order_customer_mob'];
    $order_customer_mail=$recent_order[0]['order_customer_mail'];
    $order_table_id=$recent_order[0]['order_customer_mail'];
    $order_net_amount=$recent_order[0]['order_net_amount'];
    $order_discount_amt=$recent_order[0]['order_discount_amt'];
    $order_grand_total=$recent_order[0]['order_grand_total'];
    $order_tracking_status=$recent_order[0]['order_tracking_status'];
    $order_items=$recent_order[0]['order_items'];
    $order_item_count=count($order_items);
    $table_details=$recent_order[0]['table'];
    $table_name= $table_details['table_name'];
    $promocode=$recent_order[0]['promocode'];
    


 


      
    switch ($order_tracking_status) {
    case "Placed":
        $starting_class_name="custom_background_color_order_view";
        $ending_class_name="";
        $line_class_name="";
        $icon="fa-check";
        $ending_label=" Approved";
        break;
    case "Approved":
        $starting_class_name="custom_background_color_order_view";
        $ending_class_name="custom_background_color_order_view";
        $line_class_name="custom_background_color_line_color";
        $icon="fa-check";
        $ending_label=" Approved";
        break;
    case "Cancelled":
        $starting_class_name="custom_background_color_order_view_cancelled";
        $ending_class_name="custom_background_color_order_view_cancelled";
        $line_class_name="custom_background_color_line_color_cancelled";
        $icon="fa-close";
        $ending_label=" Cancelled";
        break;
    default:
        $starting_class_name="";
        $ending_class_name="";
        $line_class_name="";
        $icon="fa-check";
        $ending_label="";
    }



    @endphp
    <div class="container final-order-listing pt-4 py-sm-5" style="display: none;">
      <div>
        <div class="row pt-3 pt-sm-5 ">
          <div class="col-12 col-md-12 col-lg-7 col-xl-8">
            <div class="common-sub-heading justify-content-between align-items-center mw-set mb-5 d-none d-sm-flex">
              <span>Order List</span>
            </div>
            <div
              class="common-sub-heading d-flex justify-content-center align-items-center mw-set mb-3 d-block d-sm-none">
              <span class="play-fair">Order List</span>
            </div>
            <div class="d-flex align-items-center justify-content-between mb-sm-5 mb-4 position-relative order-status-display {{$line_class_name}}">
              <div class="d-flex flex-column align-items-center">
                <button class="btn btn-order-stat-btn {{$starting_class_name}}"><i class="fa-solid fa-check"></i></button>
                <label class="small poppins fw-bold text-uppercase fs-11 mt-2 ">Order Placed</label>
              </div>
              <div class="d-flex flex-column align-items-center">
                <button class="btn btn-order-stat-btn {{$ending_class_name}}"><i class="fa-solid {{$icon}}"></i></button>
                <label class="small poppins fw-bold text-uppercase fs-11 mt-2">{{$ending_label}}</label>
              </div>
            </div>
            <div class="customer-order-detail-mv mb-4 d-block d-sm-none poppins">
              <div class="row">
                <div class="col-7">
                  <span class="d-block mb-2">Name:<span class="fw-bold">{{$order_customer_name}}</span> </span>
                  <span class="d-block mb-2">Phone:<span class="fw-bold">{{$order_customer_mob}}</span></span>
                  @if($order_customer_mail)
                  <span class="d-block mb-2">Email Id:<span class="fw-bold">{{$order_customer_mail}}</span></span>
                  @endif
                </div>
                <div class="col-5 text-end">
                  <span class="d-block mb-2">Order Id:<span class="fw-bold">#{{$order_unique_id}}</span> </span>
                  <span class="d-block mb-2">Table Number:<span class="fw-bold">{{$table_details['table_name']}}</span></span>
                  {{-- <span class="d-block mb-2">Total Items:<span class="fw-bold">{{$order_item_count}}</span></span> --}}
                </div>
              </div>
            </div>
            @foreach($order_items as $order_item)
            
            @php 
            $order_item_id=$order_item['order_item_id'];
            $recipe_id=$order_item['recipe_id'];
            $order_item_name=$order_item['order_item_name'];
            $order_item_price=$order_item['order_item_price'];
            $order_item_quantity=$order_item['order_item_quantity'];
            $order_item_netamount=$order_item['order_item_netamount'];
            $order_item_grand_total=$order_item['order_item_grand_total'];

            // $recipe_name=json_decode($order_item['recipies']['recipe_name_multi_language'],true)[$language_id];
            $recipe_veg_or_non=$order_item['recipies']['recipe_veg_or_non'];
            $recipe_image=$order_item['recipies']['recipe_image'];
            if($recipe_veg_or_non==1){ $recipe_type="veg"; } else{ $recipe_type="non-veg"; }
            $order_item_add_on=$order_item['order_item_add_on'];
            $order_item_varient=$order_item['order_item_varient'];
            $order_item_add_ons=$order_item['order_item_add_on'];

            @endphp
            <div class="order-summary-item border border-1 p-4">
              <div class="d-flex align-items-start">
                <img src="/uploads/recipe_images/{{$recipe_image}}" class="img-fluid order-summary-item-img" alt="order-item-image">
                <div class="w-100">
                  <div class="dish-card flex-row justify-content-between w-100 h-auto">
                    <div>
                      <h6 class="dishcard-title mt-2 mb-1 text-dark">{{$order_item_name}}</h6>
                      {{-- <p class="mb-3 text-muted">Buﬀalo wing Fajita Meat Pepperoni</p> --}}
                    </div>
                    <div class="dish-category position-relative end-0 {{$recipe_type}}">
                      <i class="fa fa-circle"></i>
                    </div>
                  </div>
                  <div class="w-100 ps-4">
                    @if(!empty($order_item_varient))
                    @foreach($order_item_varient as $varient)
                    @php 
                    $order_item_varient_id= $varient['order_item_varient_id'];
                    $order_item_varient_name= $varient['order_item_varient_name'];
                    $order_item_varient_price= $varient['order_item_varient_price'];
                    $order_item_varient_quantity= $varient['order_item_varient_quantity'];
                    $order_item_varient_total_price= $varient['order_item_varient_total_price'];

                    @endphp
                    <div
                      class="order-list-quantity poppins fw-bold d-flex justify-content-between pb-1 pt-3 pt-sm-4 border-bottom">
                      <span class="play-fair w-100">{{$order_item_varient_name}}</span>
                      <span class="w-100 small text-end"> {{$order_item_varient_quantity}} X {{number_format($order_item_varient_price,0)}} {{$currency}} </span>
                      <span class="w-100 small text-end">{{number_format($order_item_varient_total_price,2)}} {{$currency}} </span>
                    </div>
                    @endforeach

                    {{-- <div class="order-list-quantity poppins fw-bold d-flex justify-content-between pb-1  pt-3 pt-sm-4 border-bottom">
                      <span class="play-fair w-100">Full</span>
                      <span class="w-100 small text-end"> 2 X 140.00 QAR </span>
                      <span class="w-100 small text-end">280.00 QAR </span>
                    </div> --}}
                    @else
                    <div class="order-list-quantity poppins fw-bold d-flex justify-content-between pb-1 pt-4 ">
                      <span class="play-fair w-100"></span>
                      <span class="w-100 small text-end"> {{$order_item_quantity}} X {{number_format($order_item_price,0)}} {{$currency}} </span>
                      <span class="w-100 small text-end">{{number_format($order_item_netamount,2)}} {{$currency}} </span>
                    </div>
                    @endif


                    @if(empty($order_item_add_ons))
                    <div class="order-list-quantity poppins fw-bold d-flex justify-content-between  pt-3 pt-sm-4">
                      <span class=" w-100"></span>
                      <span class="w-100 small text-end">Total </span>
                      <span class="w-100 small text-end">{{number_format($order_item_grand_total,2)}} {{$currency}} </span>
                    </div>
                    @endif
                  </div>
                  
                  
                </div>
              </div>


               @if(!empty($order_item_add_ons))
               
               <div class="w-100 px-md-5 py-3 mt-4 bg-light">
                <div class="order-list-quantity poppins fw-bold d-flex justify-content-between pb-3 mx-4 border-bottom">
                  <span class="play-fair w-100">Add Ons</span>
                </div>
                @foreach($order_item_add_ons as $addon)
                @php 
                $order_item_add_on_name=$addon['order_item_add_on_name'];
                $order_item_add_on_price=$addon['order_item_add_on_price'];
                $order_item_add_on_quantity=$addon['order_item_add_on_quantity']; 
                $order_item_add_on_total_price=$addon['order_item_add_on_total_price']; 
                @endphp
                <div class="order-list-quantity poppins fw-bold d-flex justify-content-between pb-1 pt-3 pt-sm-4 mx-4 border-bottom">
                  <span class="play-fair w-100">{{$order_item_add_on_name}}</span>
                  <span class="w-100 small text-end"> {{$order_item_add_on_quantity}} x {{number_format($order_item_add_on_price,2)}}</span>
                  <span class="w-100 small text-end">{{number_format($order_item_add_on_total_price,2)}} {{$currency}} </span>
                </div>

                @endforeach
                <div class="order-list-quantity poppins fw-bold d-flex justify-content-between pt-3 pt-sm-4 mx-4">
                  <span class=" w-100"></span>
                  <span class="w-100 small text-end">Total </span>
                  <span class="w-100 small text-end">{{number_format($order_item_grand_total,2)}} {{$currency}} </span>
                </div>
              </div>
              @endif



            </div>

            @endforeach

            <div class="final-price-display mt-4 d-block d-sm-none">
            @if($order_discount_amt>0 && $promocode >0)
              <div class="d-flex justify-content-between align-items-center small mb-2">
                <span class="fw-bolder opacity-75">Sub total</span>
                <span>{{$currency}} {{number_format($order_net_amount,2)}}</span>
              </div>
              <div class="d-flex justify-content-between align-items-center small text-danger mb-2">
                <span class="fw-bolder opacity-75"><svg class="svg-inline--fa fa-certificate me-1" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="certificate" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" data-fa-i2svg=""><path fill="currentColor" d="M211 7.3C205 1 196-1.4 187.6 .8s-14.9 8.9-17.1 17.3L154.7 80.6l-62-17.5c-8.4-2.4-17.4 0-23.5 6.1s-8.5 15.1-6.1 23.5l17.5 62L18.1 170.6c-8.4 2.1-15 8.7-17.3 17.1S1 205 7.3 211l46.2 45L7.3 301C1 307-1.4 316 .8 324.4s8.9 14.9 17.3 17.1l62.5 15.8-17.5 62c-2.4 8.4 0 17.4 6.1 23.5s15.1 8.5 23.5 6.1l62-17.5 15.8 62.5c2.1 8.4 8.7 15 17.1 17.3s17.3-.2 23.4-6.4l45-46.2 45 46.2c6.1 6.2 15 8.7 23.4 6.4s14.9-8.9 17.1-17.3l15.8-62.5 62 17.5c8.4 2.4 17.4 0 23.5-6.1s8.5-15.1 6.1-23.5l-17.5-62 62.5-15.8c8.4-2.1 15-8.7 17.3-17.1s-.2-17.3-6.4-23.4l-46.2-45 46.2-45c6.2-6.1 8.7-15 6.4-23.4s-8.9-14.9-17.3-17.1l-62.5-15.8 17.5-62c2.4-8.4 0-17.4-6.1-23.5s-15.1-8.5-23.5-6.1l-62 17.5L341.4 18.1c-2.1-8.4-8.7-15-17.1-17.3S307 1 301 7.3L256 53.5 211 7.3z"></path></svg><!-- <i class="fa-solid fa-certificate me-1"></i> Font Awesome fontawesome.com -->Offer Applied</span>
                <span>{{$currency}} {{number_format($order_discount_amt,2)}}</span>
              </div>
            @endif
              <div class="border-bottom opacity-75 my-3 my-sm-2"></div>
              <div class="d-flex justify-content-between align-items-center  mb-4">
                <span class="fw-bolder opacity-75 ">Grand Total</span>
                <span class="fw-bold">{{$currency}} {{number_format($order_grand_total,2)}}</span>
              </div>
            </div>
            <div class="d-flex gap-3 justify-content-center align-items-center mobile-manage-btn my-4 d-block d-sm-none">
              @if($order_tracking_status=="Placed")

                <form  action="{{route('cancel_order_by_customer')}}" method="post">
                @csrf
                <input type="hidden" name="order_id" value="{{$order_id}}">
                <button class="btn btn-danger">Cancel</button>
                </form>


            <form  action="{{route('modify_order')}}" method="post">
              @csrf
              <input type="hidden" name="order_id" value="{{$order_id}}">
              <button class="btn btn-default">Edit</button>
            </form>

              @endif
            </div>
          </div>
          <div
            class="col-12 col-md-12 col-lg-5 col-xl-4  justify-content-start  flex-column text-center text-lg-start d-none d-sm-flex">
            <div class="cart-form open-sans text-start">
              <div class="common-sub-heading border-bottom d-flex justify-content-between align-items-center pb-3 mb-3">
                <span>Order History</span>
              </div>
              <div class="d-flex justify-content-between align-items-center small mb-4">
                <span class="fw-bolder">Items {{$order_item_count}}</span>
                <span>{{$currency}} {{number_format($order_grand_total,2)}}</span>
              </div>
              <form>
                <div class="mb-4">
                  <label for="orderId" class="form-label">Order ID</label>
                  <input type="text" value="#{{$order_unique_id}}" class="form-control disabled" aria-describedby="orderId" disabled="">
                </div>
                <div class="mb-4">
                  <label for="fullName" class="form-label">Full Name</label>
                  <input type="text" value="{{$order_customer_name}}" class="form-control disabled" aria-describedby="fullName" disabled="">
                </div>
                <div class="mb-4">
                  <label for="mobileNumber" class="form-label">Mobile Number</label>
                  <input type="text" value="{{$order_customer_mob}}" class="form-control disabled" aria-describedby="mobileNumber" disabled="">
                </div>
                @if($order_customer_mail)
                <div class="mb-4">
                  <label for="emailId" class="form-label">Email ID</label>
                  <input type="text" value="{{$order_customer_mail}}" class="form-control disabled" aria-describedby="emailId" disabled="">
                </div>
                @endif
                <div class="mb-4">
                  <label for="tableNumber" class="form-label">Table Number</label>
                  <input type="text" value="{{$table_name}}" class="form-control disabled" aria-describedby="tableNumber" disabled="">
                </div>
              </form>
              <div class="final-price-display mt-4">
                 @if($order_discount_amt>0 && $promocode >0)
                <div class="d-flex justify-content-between align-items-center small mb-2">
                  <span class="fw-bolder opacity-75">Sub total</span>
                  <span>{{$currency}} {{number_format($order_net_amount,2)}}</span>
                </div>
                <div class="d-flex justify-content-between align-items-center small text-danger mb-2">
                  <span class="fw-bolder opacity-75"><i class="fa-solid fa-certificate me-1"></i>Offer Applied</span>
                  <span>{{$currency}} {{number_format($order_discount_amt,2)}}</span>
                </div>
                @endif
                <div class="border-bottom opacity-75 mb-4"></div>
                <div class="d-flex justify-content-between align-items-center  my-4">
                  <span class="fw-bolder opacity-75">Grand Total</span>
                  <span class="fw-bold">{{number_format($order_grand_total,2)}} {{$currency}}</span>
                </div>
              </div>
              <div class="d-flex gap-3 justify-content-center align-items-center mobile-manage-btn mt-5 ">


          @if($order_tracking_status=="Placed")


        <form  action="{{route('cancel_order_by_customer')}}" method="post">
        @csrf
        <input type="hidden" name="order_id" value="{{$order_id}}">
        <button class="btn btn-danger">Cancel</button>
        </form>


       <form  action="{{route('modify_order')}}" method="post">
        @csrf
        <input type="hidden" name="order_id" value="{{$order_id}}">
        <button class="btn btn-default">Edit</button>
       </form>

                @endif
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    @endif
  </section>







@stop