<!-- ------------ RECOMMENDED ~ STARTS-------------- -->
@foreach($section_datas as $section_data )
@php
$section_name=json_decode($section_data['section_name_multi_language'],true)[$language_id];
$section_products=$section_data['section_items'];
@endphp
<section class="most-recommended ">
    <div class="container">
        <h2 class="text-center w-100 mb-5 section-heading">{{$section_name}}</h2>
        <div class="owl-carousel most-rec owl-theme">
            @foreach($section_products as $section_product)
            @php
            $recipe_id=$section_product['recipe_id'];
            $recipe_name=json_decode($section_product['recipe_name_multi_language'],true)[$language_id];
            $recipe_description=json_decode($section_product['recipe_description_multi_language'],true)[$language_id];
            $recipe_veg_status=$section_product['recipe_veg_or_non'];
            $recipe_image=$section_product['recipe_image'];
            $recipe_permalink=$section_product['recipe_permalink'];
            $recipe_price=$section_product['recipe_price'];
            $recipe_offer_price=$section_product['recipe_offer_price'];
            $recipe_preparation_time=$section_product['recipe_preparation_time'];
            $recipe_stock=$section_product['recipe_stock'];
            if($recipe_veg_status==1){ $recipe_type="veg"; } else{ $recipe_type="non-veg"; }
            $varient_id=$section_product['default_varient_id'];


            $words = explode(' ', $recipe_description);
            $recipe_description = implode(' ', array_slice($words, 0, 6)).' ....';

            $cart_data=json_decode($section_product['cart_data'],true);

            if($recipe_preparation_time < 5){ $preparation_class_name="sudden-preparation" ; } else
                if($recipe_preparation_time < 10){ $preparation_class_name="medium-preparation" ; } else{
                $preparation_class_name="late-preparation" ; } @endphp <div class="item">

            <div class="dish-card position-relative">
            @if($recipe_stock<=0) 
           <div class="suport-img out-of-stock w-100 d-flex align-items-center justify-content-center poppins ">
              <span>Out of Stock</span>
            </div>
            @endif

                    <div class="dish-category {{$recipe_type}}">
                        <i class="fa fa-circle"></i>
                    </div>
                    <a href="/recipe/{{$recipe_permalink}}" class="detail-card">
                        <img src="/uploads/recipe_images/{{$recipe_image}}" class="img-fluid suport-img" loading="lazy"
                            alt="Sample Image 1">
                        <h6 class="dishcard-title mt-2 mb-1 text-custom">{{$recipe_name}}</h6>
                        @if($recipe_preparation_time)
                        <label class="prep-duration ps-2 ps-sm-0 {{$preparation_class_name}}"><i
                                class="fa-solid fa-clock-rotate-left"></i>
                            {{$recipe_preparation_time}}
                            mins</label>
                        @endif
                        <p>{{$recipe_description}}</p>

                        @if($recipe_offer_price<$recipe_price) <span class="price-dis d-block"><span
                                class="original-price">{{number_format($recipe_price,2)}}
                                {{$currency}}</span>{{number_format($recipe_offer_price,2)}} {{$currency}}</span>
                            @else
                            <span class="price-dis d-block">{{number_format($recipe_price,2)}}
                                {{$currency}}</span>
                            @endif
                    </a>

                    @if($recipe_stock<=0) 
            <div class="text-danger d-flex align-items-center ofs-display">
              <i class="fa-solid fa-circle-exclamation me-sm-2"></i>
               <p class=" fw-bold mb-0 ps-1">Currently out of stock !</p>
             </div>
                    @else
                    <section class="cart_section_{{$recipe_id}}">
                        @if($cart_data)
                        <div class="btn-sty-2 d-flex mt-2">
                            <a href="{{route('view_cart')}}" class="btn btn-outline-default"><i
                                    class="fa-solid fa-cart-shopping "></i></a>
                            <div class="counter-box align-items-center justify-content-between ms-0 ms-sm-2 d-flex">
                                <button data-page="section" data-recipe="{{$recipe_id}}" data-varient="{{$varient_id}}"
                                    data-quantity="-1" onclick="change_cart_quantity(this)"
                                    class="btn btn-light bg-white"><i class="fa fa-minus text-custom"></i></button>
                                <span
                                    class="counter-value-view text-custom recipe_cart_quantity_{{$recipe_id}}">{{$cart_data['quantity']}}</span>
                                <button data-page="section" data-varient="{{$varient_id}}" data-recipe="{{$recipe_id}}"
                                    data-quantity="1" onclick="change_cart_quantity(this)"
                                    class="btn btn-light bg-white"><i class="fa fa-plus text-custom"></i></button>
                            </div>

                        </div>
                        @else
                        <a data-page="section" data-recipe="{{$recipe_id}}" data-varient="{{$varient_id}}"
                            data-quantity="1" onclick="add_to_cart(this)"
                            class="btn btn-outline-default mt-2 text-custom">Move to
                            cart</a>
                        @endif
                    </section>
                    @endif
                </div>
        </div>
        @endforeach

    </div>
    </div>
</section>
@endforeach
<!-- ------------ RECOMMENDED ~ ENDS---------------- -->