@php

$layout=session('layout_data');
$website_name=$layout['website_name'];
$webste_logo=$layout['webste_logo'];
$website_icon=$layout['website_icon'];
$theme_color=$layout['theme_color'];
$website_title=$layout['website_title'];
$meta_data=$layout['meta_data'];
$developed_by=$layout['developed_by'];
$developer_link=$layout['developer_link'];
$currency=$layout['currency'];
$language_id=session('website_language');

@endphp
@if(count($recipes)==0)
<!-- ----------------- NO recepie found ~ starts ---------------- -->
<div class="poppins text-center pb-5">
    <img src="/website/images/no-dish-found.png" class="img-fluid opacity-75">
    <h4 class="fs-2 fw-bold text-default-green text-custom">Oops !</h4>
    <p class="opacity-75">No recepies found under this category.</p>
</div>
<!-- ----------------- NO recepie found ~ ends ---------------- -->
@else
@foreach($recipes as $recipe)

@php
$recipe_id=$recipe['recipe_id'];
$recipe_name=json_decode($recipe['recipe_name_multi_language'],true)[$language_id];
$recipe_description= $recipe['recipe_description_multi_language'] ? json_decode($recipe['recipe_description_multi_language'],true)[$language_id] : NULL;
$recipe_veg_status=$recipe['recipe_veg_or_non'];
$recipe_image=$recipe['recipe_image'];
$recipe_permalink=$recipe['recipe_permalink'];
$recipe_price=$recipe['recipe_price'];
$recipe_offer_price=$recipe['recipe_offer_price'];
$recipe_preparation_time=$recipe['recipe_preparation_time'];
$recipe_stock=$recipe['recipe_stock'];
if($recipe_veg_status==1){ $recipe_type="veg"; } else{ $recipe_type="non-veg"; }
$words = explode(' ', $recipe_description);
$recipe_description = implode(' ', array_slice($words, 0, 6)).' ....';
$cart_data=$recipe['cart_data'];
$default_varient_id=$recipe['default_varient_id'];
//Preparation Theme
if($recipe_preparation_time < 5){ $preparation_class_name="sudden-preparation" ; } else if($recipe_preparation_time <
    10){ $preparation_class_name="medium-preparation" ; } else{ $preparation_class_name="late-preparation" ; } @endphp
    <div class="col-6 col-sm-6 col-md-6 col-lg-4 col-xl-3">
    <div class="dish-card position-relative">
    @if($recipe_stock<=0) <div
            class="suport-img out-of-stock w-100 d-flex align-items-center justify-content-center poppins">
            <span>Out of Stock</span>
    </div>
    @endif
    <a href="/recipe/{{$recipe_permalink}}" class="dish-card-link">
        <div class="dish-category {{$recipe_type}}">
            <i class="fa fa-circle"></i>
        </div>
        <img src="/uploads/recipe_images/{{$recipe_image}}" class="img-fluid suport-img w-100" loading="lazy"
            alt="{{$recipe_name}}">
        <h6 class="dishcard-title mt-2 mb-1 text-custom">{{$recipe_name}}</h6>
        <p>{{$recipe_description}}</p>
        @if($recipe_preparation_time)
        <label class="prep-duration ps-2 ps-sm-0 {{$preparation_class_name}}"><i
                class="fa-solid fa-clock-rotate-left"></i>
            {{$recipe_preparation_time}}
            mins</label>
        @endif
        @if($recipe_offer_price != 0 && $recipe_offer_price<$recipe_price) <span class="price-dis d-block"><span
                class="original-price">{{number_format($recipe_price,2)}}
                {{$currency}}</span>{{number_format($recipe_offer_price,2)}} {{$currency}}</span>
            @else
            <span class="price-dis d-block">{{number_format($recipe_price,2)}}
                {{$currency}}</span>
            @endif
    </a>
    @if($recipe_stock<=0)
    <div class="text-danger d-flex align-items-center ofs-display">
        <i class="fa-solid fa-circle-exclamation me-sm-2"></i>
        <p class=" fw-bold mb-0">Currently out of stock !</p>
        </div>
     @else

        <section class="cart_section_{{$recipe_id}}">
            @if($cart_data)


            <div class="btn-sty-2 d-flex mt-2">
                <a href="{{route('view_cart')}}" class="btn btn-outline-default"><i
                        class="fa-solid fa-cart-shopping "></i></a>
                <div class="counter-box align-items-center justify-content-between ms-0 ms-sm-2 d-flex">
                    <button data-page="section" data-varient="{{$default_varient_id}}" data-recipe="{{$recipe_id}}"
                        data-quantity="-1" onclick="change_cart_quantity(this)" class="btn btn-light bg-white"><i
                            class="fa fa-minus text-custom"></i></button>
                    <span
                        class="counter-value-view text-custom recipe_cart_quantity_{{$recipe_id}}">{{$cart_data['quantity']}}</span>
                    <button data-page="section" data-varient="{{$default_varient_id}}" data-recipe="{{$recipe_id}}"
                        data-quantity="1" onclick="change_cart_quantity(this)" class="btn btn-light bg-white"><i
                            class="fa fa-plus text-custom"></i></button>
                </div>

            </div>
            @else
            <a data-page="section" data-varient="{{$default_varient_id}}" data-recipe="{{$recipe_id}}" data-quantity="1"
                onclick="add_to_cart(this)" class="btn btn-outline-default mt-2 text-custom">Move to
                cart</a>
            @endif

            @endif

            </div>
            </div>

            @endforeach

            @endif
