@php

$layout=session('layout_data');
$website_name=$layout['website_name'];
$webste_logo=$layout['webste_logo'];
$website_icon=$layout['website_icon'];
$theme_color=$layout['theme_color'];
$website_title=$layout['website_title'];
$meta_data=$layout['meta_data'];
$developed_by=$layout['developed_by'];
$developer_link=$layout['developer_link'];
$currency=$layout['currency'];
$language_id=session('website_language');
//Cart Section
$cart_data=$data['cartCollection'];
$cart_count=count($cart_data);
@endphp


<div class="common-sub-heading justify-content-between align-items-center mw-set mb-5 d-none d-sm-flex">
    <span>Shopping Cart</span>
    <span>{{$cart_count}} items</span>
</div>
<div class="common-sub-heading d-flex justify-content-center align-items-center mw-set mb-3 d-block d-sm-none">
    <span class="play-fair">Shopping Cart</span>
</div>

<div class="cart-list d-none d-sm-block">
    @php
    $cart_total_price=0;
    @endphp
    @foreach($cart_data as $cart)
    @php
    $varient_array=array();
    $addon_array=array();
    $recipe_id=$cart['id'];
    $recipe_name=$cart['recipe_name'];
    //$recipe_price=$cart['recipe_price'];
    $recipe_price=\App\Models\recipeModel::where('recipe_id', $recipe_id)->first()->recipe_price;
    $recipe_image=$cart['recipe_image'];
    $recipe_permalink=$cart['recipe_permalink'];
    $quantity=$cart['quantity'];
    $recipe_type=$cart['recipe_type'];
    if($recipe_type==1){
    $recipe_class_name="veg";
    }
    else{
    $recipe_class_name="non-veg";
    }
    $cart_attributes=$cart['attributes'];
    $recipe_total_price=0;
    //Varient Section
    if(isset($cart_attributes['variant_array'])){
    $varient_array=$cart_attributes['variant_array'];
    }
    //End Of Varient Section
    //addon Section
    if(isset($cart_attributes['addon_array'])){
    $addon_array=$cart_attributes['addon_array'];
    }
    //End Of addon Section
    @endphp
    @if(count($varient_array)>0 ||count($addon_array)>0 )
    <div class="cart-board d-flex justify-content-between align-items-start gap-3">
        <div class="dish-card position-relative cart-image-display">
            <a href="/recipe/{{$recipe_permalink}}" class="redirect-page-link w-100">
                <div class="dish-category {{$recipe_class_name}}">
                    <i class="fa fa-circle"></i>
                </div>
                <img src="/uploads/recipe_images/{{$recipe_image}}" class="img-fluid suport-img w-100" loading="lazy"
                    alt="{{$recipe_name}}">
            </a>
        </div>
        <div class="dish-card position-relative w-100 rounded-0">
            <a href="/recipe/{{$recipe_permalink}}" class="redirect-page-link">
                <h6 class="dishcard-title mt-2 mb-1 text-dark">{{$recipe_name}}</h6>
            </a>
            @if($varient_array)
            <div class="w-100">
                <label class="fw-semibold poppins mt-3 pb-1 small opacity-75">Varient</label>
                @foreach($varient_array as $varient)
                @php
                $varient_id=$varient['variant_id'];
                $variant_name=$varient['variant_name'];
                $variant_quantity=$varient['variant_quantity'];
                $variant_price=$varient['variant_price'];
                $recipe_total_price=$recipe_total_price+($variant_quantity*$variant_price);
                @endphp



                <div class="quantity-block-area poppins">
                    <label class="quantity-label">{{$variant_name}}</label>
                    <div class="counter-box d-flex align-items-center justify-content-between mx-2">
                        <button data-page="cart_item" data-varient="{{$varient_id}}" data-recipe="{{$recipe_id}}"
                            data-quantity="-1" data-current_qty="{{$variant_quantity}}"
                            onclick="change_cart_quantity(this)" class="btn btn-light bg-white"><i
                                class="fa fa-minus"></i></button>
                        <span class="cart_qty_{{$varient_id}}">{{$variant_quantity}}</span>
                        <button data-page="cart_item" data-current_qty="{{$variant_quantity}}"
                            data-varient="{{$varient_id}}" data-recipe="{{$recipe_id}}" data-quantity="1"
                            onclick="change_cart_quantity(this)" class="btn btn-light bg-white"><i
                                class="fa fa-plus"></i></button>
                    </div>
                    <label
                        class="price-label-view text-sm-end text-start">{{number_format($variant_price,2)}}{{$currency}}</label>
                </div>


                @endforeach
            </div>
            @else
            @php
            $recipe_total_price=$recipe_total_price+($quantity*$recipe_price);
            @endphp

            <div class="w-100 mb-2">
                <label class="fw-semibold poppins mt-3 pb-1 small opacity-75">Quantity</label>
                <div class="quantity-block-area poppins">
                    <div class="counter-box d-flex align-items-center justify-content-between me-2">
                        <button class="btn btn-light bg-white" data-page="cart_item" data-current_qty="{{$quantity}}"
                            data-recipe="{{$recipe_id}}" data-quantity="-1" onclick="change_cart_quantity(this)"><i
                                class="fa fa-minus"></i></button>
                        <span>{{$quantity}}</span>
                        <button class="btn btn-light bg-white" data-page="cart_item" data-current_qty="{{$quantity}}"
                            data-recipe="{{$recipe_id}}" data-quantity="1" onclick="change_cart_quantity(this)"><i
                                class="fa fa-plus"></i></button>
                    </div>
                    <label class="price-label-view text-sm-end text-start">{{$recipe_price}} {{$currency}}</label>
                </div>
            </div>

            @endif
            @if($addon_array)
            <label class="fw-semibold poppins mb-2 mt-3 pb-1 small opacity-75">Product Add Ons</label>
            <div class="addon-listing w-100 mb-2">
                @foreach($addon_array as $addon)
                @php

                $add_on_id=$addon['id'];
                $add_on_name=$addon['add_on_name'];
                $add_on_quantity=$addon['add_on_quantity'];
                $add_on_price=$addon['add_on_price'];
                $add_on_image=$addon['add_on_image'];
                $recipe_total_price=$recipe_total_price+($add_on_quantity*$add_on_price);
                @endphp
                <div class="addon-items d-block d-sm-flex align-items-center">
                    <div class="d-flex align-items-center w-100">
                        <img src="uploads/add_on_images/{{$add_on_image}}" class="addon-img img-fluid" alt="demo-image">
                        <label class="addon-item-name me-4 d-flex">
                            {{$add_on_name}}
                        </label>
                    </div>
                    <div class="btn-sty-2">
                        <div class="counter-box align-items-center justify-content-between d-flex">
                            <button data-page="cart" data-recipe="{{$recipe_id}}" data-quantity="-1"
                                data-add-on="{{$add_on_id}}" onclick="add_add_ons(this)" class="btn btn-light bg-white">
                                <i class="fa fa-minus"></i></button>
                            <span class="counter-value-view">{{$add_on_quantity}}</span>
                            <button data-page="cart" data-recipe="{{$recipe_id}}" data-quantity="1"
                                data-add-on="{{$add_on_id}}" onclick="add_add_ons(this)"
                                class="btn btn-light bg-white"><i class="fa fa-plus"></i></button>
                        </div>
                    </div>
                    <label class="price-label-view text-sm-end text-start">{{$add_on_price}} {{$currency}}</label>
                </div>
                @endforeach
            </div>
            @endif
            <div class="d-flex poppins justify-content-between w-100">
                <span class="opacity-75 me-3 small">Total :</span>
                <span class="price-dis d-block">{{number_format($recipe_total_price,2)}} {{$currency}}</span>
            </div>
        </div>
        <a href="#" class="text-danger remove-item d-none d-sm-flex align-items-center" data-page="cart"
            data-recipe="{{ $recipe_id}}" onclick="remove_cart(this)">
            <i class="fa-solid fa-trash-can me-2"></i>Remove
        </a>

    </div>
    @else
    @php
    $recipe_total_price=$recipe_total_price+($quantity*$recipe_price);
    @endphp


    <div class="cart-board d-flex justify-content-between align-items-start gap-3">
        <div class="dish-card position-relative cart-image-display">
            <a href="/recipe/{{$recipe_permalink}}" class="redirect-page-link w-100">
                <div class="dish-category non-veg">
                    <i class="fa fa-circle"></i>
                </div>
                <img src="/uploads/recipe_images/{{$recipe_image}}" class="img-fluid suport-img w-100" loading="lazy"
                    alt="{{$recipe_name}}">
            </a>
        </div>
        <div class="dish-card position-relative w-100 rounded-0">
            <a href="/recipe/{{$recipe_permalink}}" class="redirect-page-link">
                <h6 class="dishcard-title mt-2 mb-1 text-dark">{{$recipe_name}}</h6>
            </a>
            <!-- <p class="mb-3">Buﬀalo wing Fajita Meat Pepperoni</p> -->
            <div class="w-100 mb-2">
                <label class="fw-semibold poppins mt-3 pb-1 small opacity-75">Quantity</label>
                <div class="quantity-block-area poppins">
                    <div class="counter-box d-flex align-items-center justify-content-between me-2">
                        <button class="btn btn-light bg-white" data-page="cart_item" data-current_qty="{{$quantity}}"
                            data-recipe="{{$recipe_id}}" data-quantity="-1" onclick="change_cart_quantity(this)"><i
                                class="fa fa-minus"></i></button>
                        <span>{{$quantity}}</span>
                        <button class="btn btn-light bg-white" data-page="cart_item" data-current_qty="{{$quantity}}"
                            data-recipe="{{$recipe_id}}" data-quantity="1" onclick="change_cart_quantity(this)"><i
                                class="fa fa-plus"></i></button>
                    </div>
                    <label class="price-label-view text-sm-end text-start">{{number_format($recipe_price,2)}}
                        {{$currency}}</label>
                </div>
            </div>
            <div class="d-flex poppins justify-content-between w-100">
                <span class="opacity-75 me-3 small">Total :</span>
                <span class="price-dis d-block">{{number_format($recipe_total_price,2)}}
                    {{$currency}}</span>
            </div>
        </div>
        <a href="#" data-page="cart" data-recipe="{{ $recipe_id}}" onclick="remove_cart(this)"
            class="text-danger remove-item d-none d-sm-flex align-items-center">
            <i class="fa-solid fa-trash-can me-2"></i>Remove
        </a>

    </div>



    @endif

    @php
    $cart_total_price=$cart_total_price+$recipe_total_price;
    @endphp

    @endforeach
    <input type="hidden" value="{{$cart_total_price}}" class="cart_total_price">
    <input type="hidden" value="{{$cart_count}}" class="cart_total_count">

</div>



<!-- ---------------cart list mobile view ~ starts ------------------ -->
<div class="cart-list cart-mobile-view d-block d-sm-none">

    @foreach($cart_data as $cart)
    @php
    $varient_array=array();
    $addon_array=array();
    $recipe_id=$cart['id'];
    $recipe_name=$cart['recipe_name'];
    //$recipe_price=$cart['recipe_price'];
        $recipe_price=\App\Models\recipeModel::where('recipe_id', $recipe_id)->first()->recipe_price;

    $recipe_image=$cart['recipe_image'];
    $recipe_permalink=$cart['recipe_permalink'];
    $quantity=$cart['quantity'];
    $recipe_type=$cart['recipe_type'];
    if($recipe_type==1){
    $recipe_class_name="veg";
    }
    else{
    $recipe_class_name="non-veg";
    }
    $cart_attributes=$cart['attributes'];
    $recipe_total_price=0;
    //Varient Section
    if(isset($cart_attributes['variant_array'])){
    $varient_array=$cart_attributes['variant_array'];
    }
    //End Of Varient Section
    //addon Section
    if(isset($cart_attributes['addon_array'])){
    $addon_array=$cart_attributes['addon_array'];
    }
    //End Of addon Section
    @endphp

    <div class="cart-board">
        <div class=" mobile-cart-detail-display">
            <div class="d-flex justify-content-start mb-3">
                <div class="dish-card position-relative cart-image-display">
                    <a href="/recipe/{{$recipe_permalink}}" class="redirect-page-link w-100">
                        <div class="dish-category non-veg">
                            <i class="fa fa-circle"></i>
                        </div>
                        <img src="/uploads/recipe_images/{{$recipe_image}}" class="img-fluid suport-img w-100"
                            loading="lazy" alt="{{$recipe_name}}">
                    </a>
                </div>
                <div class="dish-card position-relative w-100 rounded-0">
                    <div class="d-flex align-items-start w-100">
                        <div class="w-100">
                            <a href="/recipe/{{$recipe_permalink}}" class="redirect-page-link">
                                <h6 class="dishcard-title mt-2 mb-1 text-dark">{{$recipe_name}}</h6>
                            </a>
                        </div>
                        <button class="btn text-danger remove-item ms-2" data-page="cart" data-recipe="{{$recipe_id}}"
                            onclick="remove_cart(this)">
                            <i class="fa-regular fa-trash-can"></i>
                        </button>
                    </div>
                </div>
            </div>
            @if(count($varient_array)>0)
            @foreach($varient_array as $varient)
            @php
            $varient_id=$varient['variant_id'];
            $variant_name=$varient['variant_name'];
            $variant_quantity=$varient['variant_quantity'];
            $variant_price=$varient['variant_price'];
            $recipe_total_price=$recipe_total_price+($variant_price*$variant_quantity);
            $cart_total_price=$cart_total_price+$recipe_total_price;
            @endphp
            <div
                class="d-flex align-items-center justify-content-between quantity-block-area poppins mt-2  mw-100 w-100">
                <label class="quantity-label w-100">{{$variant_name}}</label>
                <div class="counter-box align-items-center justify-content-between d-flex mx-2">
                    <button class="btn btn-light bg-white" data-page="cart_item"
                        data-current_qty="{{$variant_quantity}}" data-varient="{{$varient_id}}"
                        data-recipe="{{$recipe_id}}" data-quantity="-1" onclick="change_cart_quantity(this)"><i
                            class="fa fa-minus"></i></button>
                    <span class="counter-value-view">{{$variant_quantity}}</span>
                    <button class="btn btn-light bg-white" data-page="cart_item"
                        data-current_qty="{{$variant_quantity}}" data-varient="{{$varient_id}}"
                        data-recipe="{{$recipe_id}}" data-quantity="1" onclick="change_cart_quantity(this)"><i
                            class="fa fa-plus"></i></button>
                </div>
                <span class="price-dis d-block text-end w-100">{{number_format($variant_price,2)}}{{$currency}}</span>
            </div>
            @endforeach
            @else
            @php
            $recipe_total_price=$recipe_price*$quantity;
            @endphp
            <div class="d-flex align-items-center w-100 mt-2">
                <div class="counter-box align-items-center justify-content-between d-flex">
                    <button data-page="cart_item" data-current_qty="{{$quantity}}" data-recipe="{{$recipe_id}}"
                        data-quantity="-1" onclick="change_cart_quantity(this)" class="btn btn-light bg-white"><i
                            class="fa fa-minus"></i></button>
                    <span class="counter-value-view">{{$quantity}}</span>
                    <button data-page="cart_item" data-current_qty="{{$quantity}}" data-recipe="{{$recipe_id}}"
                        data-quantity="1" onclick="change_cart_quantity(this)" class="btn btn-light bg-white"><i
                            class="fa fa-plus"></i></button>
                </div>
                <span class="price-dis d-block text-end w-100">{{number_format($recipe_price,2)}}
                    {{$currency}}</span>
            </div>
            @endif

        </div>
        @if(count($addon_array)>0)
        <div class="addon-listing mb-2">
            <h6 class="small">Product Add Ons</h6>
            @foreach($addon_array as $addon)
            @php

            $add_on_id=$addon['id'];
            $add_on_name=$addon['add_on_name'];
            $add_on_quantity=$addon['add_on_quantity'];
            $add_on_price=$addon['add_on_price'];
            $add_on_image=$addon['add_on_image'];
            $recipe_total_price=$recipe_total_price+($add_on_quantity*$add_on_price);
            @endphp
            <div class="addon-items d-flex align-items-center">
                <label class="addon-item-name me-4 d-flex">
                    {{$add_on_name}}
                </label>
                <div class="btn-sty-2">
                    <div class="counter-box align-items-center justify-content-between d-flex">
                        <button data-page="cart" data-recipe="{{$recipe_id}}" data-quantity="-1"
                            data-add-on="{{$add_on_id}}" onclick="add_add_ons(this)" class="btn btn-light bg-white"><i
                                class="fa fa-minus"></i></button>
                        <span class="counter-value-view">{{$add_on_quantity}}</span>
                        <button data-page="cart" data-recipe="{{$recipe_id}}" data-quantity="1"
                            data-add-on="{{$add_on_id}}" onclick="add_add_ons(this)" class="btn btn-light bg-white"><i
                                class="fa fa-plus"></i></button>
                    </div>
                </div>
                <label class="price-label-view text-end">{{number_format($add_on_price,2)}} {{$currency}}</label>
            </div>
            @endforeach

        </div>
        @endif
        <span class="price-dis d-block text-end">{{number_format($recipe_total_price,2)}} {{$currency}}</span>
    </div>
    @endforeach
</div>
