@php

$layout=session('layout_data');
$website_name=$layout['website_name'];
$webste_logo=$layout['webste_logo'];
$website_icon=$layout['website_icon'];
$theme_color=$layout['theme_color'];
$website_title=$layout['website_title'];
$meta_data=$layout['meta_data'];
$developed_by=$layout['developed_by'];
$developer_link=$layout['developer_link'];
$currency=$layout['currency'];
$language_id=session('website_language');

//Get Active Tavbles
$active_table=$data['available_tables'];

//Custom Breadcrumbs Array
$bread_crumbs=[];
$bread_crumbs[0]=['label'=>'Home','link'=>route('website_home')];
$bread_crumbs[1]=['label'=>'Menu','link'=>route('website_menu')];
$bread_crumbs[2]=['label'=>'Cart','link'=>route('view_cart')];
$bread_crumbs[3]=['label'=>'Not Found','link'=>'/search/Not Found'];

@endphp
@extends('website.includes.layout')
@section('content')





<!-- ------------- CART LANDING ~ START ------------------ -->
<section class="bg-white w-100 pb-2 py-sm-5 position-relative cart-section">
    <div class="container pt-5">
        <div class="row pt-5 ">
                 @php 
                    $fullname=$mobile=$email=$booked_table=$promocode="";
                    $order_net_amount=0;
                    $order_discount_amt=0;
                    $order_grand_total=0;
                    $sub_and_discount_class_name="d-none";
                    if(!empty($data['edit_order_details'])){
                        $fullname=$data['edit_order_details']['order_customer_name'];
                        $mobile=$data['edit_order_details']['order_customer_mob'];
                        $email=$data['edit_order_details']['order_customer_mail'];
                        $booked_table=$data['edit_order_details']['order_table_id'];
                        // $order_net_amount=$data['edit_order_details']['order_net_amount'];
                        // $order_discount_amt=$data['edit_order_details']['order_discount_amt'];
                        // $order_grand_total=$data['edit_order_details']['order_grand_total'];
                        if($data['edit_order_details']['promocode']!="" && $data['edit_order_details']['order_discount_amt']>0){
                        $promocode=$data['edit_order_details']['promocode']['promocode_short_code'];
                        $sub_and_discount_class_name="";
                        }
                    }
                    @endphp


            <div
                class="col-12  d-flex d-sm-none justify-content-start justify-content-md-center flex-column text-center text-lg-start">
                <div class="cart-form open-sans text-start">
                    <div
                        class="common-sub-heading border-bottom d-flex justify-content-between align-items-center pb-3 mb-3 d-none d-sm-block">
                        <span>Order Now</span>
                    </div>
                    <div
                        class="common-sub-heading d-flex justify-content-center align-items-center mw-set mb-3 d-block d-sm-none">
                        <span class="play-fair">Order Now</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center small mb-4">
                        <span class="fw-bolder">Items <span class="cart_page_cart_count">4</span></span>
                        <span><span class="cart_total_amount">0.00</span>{{$currency}}</span>
                        <input type="hidden" class="cart_total_amount_input">
                    </div>

                    <div class="mb-1">
                        <label for="first-name" class="form-label">Full Name</label>
                        <input type="text" value="{{$fullname}}" class="form-control check_out_form customer_name" aria-describedby="first-name"
                            autocomplete="off">
                        <label class="customer_name_required_label"></label>
                    </div>
                    <div class="mb-1">
                        <label for="mobile-number" class="form-label">Mobile Number</label>
                        <input type="text" value="{{$mobile}}" class="form-control check_out_form customer_mobile" aria-describedby="mobile-number"
                            autocomplete="off">
                        <label class="customer_mobile_required_label"></label>
                    </div>
                    <div class="mb-1">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" value="{{$email}}" class="form-control check_out_form" aria-describedby="email" autocomplete="off">
                    </div>
                    <div class="mb-1">
                        <label for="table-number" class="form-label">Table Number</label>

                        <select class="form-select customer_table_id" aria-label="table-number">
                            <option value=""> --Choose Table --</option>
                            @foreach($active_table as $table)
                             @if($booked_table==$table['table_id'])
                            @php $selected="Selected";@endphp
                            @else
                            @php $selected="";@endphp
                            @endif

                            <option {{$selected}} value="{{$table['table_id']}}">{{$table['table_name']}} ({{$table['table_format']}})
                            </option>
                            @endforeach
                        </select>
                        <label class="customer_table_required_label"></label>
                    </div>




                    <div class="d-flex">
                        <input type="text"  value="{{$promocode}}"   class="form-control check_out_form promocode" aria-describedby="promo-code"
                            autocomplete="off">
                        <button onclick="check_promocode()" class="btn btn-danger btn-apply-code ">APPLY</button>
                    </div>
                    <label class="common_error"></label>






                    <div class="final-price-display mt-4">
                        <div
                            class="d-flex justify-content-between align-items-center small mb-2 promocode_subtotal d-none">
                            <span class="fw-bolder opacity-75">Sub total</span>
                            <span><span class="cart_subtotal_amount">0.00</span> {{$currency}}</span>
                        </div>
                        <div
                            class="d-flex justify-content-between align-items-center small text-danger mb-2  promocode_amount d-none">
                            <span class="fw-bolder opacity-75"><i class="fa-solid fa-certificate me-1"></i>Offer
                                Applied</span>
                            <span><span class="cart_promocode_amount">0.00</span> {{$currency}}</span>
                        </div>
                        <div class="border-bottom opacity-75 mb-4"></div>
                        <div class="d-flex justify-content-between align-items-center  my-4">
                            <span class="fw-bolder opacity-75">Grand Total</span>
                            <span class="fw-bold"><span class="cart_total_amount">0.00</span> {{$currency}}</span>
                        </div>
                    </div>

                    
                    @if(session('recent_customer_order_id'))
                    @php $btn_value="Update Order"; @endphp 
                    @else
                     @php $btn_value="Place Order"; @endphp 
                    @endif
                    <a href="#" onclick="create_order()" class="btn btn-default mx-auto d-block w-75">{{$btn_value}}</a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ------------- CART LANDING ~ ENDS ------------------- -->


</body>





@stop