@php

$layout=session('layout_data');
$website_name=$layout['website_name'];
$webste_logo=$layout['webste_logo'];
$website_icon=$layout['website_icon'];
$theme_color=$layout['theme_color'];
$website_title=$layout['website_title'];
$meta_data=$layout['meta_data'];
$developed_by=$layout['developed_by'];
$developer_link=$layout['developer_link'];
$currency=$layout['currency'];
$language_id=session('website_language');

//Fetching Data Secion

//Get Active Tavbles
$active_table=$data['available_tables'];



//Custom Breadcrumbs Array
$bread_crumbs=[];
$bread_crumbs[0]=['label'=>'Home','type'=>'category','link'=>route('website_home')];
$bread_crumbs[1]=['label'=>'Menu','type'=>'menu','link'=>route('website_menu')];
$bread_crumbs[2]=['label'=>'View Cart','type'=>'cart','link'=>route('view_cart')];



@endphp
@extends('website.includes.layout')
@section('content')

@if(count($data['cartCollection'])>0)
<!-- ------------- CART LANDING ~ START ------------------ -->
<section class="bg-white w-100 pb-2 py-sm-5 position-relative cart-section">
    <div class="container pt-5">
        <div class="row pt-3 pt-sm-5  ">
            <div class="col-12 col-md-12 col-lg-7 col-xl-8 cart_items">
                @include('website.includes.cart_item')
            </div>
            <div
                class="col-12 col-md-12 col-lg-5 col-xl-4  justify-content-start justify-content-md-center flex-column text-center text-lg-start d-none d-sm-flex">
                <div class="cart-form open-sans text-start">
                    <div
                        class="common-sub-heading border-bottom d-flex justify-content-between align-items-center pb-3 mb-3">
                        <span>Order Now</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center small mb-4">
                        <span class="fw-bolder">Items <span class="cart_page_cart_count"> 0</span></span>
                        <span><span class="cart_total_amount">0.00 </span> {{$currency}}</span>
                        <input type="hidden" class="cart_total_amount_input">
                    </div>
                    @php 
                    $fullname=$mobile=$email=$booked_table=$promocode="";
                    $order_net_amount=0;
                    $order_discount_amt=0;
                    $order_grand_total=0;
                    $sub_and_discount_class_name="d-none";
                    if(!empty($data['edit_order_details'])){
                        $fullname=$data['edit_order_details']['order_customer_name'];
                        $mobile=$data['edit_order_details']['order_customer_mob'];
                        $email=$data['edit_order_details']['order_customer_mail'];
                        $booked_table=$data['edit_order_details']['order_table_id'];
                        // $order_net_amount=$data['edit_order_details']['order_net_amount'];
                        // $order_discount_amt=$data['edit_order_details']['order_discount_amt'];
                        // $order_grand_total=$data['edit_order_details']['order_grand_total'];
                        if($data['edit_order_details']['promocode']!="" && $data['edit_order_details']['order_discount_amt']>0){
                        $promocode=$data['edit_order_details']['promocode']['promocode_short_code'];
                        $sub_and_discount_class_name="";
                        }
                    }
                    @endphp

                    <div class="mb-3 ">
                        <label for="first-name" class="form-label">Full Name *</label>
                        <input type="text" value="{{$fullname}}" class="form-control check_out_form customer_name" aria-describedby="first-name"
                            autocomplete="off">
                        <label class="customer_name_required_label"></label>

                    </div>
                    <div class="mb-3 ">
                        <label for="mobile-number" class="form-label ">Mobile Number *</label>
                        <input type="number"  class="form-control check_out_form custom_mobile_input customer_mobile" id="mobile"
                            aria-describedby="mobile-number" value="{{$mobile}}" pattern="\d{5}" maxlength="10" autocomplete="off">
                        <label class="customer_mobile_required_label"></label>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" value="{{$email}}" class="form-control check_out_form customer_email" aria-describedby="email"
                            autocomplete="off">
                    </div>
                    <div class="mb-3">
                        <label for="table-number" class="form-label">Table Number *</label>

                        <select class="form-select  customer_table_id" aria-label="table-number">
                            <option value=""> -- Choose Table Number --</option>
                            @foreach($active_table as $table)
                            @if($booked_table==$table['table_id'])
                            @php $selected="Selected";@endphp
                            @else
                            @php $selected="";@endphp
                            @endif
                            <option {{$selected}} value="{{$table['table_id']}}">{{$table['table_name']}} ({{$table['table_format']}})
                            </option>
                            @endforeach
                        </select>
                        <label class="customer_table_required_label"></label>
                    </div>

                    <div class="mb-3">
                        <label for="promo-code" class="form-label">Promo Code</label>
                        <div class="d-flex">
                            <input type="text" value="{{$promocode}}" class="form-control check_out_form promocode" aria-describedby="promo-code">
                            <button type="submit" onclick="check_promocode()"
                                class="btn btn-danger btn-apply-code ">APPLY</button>
                        </div>
                        <label class="common_error"></label>

                    </div>
                   

                    <div class="final-price-display mt-4">
                        <div
                            class="d-flex justify-content-between align-items-center small mb-2 promocode_subtotal {{$sub_and_discount_class_name}}">
                            <span class="fw-bolder opacity-75">Sub total</span>
                            <span><span class="cart_subtotal_amount">{{number_format($order_net_amount,2)}}</span> {{$currency}}</span>
                        </div>
                        <div
                            class="d-flex justify-content-between align-items-center small text-danger mb-2 promocode_amount {{$sub_and_discount_class_name}}">
                            <span class="fw-bolder opacity-75"><i class="fa-solid fa-certificate me-1"></i>Offer
                                Applied</span>
                            <span><span class="cart_promocode_amount">{{number_format($order_discount_amt,2)}} </span> {{$currency}}</span>
                        </div>
                        <div class="border-bottom opacity-75 mb-4"></div>
                        <div class="d-flex justify-content-between align-items-center  my-4">
                            <span class="fw-bolder opacity-75">Grand Total</span>
                            <span class="fw-bold"><span class="cart_total_amount">{{number_format($order_grand_total,2)}} </span> {{$currency}}</span>
                        </div>
                    </div>




                    @if(session('recent_customer_order_id'))
                    <a href="#" onclick="create_order()" class="btn btn-default w-100">Update Order</a>
                    @else
                    <a href="#" onclick="create_order()" class="btn btn-default w-100">order</a>
                    @endif
                </div>
            </div>
        </div>
        <div class="cart-spend d-block d-sm-none">
            <div class="d-flex justify-content-between align-items-center small mb-2">
                <span class="fw-bolder">Cart Total</span>
                <span> <span class="cart_total_amount_mob">0.00</span> {{$currency}}</span>
            </div>

        </div>
        <div class="text-center">
            <a onclick="proceed_to_ckeckout()" href="#" class="btn btn-default mt-4 mb-3 mx-auto d-inline-block d-sm-none">Proceed
                to checkout</a>
        </div>
    </div>
</section>
<!-- ------------- CART LANDING ~ ENDS ------------------- -->
@else

<section class="bg-white w-100 pb-2 py-sm-5 position-relative cart-section">
    <div class="container pt-5">
        <div class="row pt-5 ">
            <div class="col-12 d-sm-block">
                <div
                    class="common-sub-heading d-flex justify-content-between align-items-center mw-set mb-5 d-none d-sm-block">
                    <span>Shopping Cart</span>
                    <span>0 items</span>
                </div>
                <div
                    class="common-sub-heading d-flex justify-content-center align-items-center mw-set mb-3 d-block d-sm-none">
                    <span class="play-fair">Shopping Cart</span>
                </div>
                <div class="poppins text-center pb-5">
                    <img src="/website/images/empty-cart.png" class="img-fluid opacity-75 empty-cart">
                    <h4 class="fs-2 fw-bold text-default-green text-custom">Empty Cart !</h4>
                    <p class="opacity-75">Looks like your cart is empty.</p>
                    <a href="{{route('website_menu')}}"><button class="btn btn-default mt-3">Return to Menu</button></a>
                </div>
            </div>

        </div>
    </div>
</section>
@endif

@stop