@extends('layouts.app')

@section('styles')


@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Manage Section</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Website</a></li>
            <li class="breadcrumb-item active" aria-current="page">Manage Section</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['section-create','section-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Section</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="section_id" name="section_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">
                        @foreach($data['available_languages'] as $available_language)
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Section Name
                                {{$available_language['language_short_code']}} *</label>
                            <input
                                data-parsley-required-message="Section Name {{$available_language['language_name']}} Required"
                                type="text" class="form-control"
                                name="section_name_{{$available_language['language_id']}}"
                                id="section_name_{{$available_language['language_id']}}" value="" required>

                        </div>
                        @endforeach

                    </div>
                    <div class="form-row">
                        <div class="col-xl-12  mb-3">

                            <label class="form-label">Choose Section Recipies</label>
                            <select name="section_recipies[]" id="section_recipies" multiple="multiple"
                                class="group-filter">

                                @foreach($data['category_wise_recipies'] as $categories)
                                @if(count($categories->recipe)>0)
                                <optgroup label="{{$categories['category_name']}}">
                                    @foreach($categories->recipe as $recipe)
                                    <option value="{{ $recipe['recipe_id']}}">{{ $recipe['recipe_name']}}</option>
                                    @endforeach
                                </optgroup>
                                @endif
                                @endforeach

                            </select>
                        </div>
                    </div>

                    @can('adds_on-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('add_section', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('adds_on-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('{{route('update_section')}}', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan

                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->

<!-- Row -->
@can('adds_on-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Section</h3>

            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered  border-bottom dataTable no-footer "
                        style="width: 100% !important;" id="table_datatable">
                        <thead class="text-center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0 ">Name</th>
                                <th class="wd-15p border-bottom-0 ">Status</th>
                                <th class="wd-15p border-bottom-0 ">Added By</th>
                                <th class="wd-10p border-bottom-0 ">Actions</th>
                            </tr>
                        </thead>

                    </table>

                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->



<!-- ####################################delete Modal ########################### -->
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete the Section ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>
<!-- ################################ delete Modal################################## -->


<!-- {{-- #########################View Modal################################### --}} -->
<div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder" id="view_modal_title"></h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body" id="view_modal_body">

            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- {{-- #########################End Of View Modal############################ --}} -->



@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
{{-- <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script> --}}
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>

<script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>

{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": true,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [0, 4],
            "orderable": true
        },
        {
            "className": "text-center",
            "targets": [0, 2, 3, 4]
        },
        {
            "className": "text-left",
            "targets": []
        }, {
            "className": "text-end",
            "targets": []
        }

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('section_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "section_id",
            "name": "section_id"
        },
        {
            "data": "section_name",
            "name": "section_name"
        },
        {
            "data": "section_id",
            "name": "section_id"
        },
        {
            "data": "name",
            "name": "name"
        },


        {
            "data": "section_id",
            "name": "section_id"
        },
    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";

        if (aData.section_active_status == 0) {
            var checked = "checked";
            var status = 1;
            var active_class_name = "bg-primary";
        } else {
            var checked = "";
            var status = 0;
            var active_class_name = "";
        }



        //Edit Action
        var action = action + '&nbsp;<button title="Edit"  onclick=View(' + aData.section_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-success"><span class="fe fe-eye"> </span></button>';
        @can('adds_on-edit')
        var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.section_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('adds_on-delete')
        var action = action + '&nbsp;<button title="Delete" onclick="delete_modal(' + aData.section_id +
            ')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan

        var active_status = '<label class="switch"><input type="checkbox" onchange="change_status(' + aData
            .section_id + ',' + status + ')" ' + checked + '><span class="slider ' + active_class_name +
            '"></span></label>';

        $('td:eq(0)', nRow).html(index);
        $('td:eq(2)', nRow).html(active_status);
        $('td:eq(4)', nRow).html(action);
    }
});

// #################### View Section ############################
function View(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('section_view')}}",
        success: function(result) {
            $('#view_modal_title').text('Section Details');
            $('#view_modal_body').html(result);
            $('#scrollingmodal').modal('show');
        }
    })
}

//#######################End Of View Section ##################
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_section')}}",
        success: function(result) {
            $('#section_id').val(result.section_id);
            // #################Add On  Name Section########
            var multi_languae = JSON.parse(result.section_name_multi_language);
            $.each(multi_languae, function(index, value) {
                $('#section_name_' + index).val(value);
            });
            // ######################End Of  Name Section############
            var section_recipies = result.recipies;
            $select = $("#section_recipies");
            $select.multipleSelect();
            $select.multipleSelect("setSelects", section_recipies);

            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();

        }
    })
}




// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#section_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#section_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_section')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, datatable_name);
        }
    })
}
// #################### End Of Delete Section ##################

//####################Status  Change Section#################### 
function change_status(id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "section_id": id,
            'status': status
        },
        url: "{{route('change_section_status')}}",
        success: function(result) {
            toast(result, 'table_datatable');
        }
    })
}
// #################### End Status  Change Section##############

// ######################Section Recipe Remove ##################
function remove_item(section_id, recipe_id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": recipe_id,
            'section_id': section_id
        },
        url: "{{route('section_remove_recipe')}}",
        success: function(result) {
            var balance_recipies = result.data;
            $('#section_recie_modal').html('');
            for (var i = 0; i <= balance_recipies.length; i++) {
                var recipe_id = balance_recipies[i]['recipe_id'];
                var recipe_name = balance_recipies[i]['recipe_name'];
                var recipe_image = balance_recipies[i]['recipe_image'];
                var recipe_price = balance_recipies[i]['recipe_price'];
                var recipe_offer_price = balance_recipies[i]['recipe_offer_price'];
                if (recipe_price > recipe_offer_price) {
                    var recipe_org_price = recipe_offer_price.toFixed(2);
                } else {
                    var recipe_org_price = recipe_price.toFixed(2);
                }
                var j = i + 1;

                $('#section_recie_modal').append('<tr><td class="center">' + j +
                    '</td><td class="text-left">' + recipe_name +
                    '</td><td class="text-center"><img class="w-20" src="/uploads/recipe_images/' +
                    recipe_image + '"></td><td class="text-end">' + recipe_org_price +
                    '</td><td class="text-center"><i class="fa fa-close" onclick="remove_item(' +
                    section_id + ',' + recipe_id + ')"></i></td></tr>')

            }

            toast(result, 'table_datatable');
        }
    })
}
// ###################  End Of Section Recipe Remove ###########
</script>


@endsection