@extends('layouts.app')


@section('content')

    <!-- PAGE-HEADER -->
    <div class="page-header">
        <h1 class="page-title">Manage Section</h1>
        <div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Recipe</a></li>
                <li class="breadcrumb-item active" aria-current="page">Import</li>
            </ol>
        </div>
    </div>
    <!-- PAGE-HEADER END -->

    <!-- ROW-1 OPEN -->
    @canany(['section-create','section-edit'])
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row w-100">
                            <div class="col-lg-10">
                                <h3 class="card-title">Import</h3>
                            </div>
                            <div class="col-lg-2">
                                <a href="{{url('/public/sample_menu/Sample Menu.xlsx')}}" download id="cancel_btn"
                                   class="text-white btn custom-btn-danger"><i class="fa fa-download me-1"></i>Sample
                                    Excel</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif

                        <form action="/admin/import-recipes-post" method="POST" enctype="multipart/form-data">
                            @csrf
                            {{-- <input type="text" name="category" value="KIDS MEAL"> --}}
                            <div class="form-group">
                                <div class="col-xl-4 mb-3">
                                    <label for="file">Select Excel File:</label>
                                    <input class="form-control" type="file" name="file" required>
                                </div>
                                <div class="col-xl-4 mb-3">
                                    <button class="btn btn-success" type="submit">Import</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endcanany


@endsection
