@extends('layouts.app')

        @section('styles')

        @endsection

            @section('content')

            <style>
                   
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #1c1c1c;
}

input:focus + .slider {
  box-shadow: 0 0 1px #1c1c1c;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
            </style>
            

                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Add Subscription Package</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                         <li class="breadcrumb-item"><a href="javascript:void(0)">Master Settings</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Add Subscription Package</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            @canany(['subscription-package-manage-create','subscription-package-manage-edit'])
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Package</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                                                    <input id="subscription_id" name="subscription_id" type="hidden" value="">
                                                    
                                                    @csrf

                                                <div class="form-row">
                                            
                                                    <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Subscription  Name *</label>
                                                        <input data-parsley-required-message="Subscription Name Required" type="text" class="form-control" name="subscription_name" id="subscription_name"
                                                            value="" required>
                                                            
                                                    </div>
                                                   
                                                   
                                                        <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Subscription  Description *</label>
                                                        <textarea class="form-control" name="subscription_desc" id="subscription_desc" cols="10" rows="2" data-parsley-required-message="Subscription Description Required" required></textarea>
                                            
                                                    </div>

                                                      <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Subscription  Days *</label>
                                                        <input data-parsley-required-message="Subscription Days Required" type="number" min="1" class="form-control" name="subscription_days" id="subscription_days"
                                                            value="" required>    
                                                    </div>

                                                    <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Subscription  Price *</label>
                                                        <input data-parsley-required-message="Subscription Price Required" min="1" type="number" class="form-control" name="subscription_price" id="subscription_price"
                                                            value="" required>    
                                                    </div>
                                                    
                                                    
                                                  
                                                 
                                                </div>
                                                @can('subscription-package-manage-create')
                                                <a id="create_btn" href="#" onclick="createOrUpdate('add_subscription', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                                                @endcan
                                                @can('subscription-package-manage-edit')
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('update_subscription', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                                                @endcan
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                             @endcanany
                            <!-- /ROW-1 CLOSED -->

                               <!-- Row -->
                        @can('subscription-package-manage-list')
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View packages</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                             <table  class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Subscription Name</th>
                                                        <th class="wd-15p border-bottom-0">Validity(Days)</th>
                                                        <th class="wd-15p border-bottom-0">Price</th>
                                                        <th class="wd-15p border-bottom-0">Added By</th>
                                                        <th class="wd-10p border-bottom-0">Actions</th>
                                                    </tr>
                                                </thead>
                                               
                                            </table>
                                    
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        @endcan
                        <!-- End Row -->



         <!-- {{-- ############View Modal######################### --}} -->
        
           <div class="modal fade" id="scrollingmodal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg " role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">View Subscription Details</h5>
                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                    </div>
                    <div class="modal-body" id="view_modal_body">
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <!--<button class="btn btn-primary">Save changes</button>-->
                    </div>
                </div>
            </div>
        </div>
        
    <!-- {{-- ####################End Of View Modal############ --}} -->




                         <!-- Modal -->
               


                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete the Subscription Type ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn btn-primary">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                

    

            @endsection
              @section('scripts')  
{{-- ################################Jquery Datatable########################### --}}
   <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
   <link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
   <script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
 {{-- ########################################################################## --}}
 

    
    
    

        <script>
    var public_url="{{url('/')}}/{{env('ADMIN_PANEL_ROUTE')}}";
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    var coloumn_data=['subscription_type_id','subscription_type_name','subscription_type_days','subscription_type_price','name','subscription_type_id'];
    var coloumn_array=[];
    for (let i = 0; i <coloumn_data.length; i++) {
        coloumn_array.push({"data": ""+coloumn_data[i]+"", "name": ""+coloumn_data[i]+""});
    }
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": false,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],

       "columnDefs": [{
               "targets": [0,coloumn_data.length-1],
               "orderable": false
           },
           {"className": "text-center", "targets": [0,2,4,5]},
           {"className": "text-left", "targets": [1]},
            {"className": "text-end", "targets": [3]},
           {"orderable": false, "targets": [5]}

           
       ],
       "displayLength":10,
       "ajax": {
           "url":  public_url+"/subscription_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns":coloumn_array,
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          var created_at=aData.created_at.substring(0, 10);

            var action=action+'&nbsp;<button title="Edit"  onclick=View('+aData.subscription_type_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
            @can('subscription-package-manage-edit')
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.subscription_type_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            @endcan
            //Delete Action
            @can('subscription-package-manage-delete')
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.subscription_type_id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            @endcan

            


            
            $('td:eq(0)', nRow).html(index);
            $('td:eq(5)', nRow).html(action).addClass('text-center');
         
 }
 });

//        // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: public_url+'/edit_subscription',
                    success: function (result) {
                        $('#subscription_id').val(result.subscription_type_id);
                        $('#subscription_name').val(result.subscription_type_name);
                        $('#subscription_desc').val(result.subscription_type_description);
                        $('#subscription_days').val(result.subscription_type_days);
                        $('#subscription_price').val(result.subscription_type_price);
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#back-to-top').click();
                        }
                })
                }
//       // #################### End Of Edit Section ####################
//      // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#subscription_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#subscription_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: public_url+'/delete_subscription',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
//      // #################### End Of Delete Section ##################

        // #########################View Section ##########################
        function View(id){
            $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: public_url+'/view_subscritpion',
                        success: function (result) {    
                           $('#view_modal_body').html(result);
                           $('#scrollingmodal').modal('show');
                        }
                    })
        }
        // ###############################################################




    </script>
    
        @endsection


