@extends('layouts.app')

        @section('styles')

        @endsection

            @section('content')

            <style>
                   
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #1c1c1c;
}

input:focus + .slider {
  box-shadow: 0 0 1px #1c1c1c;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
            </style>
            

                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Manage Subscription</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                         <li class="breadcrumb-item"><a href="javascript:void(0)">Subscription</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Manage Subscription</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            @canany(['custom-subscription-create','custom-subscription-edit'])
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Subscription</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                                                    <input id="subscription_id" name="subscription_id" type="hidden" value="">
                                                    
                                                    @csrf

                                                <div class="form-row">
                                            
                                                    <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Subscription  Name *</label>
                                                        <input data-parsley-required-message="Subscription Name Required" type="text" class="form-control" name="subscription_name" id="subscription_name"
                                                            value="" required>
                                                            
                                                    </div>
                                                   

                                                      <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Subscription  Days *</label>
                                                        <input data-parsley-required-message="Subscription Days Required" type="number" min="1" class="form-control" name="subscription_days" id="subscription_days"
                                                            value="" required>    
                                                    </div>

                                                    <div class="col-xl-3 mb-3">
                                                        <label for="validationTooltip01">Subscription  Price *</label>
                                                        <input data-parsley-required-message="Subscription Price Required" min="1" type="number" class="form-control" name="subscription_price" id="subscription_price"
                                                            value="" required>    
                                                    </div>
                                                    
                                                    
                                                  
                                                 
                                                </div>
                                                @can('custom-subscription-create')
                                                <a id="create_btn" href="#" onclick="createOrUpdate('add_custom_subscription', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                                                @endcan
                                                @can('custom-subscription-edit')
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('update_custom_subscription', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                                                @endcan
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                             @endcanany
                            <!-- /ROW-1 CLOSED -->

                               <!-- Row -->
                        @can('custom-subscription-list')
                         <div class="row">
                            <div class="col-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title mb-0">View  Subscription History </h3>
                                    </div>
                                    <div class="card-body pt-4">
                                        <div class="grid-margin">
                                            <div class="">
                                                <div class="panel panel-primary">
                                                    <div class="tab-menu-heading border-0 p-0">
                                                        <div class="tabs-menu1">
         
                                                       
                                                        </div>
                                                    </div>
                                                    <div class="panel-body tabs-menu-body border-0 pt-0">
                                                        <div class="tab-content">
                                                            <div class="tab-pane active" id="tab5">
                                                                <div class="table-responsive">
                                                                    <table class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;"  id="table_datatable"
                                                                        class="table table-bordered text-nowrap mb-0">
                                                                        <thead class="border-top text-center">
                                                                            <tr>
                                                                     <th class="bg-transparent border-bottom-0" style="width: 5%;">#</th>
                                                                    <th class="bg-transparent border-bottom-0">Subscription </th>
                                                                    <th class="bg-transparent border-bottom-0">Price</th>
                                                                    <th class="bg-transparent border-bottom-0">Days</th>
                                                                    <th class="bg-transparent border-bottom-0">From Date</th>
                                                                     <th class="bg-transparent border-bottom-0">To Date </th>
                                                                    <th class="bg-transparent border-bottom-0">Status</th>
                                                                    <!-- <th class="bg-transparent border-bottom-0">Action</th> -->
                                                                            </tr>
                                                                        </thead>
                                                               
                                                                    </table>
                                                                </div>
                                                            </div>
                                                           
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endcan
                        <!-- End Row -->


            @endsection
              @section('scripts')  
{{-- ################################Jquery Datatable########################### --}}
   <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
   <link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
   <script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
 {{-- ########################################################################## --}}
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var base_url='{{url('/')}}';
    var public_url="{{url('/')}}/{{env('ADMIN_PANEL_ROUTE')}}";
    var datatable_name="table_datatable";
$('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,3,4,5,6]},
           {"className": "text-left", "targets": [1]},
           {"className": "text-end", "targets": [2]},
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  public_url+"/subscription_history_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "subscription_history_id", "name": "subscription_history_id"},
                  {"data": "subscription_type_name", "name": "subscription_type_name"},
                  {"data": "subscription_price", "name": "subscription_price"},
                  {"data": "subscription_days", "name": "subscription_days"},
                  {"data": "subscription_from_date", "name": "subscription_from_date"}, 
                  {"data": "subscription_to_date", "name": "subscription_to_date"},
                  {"data": "subscription_current_status", "name": "subscription_current_status"},
                //   {"data": "subscription_history_id", "name": "subscription_history_id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));       
          var action="";
          var price=parseInt(aData.subscription_price).toFixed(2);
          if(aData.subscription_name){
            var subscription_name=aData.subscription_name;
          }
          else{
            var subscription_name=aData.subscription_type_name;
          }
          switch (aData.subscription_current_status) {
                case "Actived":
                   var curent_status="<span class='fw-bold text-success'> Actived </span>";
                    break;
                case "Hold":
                    var curent_status="<span class='fw-bold text-warning'> On Hold </span>";
                    break;
                case "Expired":
                    var curent_status="<span class='fw-bold text-danger'> Expired </span>";
                    break;

                }

            @can('custom-subscription-edit')
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.subscription_history_id+') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
            @endcan
            //Delete Action
            @can('custom-subscription-delete')
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.subscription_history_id+')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
            @endcan

            $('td:eq(0)', nRow).html(index);
            $('td:eq(1)', nRow).html(subscription_name);
             $('td:eq(2)', nRow).html(price);
            $('td:eq(6)', nRow).html(curent_status);
            // $('td:eq(7)', nRow).html(action);
            
 }
 });




        </script>
        @endsection


