@extends('layouts.app')

@section('styles')


@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Subcategory</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Recipies</a></li>
            <li class="breadcrumb-item active" aria-current="page">Subcategory</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['subcategory-create','subcategory-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Subcategory</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="subcategory_id" name="subcategory_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Choose Category *</label>
                            <select class="form-control" name="category" id="category"
                                data-parsley-required-message="Category Required" required>
                                <option value="">-- Choose Category --</option>
                                @foreach($category_data as $category)
                                <option value="{{$category->category_id}}"> {{$category->category_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        @foreach($available_languages as $available_language)
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Subcategory Name
                                {{$available_language['language_short_code']}} *</label>
                            <input required
                                data-parsley-required-message="Subcategory Name {{$available_language['language_name']}} Required"
                                type="text" class="form-control"
                                name="subcategory_name_{{$available_language['language_id']}}"
                                id="subcategory_name_{{$available_language['language_id']}}" value="">

                        </div>
                        @endforeach

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Subcategory Icon ({{env('SUBCATEGORYIMAGESIZE')}}px)
                                *</label>
                            <input type="file" data-parsley-required-message="Subcategory Image Requied"
                                class="form-control custom-input-file" name="image" id="image" value="">
                        </div>

                        @foreach($available_languages as $available_language)
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Subcategory Banner Name
                                {{$available_language['language_short_code']}} </label>
                            <input type="text" class="form-control"
                                name="subcategory_banner_name_{{$available_language['language_id']}}"
                                id="subcategory_banner_name_{{$available_language['language_id']}}" value="">

                        </div>
                        @endforeach
                        @foreach($available_languages as $available_language)
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Subcategory Banner Description
                                {{$available_language['language_short_code']}} </label>
                            <input type="text" class="form-control"
                                name="subcategory_banner_description_{{$available_language['language_id']}}"
                                id="subcategory_banner_description_{{$available_language['language_id']}}" value="">

                        </div>
                        @endforeach
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Subcategory Banner Image
                                ({{env('SUBCATEGORYBANNERSIZE')}}px)
                            </label>
                            <input type="file" class="form-control custom-input-file" name="subcategory_banner"
                                id="subcategory_banner" value="">
                        </div>
                    </div>
                    @can('subcategory-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('add_subcategory', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('subcategory-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('update_subcategory', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->

<!-- Row -->
@can('subcategory-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Subcategories</h3>
                <div class="card-options">
                    <button type="button" onclick="$('#change_order').modal('show');"
                        class="btn btn-sm btn-icon btn-facebook"><i class="fa fa-sort"></i>&nbsp;&nbsp;Change
                        Order</button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom dataTable no-footer "
                        style="width: 100% !important;" id="table_datatable">
                        <thead class="text-center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0">Subcategory</th>
                                <th class="wd-15p border-bottom-0">Category</th>
                                <th class="wd-15p border-bottom-0">Icon</th>
                                <th class="wd-15p border-bottom-0">Added By</th>
                                <th class="wd-10p border-bottom-0">Actions</th>
                            </tr>
                        </thead>

                    </table>

                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->

<!-- ####################################Delete Modal ############################# -->
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete the Subcategory ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>
<!-- ######################################End Of Delete Modal ################ -->

<!-- ################################Order Modal ######################### -->

<div class="modal  fade" id="change_order" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">

                <h5 class="modal-title fw-bolder">Change Subcategory Sort Order</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">



                <div id="imageListId" class="row">
                    @foreach($subcategory_data as $subcatmodal)
                    <div id="imageNo{{ $subcatmodal->subcategory_id }}"
                        class="col-md-12 col-lg-6 col-xl-3 listitemClass">
                        <div class="thumbnail text-center">
                            <a href="javascript:void(0)">
                                <img src="{{ asset('/uploads/subcategory_images/'.$subcatmodal->subcategory_image) }}"
                                    alt="thumb1" class="thumbimg">
                            </a>
                            <div class="caption ">
                                <h4><strong>{{ $subcatmodal->subcategory_name }}</strong></h4>
                            </div>
                        </div>
                    </div>

                    @endforeach
                </div>

                <input type="hidden" id="outputvalues">

            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button class="btn btn-primary" data-bs-dismiss="modal" onclick="saveorder()">Update Order</button>
            </div>
        </div>
    </div>
</div>

<!-- ######################################### End Of Order Modal ######################### -->

<!-- {{-- #########################View Modal################################### --}} -->
<div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder" id="view_modal_title"></h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body" id="view_modal_body">

            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- {{-- #########################End Of View Modal############################ --}} -->



@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
{{-- <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script> --}}
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>

<script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>

{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var public_url = "{{url('/')}}/{{env('ADMIN_PANEL_ROUTE')}}";
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": true,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [0, 4],
            "orderable": true
        },
        {
            "className": "text-center",
            "targets": [0, 3, 4, 5]
        },
        {
            "className": "text-left",
            "targets": [1, 2, ]
        }

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('subcategory_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "subcategory_id",
            "name": "subcategory_id"
        },
        {
            "data": "subcategory_name",
            "name": "subcategory_name"
        },
        {
            "data": "category_name",
            "name": "category_name"
        },
        {
            "data": "subcategory_id",
            "name": "subcategory_id"
        },
        {
            "data": "name",
            "name": "name"
        },
        {
            "data": "subcategory_id",
            "name": "subcategory_id"
        },
    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";
        if (aData.subcategory_image == "" || aData.subcategory_image == null) {
            aData.subcategory_image = "no_image.png";
        }
        var image = '<a style="cursor: pointer;" href="/uploads/subcategory_images/' + aData
            .subcategory_image +
            '" target="_blank"><img style="width:30px; height:30px" src="/uploads/subcategory_images/' +
            aData.subcategory_image + '"></a>';
        //View Section
        var action = action + '&nbsp;<button title="VIew"  onclick=View(' + aData.subcategory_id +
            ') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';

        //Edit Action
        @can('subcategory-edit')
        var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.subcategory_id +
            ') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('subcategory-delete')
        var action = action + '&nbsp;<button title="Delete" onclick="delete_modal(' + aData.subcategory_id +
            ')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan
        $('td:eq(0)', nRow).html(index);
        $('td:eq(3)', nRow).html(image);
        $('td:eq(5)', nRow).html(action);
    }
});

// #################### View Section ############################
function View(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('subcategory_view')}}",
        success: function(result) {
            $('#view_modal_title').text('Subcategory Details');
            $('#view_modal_body').html(result);
            $('#scrollingmodal').modal('show');
        }
    })
}

//#######################End Of View Section ##################
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_subcategory')}}",
        success: function(result) {
            $('#subcategory_id').val(result.subcategory_id);
            $('#category').val(result.subcategory_cid);
            //Multi Languae Subcategory Name Section
            var multi_languae = JSON.parse(result.subcategory_name_multi_language);
            $.each(multi_languae, function(index, value) {
                $('#subcategory_name_' + index).val(value);
            });
            //End Of Multilanguage Subcategory Name

            //Multi Languae Subcategory banner Name Section
            var multi_languae = JSON.parse(result.subcategory_multi_banner_heading);
            $.each(multi_languae, function(index, value) {
                $('#subcategory_banner_name_' + index).val(value);
            });
            //End Of Multilanguage Subcategory banner Name
            //Multi Languae Subcategory banner Descriptin Section
            var multi_languae = JSON.parse(result.subcategory_multi_banner_heading);
            $.each(multi_languae, function(index, value) {
                $('#subcategory_banner_description_' + index).val(value);
            });
            //End Of Multilanguage Subcategory banner Descriptin
            $('#image').removeAttr('required');
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();

        }
    })
}
// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#subcategory_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#subcategory_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_subcategory')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, datatable_name);
        }
    })
}
// #################### End Of Delete Section ##################


$(function() {
    $("#imageListId").sortable({
        update: function(event, ui) {
            getIdsOfImages();
        } //end update         
    });
});

function getIdsOfImages() {
    var values = [];
    $('.listitemClass').each(function(index) {
        values.push($(this).attr("id")
            .replace("imageNo", ""));
    });

    $('#savebtnget').css('display', 'inline-block')
    $('#outputvalues').val(values);
}

function saveorder() {
    var ids = $('#outputvalues').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "ids": ids
        },
        url: "{{route('subcategory_change_order')}}",
        success: function(result) {
            $('#change_order').modal('hide');
            toast(result, datatable_name);
            setTimeout(function() {
                location.reload();
            }, 2000);

        }
    });
}
</script>


@endsection