@extends('layouts.app')

@section('styles')

@endsection

@section('content')
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Stock Log</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Stock</a></li>
            <li class="breadcrumb-item active" aria-current="page">Stock Log</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- Row -->
@can('stock-list')
<div class="row">
    <div class="col-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title mb-0">View Stock Logs</h3>
            </div>
            <div class="card-body pt-4">
                <div class="grid-margin">
                    <div class="">
                        <div class="panel panel-primary">
                            <div class="tab-menu-heading border-0 p-0">
                                <div class="tabs-menu1">

                                    <ul class=" nav panel-tabs product-sale">

                                        <li class="px-1">

                                            <div class="input-group">
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div>
                                                @php
                                                $from_date="";
                                                if(session('from_date')){
                                                $from_date=session('from_date');
                                                }
                                                @endphp
                                                <input class="form-control fc-datepicker from_date"
                                                    placeholder="From Date" value="{{$from_date}}" type="text">
                                            </div>
                                        </li>

                                        <li class="px-1">
                                            <div class="input-group">
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div>
                                                @php
                                                $to_date="";
                                                if(session('to_date')){
                                                $to_date=session('to_date');
                                                }
                                                @endphp
                                                <input class="form-control fc-datepicker to_date" placeholder="To Date"
                                                    value="{{$to_date}}" type="text">
                                            </div>
                                        </li>


                                        <li class="px-1">
                                            <div class="input-group">
                                                <button id="reset_btn" class="btn btn-danger"><i
                                                        class="fa fa-repeat"></i></button>
                                            </div>
                                        </li>


                                    </ul>
                                </div>
                            </div>
                            <div class="panel-body tabs-menu-body border-0 pt-0">
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab5">
                                        <div class="table-responsive">
                                            <table class="table table-bordered text-nowrap border-bottom "
                                                style="width: 100% !important;" id="table_datatable">
                                                <thead class="border-top text-center">
                                                    <tr>
                                                        <th class="bg-transparent border-bottom-0 w-5">#</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Date
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Time
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Name</th>

                                                        <th class="bg-transparent border-bottom-0 w-5">Recent Stock
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Change Stock
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Updated Stock
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Comments
                                                        </th>


                                                    </tr>
                                                </thead>
                                                <tbody></tbody>


                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endcan



@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": false,
    "searching": true,
    "bLengthChange": false,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [],
            "orderable": false
        },
        {
            "className": "text-center",
            "targets": [0, 1, 2, 4, 5, 6]
        },
        {
            "className": "text-left",
            "targets": [3, 7]
        },
        {
            "className": "text-end",
            "targets": []
        },

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('stock_log_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "stock_log_id",
            "name": "stock_log_id"
        },
        {
            "data": "stock_log_date",
            "name": "stock_log_date"
        },
        {
            "data": "stock_log_time",
            "name": "stock_log_time"
        },
        {
            "data": "stock_log_item_name",
            "name": "stock_log_item_name"
        },
        {
            "data": "stock_log_current_stock",
            "name": "stock_log_current_stock"
        },

        {
            "data": "stock_log_changing_qty",
            "name": "stock_log_changing_qty"
        },
        {
            "data": "stock_log_updated_qty",
            "name": "stock_log_updated_qty"
        },
        {
            "data": "stock_log_comment",
            "name": "stock_log_comment"
        },




    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        $('td:eq(0)', nRow).html(index);

        if (aData.stock_log_type == 0) {
            var textClass = "text-danger fw-bolder";
            var changed_qty = '-' + aData.stock_log_changing_qty;
        } else {
            var textClass = "text-success fw-bolder";
            var changed_qty = '+' + aData.stock_log_changing_qty;
        }

        $('td:eq(4)', nRow).addClass(textClass);
        $('td:eq(5)', nRow).html(changed_qty).addClass(textClass);
        $('td:eq(6)', nRow).addClass(textClass);


    },

});


$('.from_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "from_date": $('.from_date').val()
        },
        url: public_url + '/from_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('.to_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "to_date": $('.to_date').val()
        },
        url: public_url + '/to_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('#reset_btn').click(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token
        },
        url: public_url + '/reset_session',
        success: function(result) {
            $('.from_date').val('');
            $('.to_date').val('');
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })
});
</script>
<script src="{{asset('assets/js/tooltip&popover.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.js')}}"></script>
<!-- TIMEPICKER JS -->
<script src="{{asset('assets/plugins/time-picker/jquery.timepicker.js')}}"></script>
<script src="{{asset('assets/plugins/time-picker/toggles.min.js')}}"></script>
<!-- INTERNAL jquery transfer js-->
<script src="{{asset('assets/plugins/jQuerytransfer/jquery.transfer.js')}}"></script>
<!-- DATEPICKER JS -->
<script src="{{asset('assets/plugins/date-picker/date-picker.js')}}"></script>
<script src="{{asset('assets/plugins/date-picker/jquery-ui.js')}}"></script>
<script src="{{asset('assets/plugins/input-mask/jquery.maskedinput.js')}}"></script>
<!-- FORMELEMENTS JS -->
<script src="{{asset('assets/js/formelementadvnced.js')}}"></script>
<script src="{{asset('assets/js/form-elements.js')}}"></script>
@endsection