@extends('layouts.app')

@section('styles')

@endsection

@section('content')
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Stock Management</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Stock</a></li>
            <li class="breadcrumb-item active" aria-current="page">Stock Management</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- Row -->
@canany(['stock-create','stock-list','stock-edit','stock-delete'])
<div class="row">
    <div class="col-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title mb-0">View Stocks</h3>
            </div>
            <div class="card-body pt-4">
                <div class="grid-margin">
                    <div class="">
                        <div class="panel panel-primary">
                            <div class="tab-menu-heading border-0 p-0">
                                <div class="tabs-menu1">

                                    <ul class=" nav panel-tabs product-sale">





                                    </ul>
                                </div>
                            </div>
                            <div class="panel-body tabs-menu-body border-0 pt-0">
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab5">
                                        <div class="table-responsive">
                                            <table class="table table-bordered text-nowrap border-bottom "
                                                style="width: 100% !important;" id="table_datatable">
                                                <thead class="border-top text-center">
                                                    <tr>
                                                        <th class="bg-transparent border-bottom-0 w-5">#</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Recipe Name
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Price
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Offer Price</th>

                                                        <th class="bg-transparent border-bottom-0 w-5">Stock
                                                        </th>

                                                        <th class="bg-transparent border-bottom-0 w-5">Action
                                                        </th>


                                                    </tr>
                                                </thead>
                                                <tbody></tbody>


                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endcanany


@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": false,
    "searching": true,
    "bLengthChange": false,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [],
            "orderable": false
        },
        {
            "className": "text-center",
            "targets": [0, 5]
        },
        {
            "className": "text-left",
            "targets": []
        },
        {
            "className": "text-end",
            "targets": [2, 3]
        },

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('stock_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "recipe_id",
            "name": "recipe_id"
        },
        {
            "data": "recipe_name",
            "name": "recipe_name"
        },
        {
            "data": "recipe_price",
            "name": "recipe_price"
        },
        {
            "data": "recipe_offer_price",
            "name": "recipe_offer_price"
        },
        {
            "data": "recipe_stock",
            "name": "recipe_stock"
        },

        {
            "data": "recipe_id",
            "name": "recipe_id"
        },




    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        $('td:eq(0)', nRow).html(index);

        var recipe_price = parseInt(aData.recipe_price).toFixed(2);
        var recipe_offer_price = parseInt(aData.recipe_offer_price).toFixed(2);
        var recipe_stock = aData.recipe_stock;

        $('td:eq(2)', nRow).html(recipe_price + " {{session('layout_data')->currency}}");
        $('td:eq(3)', nRow).html(recipe_offer_price + " {{session('layout_data')->currency}}");


        $('td:eq(4)', nRow).html(
            '<div class="form-group"><input id="stock_value_item' +
            aData.recipe_id + '" class="form-control form-control-sm text-center" value="' +
            recipe_stock + '"  type="text"></div>'
        );
        $('td:eq(5)', nRow).html(
            '<div class="form-group"><button onclick="update_stock(' + aData.recipe_id +
            ')" class="btn btn-primary btn-sm">Update</button></div>'
        );


    },

});


$('.from_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "from_date": $('.from_date').val()
        },
        url: public_url + '/from_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('.to_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "to_date": $('.to_date').val()
        },
        url: public_url + '/to_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('#reset_btn').click(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token
        },
        url: public_url + '/reset_session',
        success: function(result) {
            $('.from_date').val('');
            $('.to_date').val('');
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })
});

function update_stock(item_id) {
    var updating_stock = $('#stock_value_item' + item_id).val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "item_id": item_id,
            "updating_stock": updating_stock
        },
        url: "{{route('update_stock')}}",
        success: function(result) {

            toast(result, datatable_name);
        }
    })


}
</script>
<script src="{{asset('assets/js/tooltip&popover.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.js')}}"></script>
<!-- TIMEPICKER JS -->
<script src="{{asset('assets/plugins/time-picker/jquery.timepicker.js')}}"></script>
<script src="{{asset('assets/plugins/time-picker/toggles.min.js')}}"></script>
<!-- INTERNAL jquery transfer js-->
<script src="{{asset('assets/plugins/jQuerytransfer/jquery.transfer.js')}}"></script>
<!-- DATEPICKER JS -->
<script src="{{asset('assets/plugins/date-picker/date-picker.js')}}"></script>
<script src="{{asset('assets/plugins/date-picker/jquery-ui.js')}}"></script>
<script src="{{asset('assets/plugins/input-mask/jquery.maskedinput.js')}}"></script>
<!-- FORMELEMENTS JS -->
<script src="{{asset('assets/js/formelementadvnced.js')}}"></script>
<script src="{{asset('assets/js/form-elements.js')}}"></script>
@endsection