@extends('layouts.app')
@section('styles')
<link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />
@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Manage Restaurant Table</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Manage</a></li>
            <li class="breadcrumb-item active" aria-current="page">Restaurant Table</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['resturant-table-create','resturant-table-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Restaurant Table</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="res_table_id" name="res_table_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Table Name/Code *</label>
                            <input data-parsley-required-message="Table Name Required" type="text" class="form-control"
                                name="res_table_name" id="res_table_name" value="" required>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Seating Count *</label>
                            <input type="text" data-parsley-required-message="Seating Count  Required"
                                class="form-control" name="seating_count" id="seating_count" value="" required>
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Table Format *</label>
                            <select class="form-control" name="table_format" id="table_format" required
                                data-parsley-required-message="Table Format Required">
                                <option value="">--Choose Table Format--</option>
                                <option value="0">Not Available</option>
                                <option value="1x1">1 X 1</option>
                                <option value="2x2">2 X 2</option>
                                <option value="3x3">3 X 3</option>
                                <option value="4x4">4 X 4</option>
                                <option value="4x4">5 X 5</option>
                                <option value="4x4">6 X 6</option>
                            </select>
                        </div>
                    </div>
                    @can('resturant-table-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('{{route('add_table')}}', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('resturant-table-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('{{route('update_table')}}', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->
<!-- Row -->
@can('resturant-table-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Restaurant table</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom " id="table_datatable">
                        <thead class="text-center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0">Table Name</th>
                                <th class="wd-15p border-bottom-0">Seating</th>
                                <th class="wd-10p border-bottom-0">Format</th>
                                <th class="wd-10p border-bottom-0">Active/Inactive </th>
                                @canany(['resturant-table-edit','resturant-table-delete'])
                                <th class="wd-10p border-bottom-0">Actions</th>
                                @endcan
                            </tr>
                        </thead>

                    </table>
                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>




@endsection

@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css?v1')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var coloumn_data = ['table_id', 'table_name', 'table_seating_count', 'table_format', 'table_id'];
@canany(['resturant-table-edit', 'resturant-table-delete'])
var coloumn_data = ['table_id', 'table_name', 'table_seating_count', 'table_format', 'table_id',
    'table_id'
];
@endcanany
var coloumn_array = [];
for (let i = 0; i < coloumn_data.length; i++) {
    coloumn_array.push({
        "data": "" + coloumn_data[i] + "",
        "name": "" + coloumn_data[i] + ""
    });
}
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": true,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [3, 4],
            @canany(['resturant-table-edit', 'resturant-table-delete'])
            "targets": [3, 4, 5],
            @endcanany "orderable": false
        },
        {
            "className": "text-center",
            "targets": [0, 2, 3, 4]
        },
        {
            "className": "text-left",
            "targets": [1]
        }

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('table_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": false,
    "columns": coloumn_array,

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";
        if (aData.table_active_status == 0) {
            var checked = "checked";
            var status = 1;
            var active_class_name = "bg-primary";
        } else {
            var checked = "";
            var status = 0;
            var active_class_name = "";
        }
        //Edit Action
        @can('resturant-table-edit')
        var action = action + '&nbsp;<button onclick=edit(' + aData.table_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('resturant-table-delete')
        var action = action + '&nbsp;<button onclick="delete_modal(' + aData.table_id +
            ')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan
        var active_status = '<label class="switch"><input type="checkbox" onchange="change_status(' + aData
            .table_id + ',' + status + ')" ' + checked + '><span class="slider ' + active_class_name +
            '"></span></label>';
        if (aData.table_format == 0 || aData.table_format == null) {
            aData.table_format = "Not Available";
        }
        $('td:eq(0)', nRow).html(index);
        $('td:eq(3)', nRow).html(aData.table_format);
        $('td:eq(4)', nRow).html(active_status);
        @canany(['resturant-table-edit', 'resturant-table-delete'])
        $('td:eq(5)', nRow).html(action).addClass('text-center');
        @endcanany
    }
});

//####################Status  Change Section#################### 
function change_status(id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id,
            'status': status
        },
        url: "{{route('change_table_status')}}",
        success: function(result) {
            toast(result, 'table_datatable');
        }
    })
}
// #################### End Status  Change Section##############
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_table')}}",
        success: function(result) {
            $('#res_table_name').val(result.data.table_name);
            $('#seating_count').val(result.data.table_seating_count);
            $('#table_format').val(result.data.table_format);
            $('#res_table_id').val(result.data.table_id);
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();

        }
    })
}
// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#res_table_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#res_table_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_res_table')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, 'table_datatable');
        }
    })
}
// #################### End Of Delete Section ##################
</script>
@endsection