@php

$company_details=$data['company_details'];
$company_name=$company_details->website_name;
$heading=$data['heading'];
$filter_range=$data['filter_range'];
$report_data=$data['data'];
$currency=session('layout_data')->currency;


@endphp

<style>
* {
    box-sizing: border-box;
}

body {
    background-color: #fafafa;
}

.report-container {
    font-family: "Open Sans";
    margin-top: 25px;
    max-width: 1240px;
    margin: 25px auto 25px auto;
    background-color: #fff;
    min-height: 20px;
    border: 1px solid #eaeaea;
    font-size: 0.9rem;
}

.report-controls {
    display: flex;
    flex: 1 1 auto;
    background-color: #f1f6fb;
    padding: 0px;
    width: 100%;
    border-bottom: 1px solid #e4e4e4;
}

.controls-left {
    margin-right: auto;
}

.controls-right {
    margin-left: auto;
}

.report-controls .report-dropdown {
    display: inline-block;
}

.report-controls button.report-button {
    padding: 10px;
    background-color: transparent;
    border: none;
    color: #666;
}

.report-controls button.report-button:hover,
.report-controls button.report-button:focus {
    background-color: rgba(0, 0, 170, 0.05);
}

.report-dropdown {
    position: relative;
}

.report-dropdown .report-dropdown-menu {
    display: none;
    position: absolute;
    z-index: 1;
    position: absolute;
    background-color: #f9f9f9;
    min-width: 160px;
    box-shadow: 0px 2px 10px 0px rgba(0, 0, 0, 0.1);
    border: 1px solid #e4e4e4;
    border-radius: 4px;
    border-bottom-left-radius: 8px;
    border-bottom-right-radius: 8px;
    overflow: hidden;
}

.report-controls .controls-right .report-dropdown .report-dropdown-menu {
    right: 0;
}

.report-dropdown .report-dropdown-menu .report-dropdown-item {
    display: block;
    text-decoration: none;
    padding: 6px 12px;
    color: #444;
    font-size: 0.9em;
}

.report-dropdown .report-dropdown-menu .report-dropdown-item:first-child {
    padding-top: 8px;
}

.report-dropdown .report-dropdown-menu .report-dropdown-item:last-child {
    padding-bottom: 8px;
}

.report-dropdown .report-dropdown-menu .report-dropdown-item:hover,
.report-dropdown .report-dropdown-menu .report-dropdown-item:focus {
    background-color: #d0e2f4;
}

.report-dropdown:hover .report-dropdown-menu,
.report-dropdown:focus .report-dropdown-menu {
    display: block;
}

.report-container .color-red {
    color: red;
}

.report-container .color-green {
    color: green;
}

.report-container .color-blue {
    color: blue;
}

.report-container .color-orange {
    color: orange;
}

.report-container .f-right {
    float: right;
}

.report-header {
    color: #555;
}

.report-title {
    text-align: center;
    font-weight: 300;
    margin-bottom: 30px;
}

.report-name {
    text-align: center;
    text-transform: uppercase;
    font-size: 1.1em;
    color: #555;
    letter-spacing: 1px;
}

.report-name small {
    font-size: .9em;
    font-weight: 400;
    display: block;
    margin-top: 15px;
    text-transform: none;
}

.report-body {
    padding: 10px 15px;
    ;
}

.report-body table {
    width: 100%;
    table-layout: fixed;
    border-collapse: collapse;
}

.report-body table thead th {
    font-weight: bold;
    border-top: 1px solid #444;
    border-bottom: 1px solid #444;
    padding: 6px 10px;
    border-right: 1px dotted #bbb;
}

.report-body table thead th:last-child {
    border-right: none;
}

.report-body table tbody tr td {
    font-size: .9em;
    padding: 8px 6px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.report-body table tbody tr.tr-primary td {
    padding-bottom: 10px;
}

.report-body table tbody tr.tr-primary td:hover {
    background-color: rgba(0, 0, 0, 0.05)
}

.report-body table tbody tr.tr-primary.open+.tr-secondary,
.report-body table tbody tr.tr-primary.open+.tr-secondary+.tr-total {
    display: table-row;
}

.report-body table tbody tr.tr-primary.open .report-collapse-trigger i {
    transform: rotate(45deg);
}

.report-body table tbody tr.tr-secondary,
.report-body table tbody tr.tr-total {
    display: none;
}

.report-body table tbody tr.tr-secondary td {
    border-bottom: 1px solid #ddd;
}

.report-body table tbody tr.tr-secondary td:first-child {
    padding-left: 30px;
}

.report-collapse-trigger {
    padding: 0px;
    cursor: pointer;
    margin-right: .25rem;
    background: none;
    border: none;
    text-decoration: none;
    color: #999;

}

.report-collapse-trigger i {
    transition: all .3s ease;
    transform: rotate(0deg);
}

.report-collapse-trigger:hover,
.report-collapse-trigger:focus {
    color: blue;
}


.report-body table tbody tr.tr-total {
    font-weight: bold;
    color: #444;
}

.report-body table tbody tr.tr-total td {
    padding-bottom: 14px;
}

.report-body table tfoot th {
    padding: 8px 6px;
    border-top: 1px solid #999;
    border-bottom: 2px solid #555;
}

.text-left {
    text-align: left;
}


.text-right {
    text-align: right;
}

.text-center {
    text-align: center;
}

.report-timestamp {
    margin: 20px 0px 30px;
}

.table_header {
    font-size: 11px;
}
</style>
<div class="report-container">


    <div class="report-content">
        <div class="report-header">
            <h1 class="report-title">{{$company_name}}</h1>

            <h3 class="report-name">{{$heading}}
                @if($filter_range)
                <small class="report-period">{{$filter_range}}</small>
                @endif
            </h3>
        </div>

        <div class="report-body">
            <table>
                <thead>
                    <tr>
                                                        <th class="bg-transparent border-bottom-0 w-5">#</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Month</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Cash
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Card
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Cash&Card</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Total</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Cash Amt</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Card Amt</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Cash&Card Amt</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Total Amt</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i=0;     @endphp
                    @foreach($report_data as $report)
                    @php



                    $card_count=$cash_count=$card_and_cash_count=$total_invoice_count=$card_amount=$cash_amount=$card_and_cash_amount=$total_amount=0;

                    if($report['cash_count']!=null){
                       $cash_count=$report['cash_count'];
                    }
                    if($report['card_count']!=null){
                       $card_count=$report['card_count'];
                    }
                    if($report['cash_and_card_count']!=null){
                       $card_and_cash_count=$report['cash_and_card_count'];
                    }
                    if($report['total_invoice_count']!=null){
                       $total_invoice_count=$report['total_invoice_count'];
                    }
                    if($report['cash_total']!=null){
                       $cash_amount=$report['cash_total'];
                    }
                     if($report['card_total']!=null){
                       $card_amount=$report['card_total'];
                    }
                     if($report['cash_and_card_total']!=null){
                       $card_and_cash_amount=$report['cash_and_card_total'];
                    }
                     if($report['total']!=null){
                       $total_amount=$report['total'];
                    }
                                 
                  

                                    $i++;
                    @endphp
                    <tr>
                        <td class=" w-5 text-center">{{$i}}</td>
                        <td class="w-25 text-center">{{$report['month_name']}} </td>
                        <td class="text-center">{{$cash_count}}</td>
                        <td class="text-center">{{$card_count}}</td>
                        <td class="text-center">{{$card_and_cash_count}}</td>
                        <td class="text-center">{{$total_invoice_count}}</td>
                        <td style="text-align:right">{{number_format($cash_amount,2)}}</td>
                        <td style="text-align:right">{{number_format($card_amount,2)}}</td>
                        <td style="text-align:right"> {{number_format($card_and_cash_amount,2)}}</td>
                        <td style="text-align:right"> {{number_format($total_amount,2)}}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="2" class="text-left">TOTAL</th>
                        <th class="text-center">{{$report['total_cash_count']}}</th>
                        <th class="text-center">{{$report['total_card_count']}}</th>
                        <th class="text-center">{{$report['total_cash_and_card_count']}}</th>
                        <th class="text-center">{{$report['total_count']}}</th>
                        <th class="text-right">{{number_format($report['total_cash_amount'],2)}}</th>
                        <th class="text-right">{{number_format($report['total_card_amount'],2)}}</th>
                        <th class="text-right">{{number_format($report['total_cash_and_card_amount'],2)}}</th>
                        <th class="text-right">{{number_format($report['total_amount'],2)}}</th>
                    </tr>
                </tfoot>
            </table>
        </div>

        <div class="report-footer">
            <div class="report-timestamp text-center">
                {{date('D-M-Y')}}
            </div>
        </div>
    </div>
</div>