@extends('layouts.app')

@section('styles')

@endsection

@section('content')
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Most Order  Product Report</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Reports</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Order Report</a></li>
            <li class="breadcrumb-item active" aria-current="page">Most Order Product Report</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- Row -->

<input type="hidden" name="" id="order_id">
<div class="row">
    <div class="col-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title mb-0">View Most Order Product Report</h3>
            </div>
            <div class="card-body pt-4">
                <div class="grid-margin">
                    <div class="">
                        <div class="panel panel-primary">
                            <div class="tab-menu-heading border-0 p-0">
                                <div class="tabs-menu1">

                                    <ul class=" nav panel-tabs product-sale">
                                        <li style="border: none;" class="px-1">
                                            <div class="btn-list">

                                                <a title="Download Excel" href="{{route('sold_item_excel_export')}}"
                                                    style="display: inline;padding: 10px 5px 10px;"><button
                                                        type="button" class="btn btn-icon btn-success "><i
                                                            class="fa fa-file-excel-o"></i></button></a>
                                                <a title="Download PDF" href="{{route('sold_item_pdf_export')}}"
                                                    style="display: inline;padding: 10px 5px 10px;"> <button
                                                        type="button"
                                                        class="btn btn-icon  btn btn-icon  btn-danger  mx-2"><i
                                                            class="bi bi-file-earmark-pdf-fill"></i></button></a>
                                            </div>
                                        </li>

                                        <li class="px-1">

                                            <div class="input-group">
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div>
                                                @php
                                                $from_date="";
                                                if(session('from_date')){
                                                $from_date=session('from_date');
                                                }
                                                @endphp
                                                <input class="form-control fc-datepicker from_date"
                                                    placeholder="From Date" value="{{$from_date}}" type="text">
                                            </div>
                                        </li>

                                        <li class="px-1">
                                            <div class="input-group">
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div>
                                                @php
                                                $to_date="";
                                                if(session('to_date')){
                                                $to_date=session('to_date');
                                                }
                                                @endphp
                                                <input class="form-control fc-datepicker to_date" placeholder="To Date"
                                                    value="{{$to_date}}" type="text">
                                            </div>
                                        </li>


                                        <li class="px-1">
                                            <div class="input-group">
                                                <button id="reset_btn" class="btn btn-danger"><i
                                                        class="fa fa-repeat"></i></button>
                                            </div>
                                        </li>


                                    </ul>
                                </div>
                            </div>
                            <div class="panel-body tabs-menu-body border-0 pt-0">
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab5">
                                        <div class="table-responsive">
                                            <table class="table table-bordered text-nowrap border-bottom "
                                                style="width: 100% !important;" id="table_datatable">
                                                <thead class="border-top text-center">
                                                    <tr>
                                                        <th class="bg-transparent border-bottom-0 w-5">#</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Recipe Name</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Recipe Current
                                                            Price
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Order Count
                                                        </th>


                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                                <tfoot>
                                                    <tr id="footer">
                                                        <td colspan="3">
                                                            <span>Total</span>
                                                        </td>

                                                        <td colspan="1">
                                                            <span> </span>
                                                        </td>


                                                </tfoot>

                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var public_url = "{{url('/')}}/{{env('ADMIN_PANEL_ROUTE')}}";
var base_url = '{{url(' / ')}}';
var print_url = '{{url(' / ')}}/order_print';
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": false,
    "searching": true,
    "bLengthChange": false,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [],
            "orderable": false
        },
        {
            "className": "text-center",
            "targets": [0, 3]
        },
        {
            "className": "text-left",
            "targets": [1]
        },
        {
            "className": "text-end",
            "targets": []
        },

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('most_sold_item_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "recipe_name",
            "name": "recipe_name"
        },
        {
            "data": "recipe_name",
            "name": "recipe_name"
        },
        {
            "data": "recipe_price",
            "name": "recipe_price"
        },
        {
            "data": "total_item_count",
            "name": "total_item_count"
        },


    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        $('td:eq(0)', nRow).html(index);
        $('td:eq(1)', nRow).html(aData.recipe_name);

        if (aData.recipe_offer_price < aData.recipe_price) {
            aData.recipe_price = aData.recipe_offer_price;
        }

        var recipe_price = parseInt(aData.recipe_price).toFixed(2);
        $('td:eq(2)', nRow).html(recipe_price + " {{session('layout_data')->currency}}").addClass(
            'text-end');

    },
    "footerCallback": function(row, data, start, end, display) {
        var org_api = this.api(),
            data;
        var api = data;
        // Update footer
        if (end != start) {
            $('#footer').show();
            $(org_api.column(3).footer()).html(api[0].total_count).css({
                'font-weight': 'bold'
            });
            $('#footer').show();







        } else {
            $('#footer').hide();
        }

    },
});


$('.from_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "from_date": $('.from_date').val()
        },
        url: public_url + '/from_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('.to_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "to_date": $('.to_date').val()
        },
        url: public_url + '/to_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('#reset_btn').click(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token
        },
        url: public_url + '/reset_session',
        success: function(result) {
            $('.from_date').val('');
            $('.to_date').val('');
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })
});
</script>
<script src="{{asset('assets/js/tooltip&popover.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.js')}}"></script>
<!-- TIMEPICKER JS -->
<script src="{{asset('assets/plugins/time-picker/jquery.timepicker.js')}}"></script>
<script src="{{asset('assets/plugins/time-picker/toggles.min.js')}}"></script>
<!-- INTERNAL jquery transfer js-->
<script src="{{asset('assets/plugins/jQuerytransfer/jquery.transfer.js')}}"></script>
<!-- DATEPICKER JS -->
<script src="{{asset('assets/plugins/date-picker/date-picker.js')}}"></script>
<script src="{{asset('assets/plugins/date-picker/jquery-ui.js')}}"></script>
<script src="{{asset('assets/plugins/input-mask/jquery.maskedinput.js')}}"></script>
<!-- FORMELEMENTS JS -->
<script src="{{asset('assets/js/formelementadvnced.js')}}"></script>
<script src="{{asset('assets/js/form-elements.js')}}"></script>
@endsection