@extends('layouts.app')

@section('styles')

@endsection

@section('content')
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Daily Wise Order Report</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Reports</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Order Report</a></li>
            <li class="breadcrumb-item active" aria-current="page">Daily Wise Order Report</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- Row -->

<input type="hidden" name="" id="order_id">
<div class="row">
    <div class="col-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title mb-0">View Daily Wise Order Report</h3>
            </div>
            <div class="card-body pt-4">
                <div class="grid-margin">
                    <div class="">
                        <div class="panel panel-primary">
                            <div class="tab-menu-heading border-0 p-0">
                                <div class="tabs-menu1">

                                    <ul class=" nav panel-tabs product-sale">
                                        <li style="border: none;" class="px-1">
                                            <div class="btn-list">

                                                <a title="Download Excel" href="{{route('daily_report_excel_export')}}"
                                                    style="display: inline;padding: 10px 5px 10px;"><button
                                                        type="button" class="btn btn-icon btn-success "><i
                                                            class="fa fa-file-excel-o"></i></button></a>
                                                <a title="Download PDF" href="{{route('daily_report_pdf_export')}}"
                                                    style="display: inline;padding: 10px 5px 10px;"> <button
                                                        type="button"
                                                        class="btn btn-icon  btn btn-icon  btn-danger  mx-2"><i
                                                            class="bi bi-file-earmark-pdf-fill"></i></button></a>
                                            </div>
                                        </li>

                                        <li class="px-1">

                                            <div class="input-group">
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div>
                                                @php
                                                $from_date="";
                                                if(session('from_date')){
                                                $from_date=session('from_date');
                                                }
                                                @endphp
                                                <input class="form-control fc-datepicker from_date"
                                                    placeholder="From Date" value="{{$from_date}}" type="text">
                                            </div>
                                        </li>

                                        <li class="px-1">
                                            <div class="input-group">
                                                <div class="input-group-text">
                                                    <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                </div>
                                                @php
                                                $to_date="";
                                                if(session('to_date')){
                                                $to_date=session('to_date');
                                                }
                                                @endphp
                                                <input class="form-control fc-datepicker to_date" placeholder="To Date"
                                                    value="{{$to_date}}" type="text">
                                            </div>
                                        </li>


                                        <li class="px-1">
                                            <div class="input-group">
                                                <button id="reset_btn" class="btn btn-danger"><i
                                                        class="fa fa-repeat"></i></button>
                                            </div>
                                        </li>


                                    </ul>
                                </div>
                            </div>
                            <div class="panel-body tabs-menu-body border-0 pt-0">
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab5">
                                        <div class="table-responsive">
                                            <table class="table table-bordered text-nowrap border-bottom "
                                                style="width: 100% !important;" id="table_datatable">
                                                <thead class="border-top text-center">
                                                    <tr>
                                                        <th class="bg-transparent border-bottom-0 w-5">#</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Date</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Approved Order
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Cancelled Order
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Total Order</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Approved Amt</th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Cancelled Amt
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0 w-5">Total Amt</th>

                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                                <tfoot>
                                                    <tr id="footer">
                                                        <td colspan="2">
                                                            <span>Total</span>
                                                        </td>

                                                        <td colspan="1">
                                                            <span> </span>
                                                        </td>

                                                        <td colspan="1">
                                                            <span> </span>
                                                        </td>
                                                        <td colspan="1">
                                                            <span> </span>
                                                        </td>
                                                        <td colspan="1">
                                                            <span> </span>
                                                        </td>
                                                        <td colspan="1">
                                                            <span> </span>
                                                        </td>
                                                        <td colspan="1">
                                                            <span> </span>
                                                        </td>

                                                </tfoot>

                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var public_url = "{{url('/')}}/{{env('ADMIN_PANEL_ROUTE')}}";
var base_url = '{{url(' / ')}}';
var print_url = '{{url(' / ')}}/order_print';
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": false,
    "searching": false,
    "bLengthChange": false,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [0, 2],
            "orderable": true
        },
        {
            "className": "text-center",
            "targets": [0, 1, 2, 3, 4]
        },
        {
            "className": "text-left",
            "targets": []
        },
        {
            "className": "text-end",
            "targets": [5, 6, 7]
        },

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('daily_wise_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "order_date",
            "name": "order_date"
        },
        {
            "data": "order_date",
            "name": "order_date"
        },
        {
            "data": "approved_count",
            "name": "approved_count"
        },
        {
            "data": "cancelled_count",
            "name": "cancelled_count"
        },
        {
            "data": "total_order_count",
            "name": "total_order_count"
        },
        {
            "data": "approved_sum",
            "name": "approved_sum"
        },
        {
            "data": "cancelled_sum",
            "name": "cancelled_sum"
        },
        {
            "data": "grand_total",
            "name": "grand_total"
        },

    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        $('td:eq(0)', nRow).html(index);
        $('td:eq(1)', nRow).html(aData.form_date).css('text-align', 'right');
        // $('td:eq(2)', nRow).html(aData.approved_count);
        // $('td:eq(2)', nRow).html(aData.cancelled_count);
        // $('td:eq(2)', nRow).html(aData.total_order_count);
        // $('td:eq(2)', nRow).html(aData.approved_sum);
        if (aData.grand_total == "" || aData.grand_total == null) {
            aData.grand_total = 0;
        }
        var grand_total = parseInt(aData.grand_total).toFixed(2);
        if (aData.cancelled_sum == "" || aData.cancelled_sum == null) {
            aData.cancelled_sum = 0;
        }
        var cancelled_cum = parseInt(aData.cancelled_sum).toFixed(2);
        if (aData.approved_sum == "" || aData.approved_sum == null) {
            aData.approved_sum = 0;
        }
        var approved_sum = parseInt(aData.approved_sum).toFixed(2);







        $('td:eq(5)', nRow).html(approved_sum);
        $('td:eq(6)', nRow).html(cancelled_cum);
        $('td:eq(7)', nRow).html(grand_total);

    },
    "footerCallback": function(row, data, start, end, display) {
        var org_api = this.api(),
            data;
        var api = data;
        // Update footer
        if (end != start) {
            $('#footer').show();
            $(org_api.column(2).footer()).html(api[0].total_approved_order).css({
                'font-weight': 'bold'
            });
            $('#footer').show();
            $(org_api.column(3).footer()).html(api[0].total_cancelled_order).css({
                'font-weight': 'bold'
            });
            $('#footer').show();
            $(org_api.column(4).footer()).html(api[0].total_order).css({
                'font-weight': 'bold'
            });
            $('#footer').show();
            $(org_api.column(5).footer()).html(parseInt(api[0].total_approved_amount).toFixed(2)).css({
                'font-weight': 'bold'
            });
            $('#footer').show();
            $(org_api.column(6).footer()).html(parseInt(api[0].total_cancelled_amount).toFixed(2)).css({
                'font-weight': 'bold'
            });
            $('#footer').show();
            $(org_api.column(7).footer()).html(parseInt(api[0].total_order_amount).toFixed(2)).css({
                'font-weight': 'bold'
            });






        } else {
            $('#footer').hide();
        }

    },
});


$('.from_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "from_date": $('.from_date').val()
        },
        url: public_url + '/from_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('.to_date').change(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "to_date": $('.to_date').val()
        },
        url: public_url + '/to_date_filter',
        success: function(result) {
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })

})

$('#reset_btn').click(function() {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token
        },
        url: public_url + '/reset_session',
        success: function(result) {
            $('.from_date').val('');
            $('.to_date').val('');
            $("#table_datatable").DataTable().ajax.reload(null, false);
        }
    })
});
</script>
<script src="{{asset('assets/js/tooltip&popover.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.js')}}"></script>
<!-- TIMEPICKER JS -->
<script src="{{asset('assets/plugins/time-picker/jquery.timepicker.js')}}"></script>
<script src="{{asset('assets/plugins/time-picker/toggles.min.js')}}"></script>
<!-- INTERNAL jquery transfer js-->
<script src="{{asset('assets/plugins/jQuerytransfer/jquery.transfer.js')}}"></script>
<!-- DATEPICKER JS -->
<script src="{{asset('assets/plugins/date-picker/date-picker.js')}}"></script>
<script src="{{asset('assets/plugins/date-picker/jquery-ui.js')}}"></script>
<script src="{{asset('assets/plugins/input-mask/jquery.maskedinput.js')}}"></script>
<!-- FORMELEMENTS JS -->
<script src="{{asset('assets/js/formelementadvnced.js')}}"></script>
<script src="{{asset('assets/js/form-elements.js')}}"></script>
@endsection