@extends('layouts.app')

@section('styles')


@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Recipe Adds On</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Recipies</a></li>
            <li class="breadcrumb-item active" aria-current="page">Recipe Adds On</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['adds_on-create','adds_on-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Recipe Adds On</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="add_on_id" name="add_on_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">
                        @foreach($available_languages as $available_language)
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Add On Name
                                {{$available_language['language_short_code']}} *</label>
                            <input
                                data-parsley-required-message="Recipe Add on {{$available_language['language_name']}} Required"
                                type="text" class="form-control"
                                name="adds_on_name_{{$available_language['language_id']}}"
                                id="adds_on_name_{{$available_language['language_id']}}" value="" required>

                        </div>
                        @endforeach

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Add On Price *</label>
                            <input data-parsley-required-message="Recipe Add on Price Required" type="text"
                                class="form-control" name="adds_on_price" id="adds_on_price" value="" required>

                        </div>


                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Adds On Image ({{env('ADDSONIMAGESIZE')}}px) *</label>
                            <input type="file" data-parsley-required-message="Add On Image Requied" required
                                class="form-control custom-input-file" name="image" id="image" value="">
                        </div>




                    </div>

                    @can('adds_on-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('add_add_on_recipe', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('adds_on-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('update_add_on_recipe', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan

                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->

<!-- Row -->
@can('adds_on-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Adds On</h3>

            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom dataTable no-footer "
                        style="width: 100% !important;" id="table_datatable">
                        <thead class="text-center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0">Name</th>
                                <th class="wd-15p border-bottom-0">Price</th>
                                <th class="wd-15p border-bottom-0">Icon</th>
                                <th class="wd-15p border-bottom-0">Status</th>
                                <th class="wd-15p border-bottom-0">Added By</th>
                                <th class="wd-10p border-bottom-0">Actions</th>
                            </tr>
                        </thead>

                    </table>

                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->



<!-- ####################################delete Modal ########################### -->
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete the Add On ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>
<!-- ################################ delete Modal################################## -->


<!-- {{-- #########################View Modal################################### --}} -->
<div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder" id="view_modal_title"></h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body" id="view_modal_body">

            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- {{-- #########################End Of View Modal############################ --}} -->



@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
{{-- <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script> --}}
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>

<script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>

{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": true,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [0, 4],
            "orderable": true
        },
        {
            "className": "text-center",
            "targets": [0, 3, 4, 5, 6]
        },
        {
            "className": "text-left",
            "targets": []
        }, {
            "className": "text-end",
            "targets": [2]
        }

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('add_on_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "add_on_id",
            "name": "add_on_id"
        },
        {
            "data": "add_on_name",
            "name": "add_on_name"
        },
        {
            "data": "add_on_price",
            "name": "add_on_price"
        },
        {
            "data": "created_at",
            "name": "created_at"
        },
        {
            "data": "add_on_active_status",
            "name": "add_on_active_status"
        },
        {
            "data": "name",
            "name": "name"
        },
        {
            "data": "add_on_id",
            "name": "add_on_id"
        },
    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";

        if (aData.add_on_active_status == 0) {
            var checked = "checked";
            var status = 1;
            var active_class_name = "bg-primary";
        } else {
            var checked = "";
            var status = 0;
            var active_class_name = "";
        }

        if (aData.add_on_image == "" || aData.add_on_image == null) {
            aData.add_on_image = "no_image.png";
        }
        var image = '<a href="/uploads/add_on_images/' + aData.add_on_image +
            '" target="_blank"><img style="width:30px; height:30px" src="/uploads/add_on_images/' + aData
            .add_on_image + '"></a>';
        //Edit Action
        var action = action + '&nbsp;<button title="Edit"  onclick=View(' + aData.add_on_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-success"><span class="fe fe-eye"> </span></button>';
        @can('adds_on-edit')
        var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.add_on_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('adds_on-delete')
        var action = action + '&nbsp;<button title="Delete" onclick="delete_modal(' + aData.add_on_id +
            ')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan

        var active_status = '<label class="switch"><input type="checkbox" onchange="change_status(' + aData
            .add_on_id + ',' + status + ')" ' + checked + '><span class="slider ' + active_class_name +
            '"></span></label>';


        var add_on_price = aData.add_on_price;

        $('td:eq(0)', nRow).html(index);
        $('td:eq(2)', nRow).html(add_on_price.toFixed(2));
        $('td:eq(3)', nRow).html(image);
        $('td:eq(4)', nRow).html(active_status);
        $('td:eq(6)', nRow).html(action);
    }
});

// #################### View Section ############################
function View(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('view_add_on')}}",
        success: function(result) {
            $('#view_modal_title').text('Add On Details');
            $('#view_modal_body').html(result);
            $('#scrollingmodal').modal('show');
        }
    })
}

//#######################End Of View Section ##################
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_add_on')}}",
        success: function(result) {
            $('#add_on_id').val(result.add_on_id);
            // #################Add On  Name Section########
            var multi_languae = JSON.parse(result.add_on_multi_name);
            $.each(multi_languae, function(index, value) {
                $('#adds_on_name_' + index).val(value);
            });
            // ######################End Of  Name Section############
            $('#adds_on_price').val(result.add_on_price);
            $('#image').removeAttr('required');
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();

        }
    })
}




// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#add_on_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#add_on_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_add_on')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, datatable_name);
        }
    })
}
// #################### End Of Delete Section ##################

//####################Status  Change Section#################### 
function change_status(id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id,
            'status': status
        },
        url: "{{route('change_add_on__status')}}",
        success: function(result) {
            toast(result, 'table_datatable');
        }
    })
}
// #################### End Status  Change Section##############
</script>


@endsection