@php
$color=['table-custom','table-primary','table-secondary','table-success','table-danger','table-warning','table-info','table-light','table-primary','table-secondary','table-success','table-danger','table-warning','table-info','table-light','table-primary','table-secondary','table-success','table-danger','table-warning','table-info','table-light','table-primary','table-secondary','table-success','table-danger','table-warning','table-info','table-light','table-primary','table-secondary','table-success','table-danger','table-warning','table-info','table-light'];
@endphp

<table class="table border  text-md-nowrap mb-0">

    <tbody>
        <!-- ############### Multi Language Desction ############# -->
        @foreach($multi_recipe_name_array as $recipe_name)
        <tr class="{{$color[0]}} table-border">
            <td class="w-30">{{$recipe_name['language_label']}}</td>
            <td class="w-10">:</td>
            <td class="w-60">{{$recipe_name['language_value']}}</td>
        </tr>
        @endforeach
        <!-- ###############End of  Multi Language Desction ############# -->
        <tr class="{{$color[0]}} table-border">
            <td>Category</td>
            <td>:</td>
            <td>{{$recipe->category_name}}</td>
        </tr>

        @if($recipe->subcategory_name)
        <tr class="{{$color[0]}} table-border">
            <td>Subcategory</td>
            <td>:</td>
            <td>{{$recipe->subcategory_name}}</td>
        </tr>
        @endif

        <tr class="{{$color[0]}} table-border">
            <td>Recipe Type</td>
            <td>:</td>
            <td>
                @if ($recipe->recipe_veg_or_non==1)
                <img style="width:30px; height:40px" src="/assets/images/custom/veg-icon.png">

                @else
                <img style="width:30px; height:40px" src="/assets/images/custom/non-veg-icon.png">
                @endif
            </td>
        </tr>

        <tr class="{{$color[0]}} table-border">
            <td>Price</td>
            <td>:</td>
            <td>{{number_format((float)$recipe->recipe_price, 2, '.', '')}} {{session('layout_data')->currency}}</td>
        </tr>
        @if($recipe->recipe_offer_price!="" && $recipe->recipe_offer_price >0)
        <tr class="{{$color[0]}} table-border">
            <td>Offer price</td>
            <td>:</td>
            <td>{{number_format((float)$recipe->recipe_offer_price, 2, '.', '')}} {{session('layout_data')->currency}}
            </td>
        </tr>
        @endif


        <tr class="{{$color[0]}} table-border">
            <td>Category</td>
            <td>:</td>
            <td>{{$recipe->category_name}}</td>
        </tr>

        @if($recipe->subcategory_name)
        <tr class="{{$color[0]}} table-border">
            <td>Subcategory</td>
            <td>:</td>
            <td>{{$recipe->subcategory_name}}</td>
        </tr>
        @endif

        <!-- ############### Multi Language Desction ############# -->
        @foreach($multi_recipe_description_array as $recipe_description)
        <tr class="{{$color[0]}} table-border">
            <td>{{$recipe_description['language_label']}}</td>
            <td>:</td>
            <td>{{$recipe_description['language_value']}}</td>
        </tr>
        @endforeach
        <!-- ###############End Fo  Multi Language Desction ############# -->

        @if($recipe->recipe_recommended_status==1)
        @php
        $recoment_checked="Checked";
        @endphp
        @else
        @php
        $recoment_checked="";
        @endphp
        @endif

        @if($recipe->recipe_preparation_time)
        <tr class="{{$color[0]}} table-border">
            <td>Preparation Time</td>
            <td>:</td>
            <td>{{$recipe->recipe_preparation_time}} Minutes</td>
        </tr>
        @endif

        <tr class="{{$color[0]}} table-border">
            <td>Stock Reminder</td>
            <td>:</td>
            <td>{{$recipe->recipe_stock_reminder}} </td>
        </tr>

        <tr class="{{$color[0]}} table-border">
            <td>Stock</td>
            <td>:</td>
            <td>{{$recipe->recipe_stock}} </td>
        </tr>

        <tr class="{{$color[0]}} table-border">
            <td colspan="3" class=""><label class="custom-control custom-checkbox-md">
                    <input type="checkbox" class="custom-control-input" id="recommend_check_nox"
                        onclick="change_recommeded_status({{$recipe->recipe_id}})" name="example-checkbox5"
                        value="option5" {{$recoment_checked}}><span class="custom-control-label">&nbsp;&nbsp;Is It Most
                        recommended ?</span></label></td>

        </tr>
        <tr>
            <td colspan="3" class="text-center">
                <h6 class=" fw-bold">Images </h6>
            </td>
        </tr>
        <tr class="{{$color[0]}} table-border">
            <td colspan="3">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-sm-6 ">
                        <div class="brick">
                            <a href="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_image}}" target="_blank"
                                class="js-img-viewer" data-caption="IMAGE-01" data-id="lion" data-group="nogroup"
                                data-index="0">
                                <img src="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_image}}" alt="">
                            </a>
                        </div>
                    </div>
                    @if($recipe->recipe_sub_image_1)
                    <div class="col-xl-3 col-lg-4 col-sm-6 ">
                        <div class="brick">
                            <a href="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_1}}" target="_blank"
                                class="js-img-viewer" data-caption="IMAGE-01" data-id="lion" data-group="nogroup"
                                data-index="0">
                                <img src="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_1}}" alt="">
                            </a>
                        </div>
                    </div>
                    @endif


                    @if($recipe->recipe_sub_image_2)
                    <div class="col-xl-3 col-lg-4 col-sm-6 ">
                        <div class="brick">
                            <a href="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_2}}" target="_blank"
                                class="js-img-viewer" data-caption="IMAGE-01" data-id="lion" data-group="nogroup"
                                data-index="0">
                                <img src="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_2}}" alt="">
                            </a>
                        </div>
                    </div>
                    @endif

                    @if($recipe->recipe_sub_image_3)
                    <div class="col-xl-3 col-lg-4 col-sm-6 ">
                        <div class="brick">
                            <a href="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_3}}" target="_blank"
                                class="js-img-viewer" data-caption="IMAGE-01" data-id="lion" data-group="nogroup"
                                data-index="0">
                                <img src="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_3}}" alt="">
                            </a>
                        </div>
                    </div>
                    @endif

                    @if($recipe->recipe_sub_image_4)
                    <div class="col-xl-3 col-lg-4 col-sm-6 mt-3 ">
                        <div class="brick">
                            <a href="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_4}}" target="_blank"
                                class="js-img-viewer" data-caption="IMAGE-01" data-id="lion" data-group="nogroup"
                                data-index="0">
                                <img src="{{url('/')}}/uploads/recipe_images/{{$recipe->recipe_sub_image_4}}" alt="">
                            </a>
                        </div>
                    </div>
                    @endif




                </div>
            </td>
        </tr>
        @if($recipe->recipe_video)
        <tr>
            <td colspan="3" class="text-center">
                <h6 class=" fw-bold">Video </h6>
            </td>
        </tr>

        <tr class="{{$color[0]}} table-border">
            <td colspan="3">
                <div class="row">
                    <div class="col-xl-12 col-lg-12 col-sm-12 ">
                        <div class="brick text-center">
                            <video width="400" controls>
                                <source src="{{url('/')}}/uploads/recipe_videos/{{$recipe->recipe_video}}"
                                    type="video/mp4">
                                Your browser does not support HTML video.
                            </video>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
        @endif





        @php

        $variant_array=$recipe->recipe_varient;
        $j=1;
        @endphp
        @if(count($variant_array)>0)
        <tr>
            <td colspan="3" class="text-center  ">
                <h6 class=" fw-bold">Recipe Variants </h6>
            </td>
        </tr>
        <tr class="{{$color[0]}} table-border">
            <td colspan="3" class=" ">
                <table class="table border table-bordered bg-info-gradient  text-md-nowrap mb-0">
                    <thead>
                        <tr>
                            <th class="text-center w-5">#</th>
                            <th class="text-center w-75">Variant Name</th>
                            <th class="text-center w-20">Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($variant_array as $key =>$varient)
                        @php
                        $variant_type=$varient['varient_name'];
                        $variant_price=$varient['varient_price'];
                        @endphp
                        <tr>
                            <td class="text-center">{{$j}}</td>
                            <td class="text-left"> {{$variant_type}}</td>
                            <td class="text-end">{{number_format($variant_price,2)}}
                                {{session('layout_data')->currency}}
                            </td>
                        </tr>
                        @php $j++; @endphp
                        @endforeach
                    </tbody>
                </table>
            </td>
        </tr>
        @endif



        @php
        $properties=$recipe->recipe_properties;
        $properties=json_decode($properties,true);
        @endphp
        @if(!empty($properties))
        <tr class="{{$color[0]}} table-border">
            <td colspan="3" class="text-center ">
                <h6 class=" fw-bold">Recipe Properties </h6>
            </td>
        </tr>

        <tr class="{{$color[0]}} table-border">
            <td colspan="3" class=" ">
                <table class="table border table-bordered bg-danger-gradient text-md-nowrap mb-0">
                    <thead>
                        <tr>
                            <th class="text-center w-5">#</th>
                            <th class="text-center w-95">Property Name </th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $k=1; @endphp
                        @foreach($properties as $property)
                        <tr>
                            <td>{{$k}}</td>
                            <td>{{$property}}</td>
                        </tr>
                        @php $k++; @endphp
                        @endforeach
                    </tbody>
                </table>
            </td>
        </tr>


        @endif





        @if(count($add_ons)>0)


        <tr>
            <td colspan="3" class="text-center">
                <h6 class=" fw-bold">Adds On Items </h6>
            </td>
        </tr>



        <tr class="{{$color[0]}} table-border">
            <td colspan="3">

                <table class="table border table-bordered bg-warning-gradient text-md-nowrap mb-0">
                    <thead>
                        <tr>
                            <th class="text-center">#</th>
                            <th class="text-center">Name</th>
                            <th class="text-center">Image</th>
                            <th class="text-end">Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $j=1; @endphp
                        @foreach($add_ons as $add_on)
                        <tr>
                            <td class="text-center">{{$j}}</td>
                            <td class="text-center">{{$add_on['add_on_name']}}</td>
                            <td class="text-center">
                                <span class="avatar avatar-xxl cover-image"
                                    data-bs-image-src="/uploads/add_on_images/{{$add_on['add_on_image']}}"
                                    style="background: url(&quot;/uploads/add_on_images/{{$add_on['add_on_image']}}&quot;) center center;"></span>

                            </td>
                            <td class="text-end">
                                {{number_format($add_on['add_on_price'],2)}} {{session('layout_data')->currency}}</td>


                        </tr>
                        @php $j++; @endphp
                        @endforeach
                    </tbody>
                </table>
            </td>
        </tr>
        @endif



</table>