@extends('layouts.app')

@section('styles')
<link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />

@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Promotions</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Manage</a></li>
            <li class="breadcrumb-item active" aria-current="page">Promotions</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['promotion-create','promotion-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Promotion</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="promotion_id" name="promotion_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Promotion Name *</label>
                            <input data-parsley-required-message="Promotion Name Required" type="text"
                                class="form-control" name="promotion_name" id="promotion_name" value="" required>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Promotion Desc</label>
                            <input type="text" class="form-control" name="promotion_desc" id="promotion_desc" value="">
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Discount Type *</label>
                            <select data-parsley-required-message="Promotion Discount type  Required"
                                class="form-control" name="discount_type" id="discount_type" required>
                                <option value="">--Choose Discount Type--</option>
                                <option value="0">Amount</option>
                                <option value="1">Discount</option>
                            </select>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02" id="amout_discount_label">Enter Amount/Discount *</label>
                            <input type="text" data-parsley-required-message="Amount/Discount  Required"
                                class="form-control" name="amount_discount" id="amount_discount" value="" required>
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">From Date *</label>
                            <input type="date" data-parsley-required-message="From date Required" class="form-control"
                                name="from_date" id="from_date" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">To Date *</label>
                            <input type="date" data-parsley-required-message="To date Required" class="form-control"
                                name="to_date" id="to_date" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Promotion Customers * </label>
                            <select class="multi-select" multiple="multiple" name="promotion_customers[]"
                                id="promotion_customers">
                                @foreach ($customers as $customer)
                                <option value="{{$customer->customer_id}}">{{$customer->customer_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Promotion Recipes * </label>
                            <select class="multi-select" multiple="multiple" name="promotion_recipes[]"
                                id="promotion_recipes">
                                @foreach ($recipes as $recipe)
                                <option value="{{$recipe->recipe_id}}">{{$recipe->recipe_name}}</option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                    @can('promotion-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('{{route('add_promotion')}}', 'createForm', '', 'promotion-datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('promotion-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('{{route('update_promotion')}}', 'createForm', '', 'promotion-datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->

<!-- Row -->
@can('promotion-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Promotions</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom" id="promotion-datatable">
                        <thead style="text-align:center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0">Name</th>
                                <th class="wd-15p border-bottom-0">Amount/Discount</th>
                                <th class="wd-10p border-bottom-0">From Date</th>
                                <th class="wd-10p border-bottom-0">To Date</th>
                                <th class="wd-10p border-bottom-0">Active/Inactive</th>
                                <th class="wd-10p border-bottom-0">Action</th>
                            </tr>
                        </thead>
                    </table>
                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->

<!-- Modal -->
<div class="modal fade" id="modaldemo8">
    <div class="modal-dialog modal-dialog-centered text-center" role="document">
        <div class="modal-content modal-content-demo">
            <div class="modal-header">
                <h6 class="modal-title">Image Preview</h6><button aria-label="Close" class="btn-close"
                    data-bs-dismiss="modal"><span aria-hidden="true">&times;</span></button>
            </div>
            <div id="image_preview_modal_body" style="background-color: #efefef;" class="modal-body">
                <img src="{{url('/')}}/uploads/category_images/20220301112116.jpeg" alt="">
            </div>
            <div class="modal-footer">
                <button class="btn btn-light" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


{{-- ######################### Delete Modal#########################      --}}
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete. ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>
{{-- ####################################End Of Delete Modal###################### --}}
{{-- ###############################promodode View Modal################################## --}}
<div class="modal fade" id="scrollingmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bold">View Promocode Details</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table border t">

                    <tbody class="">
                        <tr>
                            <td>Promotion name :</td>
                            <td id="modal_promotion_name"></td>
                        </tr>

                        <tr>
                            <td>Promotion Amount/Discount : </td>
                            <td id="modal_amount_discount"></td>
                        </tr>

                        <tr>
                            <td>From date :</td>
                            <td id="modal_form_date"></td>
                        </tr>
                        <tr>
                            <td>To date :</td>
                            <td id="modal_to_date"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
{{-- ####################################End of Promocode View Modal######################### --}}



@endsection

@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css?v1')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
//  ###########################Start Datatable#################        
$('#promotion-datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": false,
    "searching": true,
    "bLengthChange": false,
    "info": false,

    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [0, 4],
            "orderable": true
        },
        {
            "className": "text-center",
            "targets": [0, 3, 4, 5, 6]
        },
        {
            "className": "text-left",
            "targets": [1]
        },
        {
            "className": "text-right",
            "targets": [2]
        }

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('promotion_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": false,
    "columns": [{
            "data": "promotion_id",
            "name": "promotion_id"
        },
        {
            "data": "promotion_name",
            "name": "promotion_name"
        },
        {
            "data": "promotion_id",
            "name": "promotion_id"
        },
        {
            "data": "from_date",
            "name": "from_date"
        },
        {
            "data": "to_date",
            "name": "to_date"
        },
        {
            "data": "promotion_id",
            "name": "promotion_id"
        },
        {
            "data": "promotion_id",
            "name": "promotion_id"
        },
    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";
        if (aData.promotion_active_status == 0) {
            var checked = "checked";
            var status = 1;
            var active_class_name = "bg-primary";
        } else {
            var checked = "";
            var status = 0;
            var active_class_name = "";
        }
        if (aData.promotion_discount_type == 1) {
            var amt_per = " %";
            var amount_or_discount = aData.promotion_discount + ' ' + amt_per
        } else {
            var amt_per = " QR";
            var amount_or_discount = aData.promotion_discount.toFixed(2) + ' ' + amt_per
        }
        //view Action 
        var action = action + '&nbsp;<button onclick=view(' + aData.promotion_id +
            ') title="view" id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-eye"> </span></button>';
        //Edit Action
        @can('promotion-edit')
        var action = action + '&nbsp;<button onclick=edit(' + aData.promotion_id +
            ') title="edit" id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('promotion-delete')
        var action = action + '&nbsp;<button onclick="delete_modal(' + aData.promotion_id +
            ')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan
        var active_status = '<label class="switch"><input type="checkbox" onchange="change_status(' + aData
            .promotion_id + ',' + status + ')" ' + checked + '><span class="slider ' + active_class_name +
            '"></span></label>';
        $('td:eq(0)', nRow).html(index).addClass('text-center');
        $('td:eq(2)', nRow).html(amount_or_discount).css('text-align', 'right');
        $('td:eq(5)', nRow).html(active_status).addClass('text-center');
        $('td:eq(6)', nRow).html(action).addClass('text-center');
    }
});

// #########################Datatable End#######################################
$('#discount_type').change(function() {
    if ($('#discount_type').val() == 1) {
        $('#amout_discount_label').text('Enter Discount Percentage');
    } else {
        $('#amout_discount_label').text('Enter Discount Amount');
    }
});

//####################Status  Change Section#################### 
function change_status(id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id,
            'status': status
        },
        url: "{{route('change_promotion_status')}}",
        success: function(result) {
            toast(result, 'promotion-datatable');
        }
    })
}
// #################### End Status  Change Section##############
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_promotion')}}",
        success: function(result) {
            $('#promotion_name').val(result.data.promotion_name);
            $('#promotion_desc').val(result.data.promotion_desc);
            $('#discount_type').val(result.data.promotion_discount_type);
            $('#amount_discount').val(result.data.promotion_discount);
            $('#from_date').val(result.data.from_date);
            $('#to_date').val(result.data.to_date);
            $('#promotion_customers').val(result.data.promotion_customers);
            $('#promotion_recipes').val(result.data.promotion_recipies);
            $('#promotion_id').val(result.data.promotion_id);
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();
            //Customer List
            var $customersselect = $('#promotion_customers')
            $(function() {
                customer_list = result.data.promotion_customers;
                var customer_array = [];
                var array = customer_list.split(",");
                $.each(array, function(index, value) {
                    var iNum = parseInt(value);
                    customer_array.push(iNum);
                });
                $customersselect.multipleSelect();
                $customersselect.multipleSelect("setSelects", customer_array);
            });
            //End Of Customer List
            //Customer List
            var $recipe = $('#promotion_recipes')
            $(function() {
                customer_list = result.data.promotion_recipies;
                var customer_array = [];
                var array = customer_list.split(",");
                $.each(array, function(index, value) {
                    var iNum = parseInt(value);
                    customer_array.push(iNum);
                });
                $recipe.multipleSelect();
                $recipe.multipleSelect("setSelects", customer_array);
            });
            //End Of Customer List
        }
    })
}
// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#promotion_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#promotion_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_promotion')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, 'promotion-datatable');
        }
    })
}
// #################### End Of Delete Section ##################
//#########################view Section#########################
function view(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_promotion')}}",
        success: function(result) {
            if (result.data.promotion_discount_type == 1) {
                var amt_per = " %";
            } else {
                var amt_per = " QR";
            }
            var amount_or_discount = result.data.promotion_discount + ' ' + amt_per;
            $('#modal_promotion_name').text(result.data.promotion_name);
            $('#modal_amount_discount').text(amount_or_discount);
            $('#modal_form_date').text(result.data.from_date);
            $('#modal_to_date').text(result.data.to_date);
            $('#scrollingmodal').modal('show');
        }
    });
}
//################### end of view section#######################
</script>
@endsection