@extends('layouts.app')

@section('styles')
<link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />

@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Promocode</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Manage</a></li>
            <li class="breadcrumb-item active" aria-current="page">Promocode</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['promocode-create','promocode-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Promocode</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="promocode_id" name="promocode_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Promocode Name *</label>
                            <input data-parsley-required-message="Promocode Name Required" type="text"
                                class="form-control" name="promocode_name" id="promocode_name" value="" required>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Promocode Shortcode *</label>
                            <input type="text" data-parsley-required-message="Promocode shortcode  Required"
                                class="form-control" name="short_code" id="short_code" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Offer Type *</label>
                            <select data-parsley-required-message="Promocode Offer type  Required" class="form-control"
                                name="offer_type" id="offer_type" required>
                                <option value="">--Choose Offer Type--</option>
                                <option value="0">Amount</option>
                                <option value="1">Discount</option>
                            </select>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02" id="amout_discount_label">Enter Amount/Discount *</label>
                            <input type="text" data-parsley-required-message="Amount/Discount  Required"
                                class="form-control" name="amount_discount" id="amount_discount" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Minimum Purchase amount *</label>
                            <input type="text" data-parsley-required-message="Minimum Purchase Amount  Required"
                                class="form-control" name="min_purchase_amt" id="min_purchase_amt" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">From Date *</label>
                            <input type="date" data-parsley-required-message="From date Required" class="form-control"
                                name="from_date" min="{{date('Y-m-d')}}" id="from_date" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">To Date *</label>
                            <input type="date" data-parsley-required-message="To date Required" class="form-control"
                                name="to_date" min="{{date('Y-m-d')}}" id="to_date" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Maximum usage Per Customer </label>
                            <input type="text" class="form-control" name="maximum_usage_per_customer"
                                id="maximum_usage_per_customer" value="1">
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Promocode Maximum usage *</label>
                            <input type="text" data-parsley-required-message="Promocode maximum usage Required"
                                class="form-control" name="maximum_usage" id="maximum_usage" value="" required>
                        </div>
                        {{-- <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip02">Category Icon (64x64px)</label>
                                                        <input type="file" data-parsley-required-message="" class="form-control custom-input-file" name="image" id="image"
                                                            value="" >
                                                    </div> --}}
                    </div>
                    @can('promocode-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('{{route('add_promocode')}}', 'createForm', '', 'promocode-datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('promocode-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('{{route('update_promocode')}}', 'createForm', '', 'promocode-datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->

<!-- Row -->
@can('promocode-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Promocodes</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom" id="promocode-datatable">
                        <thead style="text-align:center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0">Name</th>
                                <th class="wd-15p border-bottom-0">Promocode</th>
                                <th class="wd-15p border-bottom-0">Amount/Discount</th>
                                <th class="wd-10p border-bottom-0">Active/Inactive</th>
                                @canany(['promocode-edit','promocode-delete'])
                                <th class="wd-10p border-bottom-0">Action</th>
                                @endcanany
                            </tr>
                        </thead>
                    </table>
                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->

<!-- Modal -->
<div class="modal fade" id="modaldemo8">
    <div class="modal-dialog modal-dialog-centered text-center" role="document">
        <div class="modal-content modal-content-demo">
            <div class="modal-header">
                <h6 class="modal-title">Image Preview</h6><button aria-label="Close" class="btn-close"
                    data-bs-dismiss="modal"><span aria-hidden="true">&times;</span></button>
            </div>
            <div id="image_preview_modal_body" style="background-color: #efefef;" class="modal-body">
                <img src="{{url('/')}}/uploads/category_images/20220301112116.jpeg" alt="">
            </div>
            <div class="modal-footer">
                <button class="btn btn-light" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


{{-- ######################### Delete Modal#########################      --}}
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete. ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>
{{-- ####################################End Of Delete Modal###################### --}}
{{-- ###############################promodode View Modal################################## --}}
<div class="modal fade" id="scrollingmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bold">View Promocode Details</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table border t">

                    <tbody class="">
                        <tr>
                            <td>Promocode name :</td>
                            <td id="modal_promocode_name"></td>
                        </tr>
                        <tr>
                            <td>Promocode : </td>
                            <td id="modal_shortcode"></td>
                        </tr>
                        <tr>
                            <td>Amount/Discount : </td>
                            <td id="modal_amount_discount"></td>
                        </tr>
                        <tr>
                            <td>Min Purchase Amt : </td>
                            <td id="modal_min_pur_amt"></td>
                        </tr>
                        <tr>
                            <td>From date :</td>
                            <td id="modal_form_date"></td>
                        </tr>
                        <tr>
                            <td>To date :</td>
                            <td id="modal_to_date"></td>
                        </tr>
                        <tr>
                            <td>Max Usage Per Customer :</td>
                            <td id="modal_max_usage_per_cus"></td>
                        </tr>
                        <tr>
                            <td>Promocode Max Usage:</td>
                            <td id="modal_max_usage"></td>
                        </tr>
                        <tr>
                            <td>Promocode Current Usage</td>
                            <td id="modal_current_usage"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
{{-- ####################################End of Promocode View Modal######################### --}}



@endsection

@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css?v1')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
//  ###########################Start Datatable#################        
var coloumn_data = ['promocode_id', 'promocode_id', 'promocode_id', 'promocode_id', 'promocode_id'];
@canany(['promocode-edit', 'promocode-delete'])
var coloumn_data = ['promocode_id', 'promocode_id', 'promocode_id', 'promocode_id', 'promocode_id', 'promocode_id'];
@endcanany
var coloumn_array = [];
for (let i = 0; i < coloumn_data.length; i++) {
    coloumn_array.push({
        "data": "" + coloumn_data[i] + "",
        "name": "" + coloumn_data[i] + ""
    });
}
$('#promocode-datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": false,
    "searching": true,
    "bLengthChange": false,
    "info": false,

    "columnDefs": [{
            "orderable": true
        },
        {
            "className": "text-center"
        }
    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('promocode_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": false,
    "columns": coloumn_array,

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";
        if (aData.promocode_active_status == 0) {
            var checked = "checked";
            var status = 1;
            var active_class_name = "bg-primary";
        } else {
            var checked = "";
            var status = 0;
            var active_class_name = "";
        }
        if (aData.promocode_offer_type == 1) {
            var amt_per = " %";
            var amount_or_discount = aData.promocode_amount_or_discount + ' ' + amt_per
        } else {
            var amt_per = " QR";
            var amount_or_discount = aData.promocode_amount_or_discount.toFixed(2) + ' ' + amt_per
        }
        //View Action
        var action = action + '&nbsp;<button onclick=view(' + aData.promocode_id +
            ') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
        //Edit Action
        @can('promocode-edit')
        var action = action + '&nbsp;<button onclick=edit(' + aData.promocode_id +
            ') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('promocode-delete')
        var action = action + '&nbsp;<button onclick="delete_modal(' + aData.promocode_id +
            ')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan
        var active_status = '<label class="switch"><input type="checkbox" onchange="change_status(' + aData
            .promocode_id + ',' + status + ')" ' + checked + '><span class="slider ' + active_class_name +
            '"></span></label>';
        $('td:eq(0)', nRow).html(index).addClass('text-center');
        $('td:eq(1)', nRow).html(aData.promocode_name).addClass('text-left');
        $('td:eq(2)', nRow).html(aData.promocode_short_code).addClass('text-center');
        $('td:eq(3)', nRow).html(amount_or_discount).addClass('text-end');
        $('td:eq(4)', nRow).html(active_status).addClass('text-center');
        @canany(['promocode-create', 'promocode-edit'])
        $('td:eq(5)', nRow).html(action).addClass('text-center');
        @endcanany
    }
});

// #########################Datatable End#######################################
$('#offer_type').change(function() {
    if ($('#offer_type').val() == 1) {
        $('#amout_discount_label').text('Enter Discount Percentage');
    } else {
        $('#amout_discount_label').text('Enter Discount Amount');
    }
});

//####################Status  Change Section#################### 
function change_status(promocode_id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "promocode_id": promocode_id,
            'status': status
        },
        url: "{{route('change_promocode_status')}}",
        success: function(result) {
            toast(result, 'promocode-datatable');
        }
    })
}
// #################### End Status  Change Section##############
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_promocode')}}",
        success: function(result) {
            $('#promocode_name').val(result.data.promocode_name);
            $('#short_code').val(result.data.promocode_short_code);
            $('#offer_type').val(result.data.promocode_offer_type);
            $('#amount_discount').val(result.data.promocode_amount_or_discount);
            $('#min_purchase_amt').val(result.data.promocode_min_purchase_amt);
            $('#from_date').val(result.data.promocode_from_date);
            $('#to_date').val(result.data.promocode_to_date);
            $('#maximum_usage_per_customer').val(result.data.promocode_maximum_usage_per_customer);
            $('#maximum_usage').val(result.data.promocode_maximum_usage);
            $('#promocode_id').val(result.data.promocode_id);
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();

        }
    })
}
// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#promocode_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#promocode_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_promocode')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, 'promocode-datatable');
        }
    })
}
// #################### End Of Delete Section ##################
//#########################view Section#########################
function view(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_promocode')}}",
        success: function(result) {
            if (result.data.promocode_offer_type == 1) {
                var amt_per = " %";
            } else {
                var amt_per = " QR";
            }
            var amount_or_discount = result.data.promocode_amount_or_discount + ' ' + amt_per;
            $('#modal_promocode_name').text(result.data.promocode_name);
            $('#modal_shortcode').text(result.data.promocode_short_code);
            $('#modal_amount_discount').text(amount_or_discount);
            $('#modal_min_pur_amt').text(result.data.promocode_min_purchase_amt + ' QR');
            $('#modal_form_date').text(result.data.promocode_from_date);
            $('#modal_to_date').text(result.data.promocode_to_date);
            $('#modal_max_usage_per_cus').text(result.data.promocode_maximum_usage_per_customer);
            $('#modal_max_usage').text(result.data.promocode_maximum_usage);
            $('#modal_current_usage').text(result.data.promocode_usage_count);
            $('#scrollingmodal').modal('show');
        }
    });
}
//################### end of view section#######################
</script>
@endsection