@extends('layouts.app')

@section('styles')

@endsection

@section('content')
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Point Of Sale</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="dashboard">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">POS </li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->
<div class="row">



            <div class="col-xl-6 col-lg-6 col-md-6">


                 <div class="row">
                            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 p-1">


                                <div class="card mb-1">
                                
                                    <div class="card-body p-3">
                                        
                                      <div class="form-group">
                                            <div class="input-group">
                                             
                                                <input type="text" class="form-control search_term" placeholder="Search Item..." aria-label="Search Item" aria-describedby="basic-addon1">
                                                   <span class="input-group-text" id="basic-addon1"><i class="fa fa-search"></i></span>
                                            </div>
                                        </div>
                                       
                            
                                    </div>
                                </div>

                            </div>
                             </div>


                            <div class="row items_result">  

                            <button class="btn btn-primary"> Back</button>

                            @foreach($data['categories'] as $category)
                            @php 
                            $category_id=$category['category_id'];
                            $category_name=$category['category_name'];
                            $category_icon=$category['category_icon'];
                            


                            @endphp
                            <div onclick="category_wise_items('recipe',{{$category_id}})" class="col-sm-12 col-md-6 col-lg-3 col-xl-3 p-1">
                                <div class="card mb-1">
                                    <div class="card-body text-center">
                                        <img src="{{url('/uploads/category_images')}}/{{$category_icon}}" alt="">
                                        <h6 class="mt-4 mb-2">{{$category_name}}</h6>
                                       
                                        
                                    </div>
                                </div>
                            </div>
                            @endforeach

                            @if($data['add_ons']>0)
                              <div onclick="category_wise_items('add_on',0)" class="col-sm-12 col-md-6 col-lg-3 col-xl-3 p-1">
                                <div class="card mb-1">
                                    <div class="card-body text-center">
                                        <img src="{{url('/uploads/category_images')}}/{{$category_icon}}" alt="">
                                        <h6 class="mt-4 mb-2">Add Ons</h6>
                                       
                                        
                                    </div>
                                </div>
                            </div>

                            @endif
                            
                            
                
                            
                                </div>


        </div>




 
    
                    <div class="col-xl-6 col-lg-6 col-md-6 p-1 " >
                                <div class="card mb-1  ">
                               
                                    <div class="card-body p-3" style="height: 75vh;">
                                     
                                    <div class="form-group">
                                            <div class="input-group mb-3">
                                                <button type="button" class="btn btn-icon  btn-primary ms-1"><i class="fa fa-user"></i></button>
                                                <input type="text" class="form-control" id="customer_autocomplete" placeholder="Search Customer " aria-label="Amount (to the nearest dollar)">
                                               
                                               <button type="button" class="btn btn-icon  btn-primary ms-1"><i class="fa fa-user-plus"></i></button>
                                            </div>
                                             <div id="autocomplete-results"></div>
                                        </div>


                               <div class="table-responsive">
<table class="table">
                        <tbody class="item_body">
                          
                           
                           
                        </tbody>
                    </table>
      </div>


      <div class="pos-pay-summary">
                <div class="bg-light p-3">
                    <div class="d-flex justify-content-between mb-2">
                        <div class="d-flex">
                            <span class="fw-bold ">Amount: <span class="sub_org_total">0.00</span></span>
                        </div>
                        <span class="px-2 fw-bold">Qty: <span class="sub_quantity">0</span></span>
                        <span class="fw-bold " >Sub Total: <span class="sub_total">0.00</span> <input type="hidden" class="sub_total_input"> </span>
                    </div>
                    <div class="p-3 bg-white d-flex">
                        <div>
                            <label class="small">Offer Code</label>
                            <input type="text"  data-type="offer" onkeyup="grand_amount_calculation(this)" class="form-control form-control-sm offer_code">
                            <div id="" class="invalid-feedback offer_response">Please select a valid state.</div>
                            <div class="valid-feedback offer_response">Looks good!</div>
                        </div>
                        <div class="mx-2">
                            <label class="small text-danger">Dicsount %</label>
                            <input type="text"  data-type="discount" onkeyup="grand_amount_calculation(this)" class="form-control form-control-sm discount_percentage">
                        </div>
                        <div>
                            <label class="small">Discount Amount</label>
                            <input type="text"  data-type="amount" onkeyup="grand_amount_calculation(this)" class="form-control form-control-sm discount_amount">
                        </div>
                    </div>
                    <div class="d-flex justify-content-between mt-3">
                        <div>
                            <label class="small">Payment Mode</label>
                            <div class="d-flex">
                                <button class="btn btn-primary btn-sm">
                                    <i class="bi bi-cash fa-lg me-1"></i>Cash
                                </button>
                                <button class="btn btn-outline-primary btn-sm mx-2">
                                    <i class="bi bi-credit-card-2-back fa-lg me-1"></i>Card
                                </button>
                                <button class="btn btn-outline-primary btn-sm">
                                    <i class="bi bi-cash-coin fa-lg me-1"></i>Cash &amp; Card
                                </button>
                            </div>
                        </div>
                        <div class="ms-2">
                            <label class="small">Given Amount</label>
                            <input type="text" class="form-control form-control-sm given_amount" value="0">
                        </div>
                    </div>
                    <div class="mt-2 bg-white p-3 d-flex align-items-center justify-content-between">
                        <h5 class="text-muted mb-0">Balance: <b class="text-dark balance_amt">0.00</b></h5>
                        <button class="btn btn-lg btn-success fw-bold">Pay <span class="grand_amount">0.00</span> 
                        <input type="hidden" class="grand_amount_input" value="0">
                        </button>
                    </div>
                </div>    
                
            </div>
                                        
                                  
                                    </div>
                                </div>
                            </div>
   
    
</div>


<form id="myForm">
    @csrf
    <input type="text" name="customer_name" value="John">
    <input type="text" name="customer_mobile" value="John">
    <input type="email" name="customer_email" value="john@example.com">
    <!-- Other form fields go here -->
    <button type="button" id="add_customer">Submit</button>
</form>




@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}


<!-- BOOTSTRAP-DATERANGEPICKER JS -->
<script src="{{asset('assets/plugins/bootstrap-daterangepicker/moment.min.js')}}"></script>
<script src="{{asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<!-- INTERNAL Bootstrap-Datepicker js-->
<script src="{{asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.js')}}"></script>

<!-- TIMEPICKER JS -->
<script src="{{asset('assets/plugins/time-picker/jquery.timepicker.js')}}"></script>
<script src="{{asset('assets/plugins/time-picker/toggles.min.js')}}"></script>


<script src="{{asset('assets/plugins/multi/multi.min.js')}}"></script>

<!-- DATEPICKER JS -->
<script src="{{asset('assets/plugins/date-picker/date-picker.js')}}"></script>
<script src="{{asset('assets/plugins/date-picker/jquery-ui.js')}}"></script>
<script src="{{asset('assets/plugins/input-mask/jquery.maskedinput.js')}}"></script>
<script src="{{asset('assets/js/pos.js')}}"></script>

<script>
    var token = $("meta[name=csrf-token]").attr("content");
    var categories_url = "{{route('pos_categories')}}";
    var category_wise_item_url = "{{route('category_wise_item')}}";
    var recipe_wise_varient_url = "{{route('recipe_wise_varient')}}";
    var search_term_url = "{{route('search_term')}}";
    var add_customer_url= "{{route('add_customer_via_pos')}}";
    var autocomplete_url= "{{route('customer_autocomplete')}}";
    var offercode_url= "{{route('offer_code_fetching')}}";
    var currency_code= "{{session('layout_data')->currency}}";

</script>

@endsection