@extends('layouts.app')

@section('styles')

@endsection

@section('content')
@php
$qr_for_credit_to_customer_point=$one_point_qr_value=$min_purchase_amount=$points_expire_days=$point_status="";
@endphp
@if($data)
@php
$qr_for_credit_to_customer_point = $data->money_needed_for_1_point;
$one_point_qr_value= $data->one_point_value;
$min_purchase_amount= $data->min_amount_redeem_point;
$points_expire_days= $data->point_validity;
$point_status= $data->point_status;
@endphp
@endif
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Manage Points</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Manage</a></li>
            <li class="breadcrumb-item active" aria-current="page">Points</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['points-create','points-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Manage Points</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    @csrf
                    <div class="form-row">
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">How much QR needed for 1 point credit to customer</label>
                            <input data-parsley-required-message="QR for 1 point Required" type="text"
                                class="form-control" name="qr_for_credit_to_customer_point"
                                id="qr_for_credit_to_customer_point" value="{{$qr_for_credit_to_customer_point}}"
                                required>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">1 Point = How much QR</label>
                            <input type="text"
                                data-parsley-required-message="The Qr value Corresponding 1 point Required"
                                class="form-control" name="one_point_qr_value" id="one_point_qr_value"
                                value="{{$one_point_qr_value}}" required>
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Minimum purchase amount for redeem points</label>
                            <input type="text" data-parsley-required-message="Minimum Purchase Amount Required"
                                class="form-control" name="min_purchase_amount" id="min_purchase_amount"
                                value="{{$min_purchase_amount}}" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Points validity(Days)</label>
                            <input type="text" data-parsley-required-message="Points Expire Days Required"
                                class="form-control" name="points_expire_days" id="points_expire_days"
                                value="{{$points_expire_days}}" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Active/Inactive Point Section</label>
                            <select data-parsley-required-message="Points Status Required" class="form-control"
                                name="point_status" id="point_status" required>
                                <option @if ($point_status==0) selected @endif value="0">Active</option>
                                <option @if ($point_status==1) selected @endif value="1">Inactive</option>
                            </select>
                        </div>
                    </div>
                    @can('points-edit')
                    <a id="update_btn" style="" href="#"
                        onclick="createOrUpdate('{{route('update_points')}}', 'createForm', '', '','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->

@endsection

@section('scripts')


<script src="{{asset('js/category/index.js')}}"></script>


@endsection