 @php
 $company_details=$data['company_details'];
 $order_details=$data['order_details'];
 $order_items=$order_details['order_items'];
 $promocode_details=$order_details['promocode'];
 @endphp
 <div class="card-body">
     <div class="row">
         <div class="col-lg-6">
             <a class="header-brand" href="#">
                 <img class="w-10" src="/uploads/layouts/{{$company_details->admin_logo}}"
                     class="header-brand-img logo-3" alt="">
             </a>
             <div>
                 <address class="pt-3">
                     {{$company_details->website_address}}<br>
                     {{$company_details->website_email}}
                 </address>
             </div>
         </div>
         <div class="col-lg-6 text-end border-bottom border-lg-0">
             <h3>#{{$order_details->order_unique_id}}</h3>
             <h5>Date :{{$order_details->order_date}}</h5>
             <h5>Time :{{$order_details->order_time}}</h5>
         </div>
     </div>
     <div class="row pt-5">
         <div class="col-lg-6">
             <p class="h3">Order From :</p>
             <p class="fs-18 fw-semibold mb-0">{{$order_details->order_customer_name}}</p>
             <p class="mb-1 fw-semibold">{{$order_details->order_customer_mob}}</p>
             @if(isset($order_details->order_customer_mail))
             <p class="mb-1 fw-semibold">{{$order_details->order_customer_mail}}</p>
             @endif
{{--             @if(isset($order_details->customer_cart->address))--}}
{{--                 <p class="mb-1 fw-semibold">{{$order_details->customer_cart->address}}</p>--}}
{{--             @endif--}}
{{--             @if(isset($order_details->customer_cart->phone_number))--}}
{{--                 <p class="mb-1 fw-semibold">{{$order_details->customer_cart->phone_number}}</p>--}}
{{--             @endif--}}
         </div>
         @if(isset($order_details->customer_cart->address))
         <div class="col-lg-6 text-end">
             <p class="h4 fw-semibold">Address:</p>
             <p class="mb-1 fw-semibold">{{$order_details->customer_cart->address}}</p>
             <p class="mb-1 fw-semibold">{{$order_details->customer_cart->phone_number}}</p>

         </div>
         @endif
     </div>
     <div class="table-responsive push">
         <table class="table table-bordered  mb-0 text-nowrap">
             <tbody>
                 <tr class="table-primary ">
                     <th class="text-center">#</th>
                     <th>Item</th>
                     <th class="text-center">Quantity</th>
                     <th class="text-end">Unit Price</th>
                     <th class="text-end">Add On Price</th>
                     <th class="text-end">Sub Total</th>
                 </tr>
                 @php $j=1; @endphp
                 @foreach($order_items as $order_item)
                 @php
                 $order_item_add_ons=$order_item->order_item_add_on;
                 $order_item_varient=$order_item->order_item_varient;
                 $order_item_sub_total=$order_item['order_item_grand_total'];
                 $unit_price=0;
                 $add_on_price=0;
                 @endphp
                 <tr>
                     <td class="text-center">{{$j}}</td>
                     <td>
                         <p class="font-w600 mb-1">{{$order_item['order_item_name']}}</p>

                         @if(count($order_item_varient)>0)
                         <div class="expanel expanel-primary">
                             <div class="expanel-heading">Variants</div>
                             <div class="expanel-body">
                                 <table class="table border text-nowrap text-md-nowrap mb-0">
                                     <thead>
                                         <tr class="">
                                             <th>#</th>
                                             <th>Varient</th>
                                             <th>Price</th>
                                             <th>Qty</th>
                                             <th>Total</th>
                                         </tr>
                                     </thead>
                                     <tbody>
                                         @php $j=0;@endphp
                                         @foreach($order_item_varient as $varient)
                                         @php
                                         $j++;
                                         $order_item_varient_name=$varient['order_item_varient_name'];
                                         $order_item_varient_price=$varient['order_item_varient_price'];
                                         $order_item_varient_quantity=$varient['order_item_varient_quantity'];
                                         $order_item_varient_total_price=$varient['order_item_varient_total_price'];
                                         $unit_price=$unit_price+$order_item_varient_total_price;
                                         @endphp
                                         <tr>
                                             <td>{{$j}}</td>
                                             <td>{{$order_item_varient_name}}</td>
                                             <td class="text-end">{{number_format($order_item_varient_price,2)}}</td>
                                             <td class="text-center">{{$order_item_varient_quantity}}</td>
                                             <td class="text-end">{{number_format($order_item_varient_total_price,2)}}
                                             </td>
                                         </tr>
                                         @endforeach


                                     </tbody>
                                 </table>
                             </div>
                         </div>
                         @else
                         @php
                         $unit_price=$unit_price+$order_item['order_item_netamount'];

                         @endphp
                         @endif
                         @if(count($order_item_add_ons)>0)
                         <div class="expanel expanel-primary">
                             <div class="expanel-heading">Add ons</div>
                             <div class="expanel-body">
                                 <table class="table border text-md-nowrap mb-0">
                                     <thead>
                                         <tr class="">
                                             <th>#</th>
                                             <th>Add on</th>
                                             <th>Price</th>
                                             <th>Qty</th>
                                             <th>Total</th>
                                         </tr>
                                     </thead>
                                     <tbody>
                                         @php $k=0;@endphp
                                         @foreach($order_item_add_ons as $order_item_add_on)
                                         @php
                                         $add_on_name=$order_item_add_on['order_item_add_on_name'];
                                         $price=$order_item_add_on['order_item_add_on_price'];
                                         $quantity=$order_item_add_on['order_item_add_on_quantity'];
                                         $total_price=$order_item_add_on['order_item_add_on_total_price'];
                                         $add_on_price=$add_on_price+$total_price;
                                         $k++;
                                         $order_item_sub_total=$order_item_sub_total;
                                         @endphp
                                         <tr>
                                             <td>{{$k}}</td>
                                             <td>{{$add_on_name}}</td>
                                             <td class="text-end">{{number_format($price,2)}}</td>
                                             <td class="text-center">{{$quantity}}</td>
                                             <td class="text-end">{{number_format($total_price,2)}}
                                             </td>
                                         </tr>
                                         @endforeach


                                     </tbody>
                                 </table>
                             </div>
                         </div>
                         @endif

                     </td>
                     <td class="text-center">{{$order_item['order_item_quantity']}}</td>
                     <td class="text-end">{{number_format($unit_price,2)}}</td>
                     <td class="text-end">{{number_format($add_on_price,2)}}</td>
                     <td class="text-end">{{number_format($order_item_sub_total,2)}}</td>

                 </tr>
                 @php $j++; @endphp
                 @endforeach


                 <tr>
                     <td colspan="5" class="fw-bold text-uppercase text-end">Sub Total</td>
                     <td class="fw-bold text-end h5">{{number_format($order_details->order_net_amount,2)}}
                         {{session('layout_data')->currency}}</td>
                 </tr>
                 @if($order_details->order_discount_amt>0)
                 <tr class="text-danger">

                     @if($promocode_details)
                     @php
                     @endphp
                     <td colspan="5" class="fw-bold text-uppercase text-end">Promocode -
                         {{$promocode_details->promocode_name}}
                         @if($promocode_details->promocode_offer_type==0)
                         ({{$promocode_details->promocode_amount_or_discount}} {{session('layout_data')->currency}})
                         @else
                         ({{$promocode_details->promocode_amount_or_discount}} % )
                         @endif

                     </td>
                     <td class="fw-bold text-end h5">{{number_format($order_details->order_discount_amt,2)}}
                         {{session('layout_data')->currency}}</td>
                     @else
                     <td colspan="5" class="fw-bold text-uppercase text-end">Discount</td>
                     <td class="fw-bold text-end h5">{{number_format($order_details->order_discount_amt,2)}}
                         {{session('layout_data')->currency}}</td>
                     @endif
                 </tr>
                 @endif
                 <tr>
                     <td colspan="5" class="fw-bold text-uppercase text-end">Total</td>
                     <td class="fw-bold text-end h4">{{number_format($order_details->order_grand_total,2)}}
                         {{session('layout_data')->currency}}</td>
                 </tr>
             </tbody>
         </table>
     </div>
 </div>
