@extends('layouts.app')

@section('styles')

@endsection

@section('content')
    <!-- PAGE-HEADER -->
    <div class="page-header">
        <h1 class="page-title">View Orders</h1>
        <div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="dashboard">Home</a></li>
                <li class="breadcrumb-item"><a href="dashboard">Order</a></li>
                <li class="breadcrumb-item active" aria-current="page">View Orders</li>
            </ol>
        </div>
    </div>
    <!-- PAGE-HEADER END -->

    <!-- Row -->
    <div id="print_order_div" class="d-none"></div>
    <input type="hidden" name="" id="order_id">
    <div class="row">
        <div class="col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-0">View Orders</h3>
                </div>
                <div class="card-body pt-4">
                    <div class="grid-margin">
                        <div class="">
                            <div class="panel panel-primary">
                                <div class="tab-menu-heading border-0 p-0">
                                    <div class="tabs-menu1">
                                        <ul class="nav panel-tabs product-sale">
                                            <li>
                                                <button id="" style="background-color:#c6d7c6" class="btn"
                                                        onclick="change_status('Placed')"><i
                                                        class="fa fa-gear"></i>&nbsp;Placed
                                                </button>
                                                <button id="" style="background-color:#79ca79" class="btn "
                                                        onclick="change_status('Approved')"><i
                                                        class="fa fa-calendar-check-o"></i>&nbsp;Approved
                                                </button>
                                                <button id="" style="background-color:#9b8dd8" class="btn "
                                                        onclick="change_status('Preparing')"><i
                                                        class="fa fa-coffee"></i>&nbsp;Preparing
                                                </button>
                                                <button id="" style="background-color:#bc97c3" class="btn "
                                                        onclick="change_status('Pick Up')"><i
                                                        class="fa fa-gift"></i>&nbsp;Pick Up
                                                </button>
                                                <button id="" style="background-color:#adb570" class="btn "
                                                        onclick="change_status('On Transit')"><i
                                                        class="fa fa-car"></i>&nbsp;On Transit
                                                </button>
                                                <button id="" style="background-color:#70b5ad" class="btn "
                                                        onclick="change_status('Delivered')"><i
                                                        class="fa fa-home"></i>&nbsp;Delivered
                                                </button>
                                                <button id="" style="background-color:#eacecc" class="btn "
                                                        onclick="change_status('Cancelled')"><i
                                                        class="fa fa-ban"></i>&nbsp;Cancelled
                                                </button>
                                            </li>
                                        </ul>
                                        <br>
                                        <ul class="nav panel-tabs product-sale" style="margin-top: 46px;">
                                            <li class="px-2">
                                                <div class="input-group">
                                                    <label class="form-label px-2">Branch :</label>
                                                    <select class="form-control" name="branch_id" id="branch_id" onchange="change_branch()">
                                                        <option value="">All Branch</option>
                                                        @foreach($branches as $branch)
                                                            <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </li>
                                            <li class="px-2">
                                                <div class="input-group">
                                                    @php
                                                        $from_date="";
                                                        $to_date="";
                                                        if(session('order_from_date_filter')){
                                                        $date = DateTime::createFromFormat('Y-m-d',
                                                        session('order_from_date_filter'));
                                                        $from_date = $date->format('m/d/y');
                                                        }

                                                        if(session('order_to_date_filter')){
                                                        $date = DateTime::createFromFormat('Y-m-d',
                                                        session('order_to_date_filter'));
                                                        $to_date = $date->format('m/d/y');
                                                        }


                                                    @endphp
                                                    <label class="form-label px-2">From :</label>
                                                    <div class="input-group-text">
                                                        <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                    </div>
                                                    <input onchange="order_date_from_filter()"
                                                           class="form-control fc-datepicker from_date"
                                                           placeholder="MM/DD/YYYY" value="{{$from_date}}" type="text">
                                                </div>
                                            </li>
                                            <li class="px-2">
                                                <div class="input-group">
                                                    <label class="form-label px-2">To :</label>
                                                    <div class="input-group-text">
                                                        <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                    </div>
                                                    <input onchange="order_date_to_filter()"
                                                           class="form-control fc-datepicker to_date"
                                                           value="{{$to_date}}"
                                                           placeholder="MM/DD/YYYY" type="text">
                                                </div>
                                            </li>
                                            <li>
                                                <button id="reset_btn" class="btn btn-danger"><i
                                                        class="fa fa-repeat"></i></button>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="panel-body tabs-menu-body border-0 pt-0">
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="tab5">
                                            <div class="table-responsive">
                                                <table class="table table-bordered text-nowrap border-bottom "
                                                       style="width: 100% !important;" id="table_datatable"
                                                       class="table table-bordered text-nowrap mb-0">
                                                    <thead class="border-top text-center">
                                                    <tr>
                                                        <th class="bg-transparent border-bottom-0" style="width: 5%;">#
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Date
                                                        </th>

                                                        <th class="bg-transparent border-bottom-0">
                                                            time
                                                        </th>

                                                        <th class="bg-transparent border-bottom-0">
                                                            Name
                                                        </th>

                                                        <th class="bg-transparent border-bottom-0">
                                                            Address
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Mobile
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Note
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Type
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Branch
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Amount
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Status
                                                        </th>
                                                        <th class="bg-transparent border-bottom-0">
                                                            Action
                                                        </th>
                                                    </tr>
                                                    </thead>

                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <!-- {{-- #########################View Modal################################### --}} -->
    <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bolder" id="view_modal_title"></h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body" id="view_modal_body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger mb-1" onclick="print_order()"><i
                            class="si si-printer"></i> Print Order
                    </button>
                    <button class="btn btn-primary approve_btn" data-bs-dismiss="modal"
                            onclick="approve_order()">Approve
                    </button>
                    <a href="javascript:void(0)" class="btn btn-info invoice_btn"><i
                            class="fa fa-calculator"></i> Invoice</a>
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!-- {{-- #########################End Of View Modal############################ --}} -->

    <div class="modal  fade" id="smallmodal_order_tracking" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Order Tracking</h5>
                    <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body" id="order_tracking_modal_div">
                    <select onchange="change_traking_status()" id="tracking_dropdown" class="form-control">
                        <option>--Select Tracking Staus--</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button class="btn custom-btn-success tracking_status_change_btn" data-bs-dismiss="modal">Save
                        Changes
                    </button>
                    <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- ####################################delete Modal ########################### -->
    <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bolder">Cancel</h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Do you want to cancel the order ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button onclick="cancel_order()" class="btn btn-primary">Cancel Order</button>
                </div>
            </div>
        </div>
    </div>
    <!-- ################################ delete Modal################################## -->








@endsection
@section('scripts')
    {{-- ################################Jquery Datatable########################### --}}
    <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
    <script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
    {{-- ########################################################################## --}}


    <!-- BOOTSTRAP-DATERANGEPICKER JS -->
    <script src="{{asset('assets/plugins/bootstrap-daterangepicker/moment.min.js')}}"></script>
    <script src="{{asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
    <!-- INTERNAL Bootstrap-Datepicker js-->
    <script src="{{asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.js')}}"></script>

    <!-- TIMEPICKER JS -->
    <script src="{{asset('assets/plugins/time-picker/jquery.timepicker.js')}}"></script>
    <script src="{{asset('assets/plugins/time-picker/toggles.min.js')}}"></script>


    <script src="{{asset('assets/plugins/multi/multi.min.js')}}"></script>

    <!-- DATEPICKER JS -->
    <script src="{{asset('assets/plugins/date-picker/date-picker.js')}}"></script>
    <script src="{{asset('assets/plugins/date-picker/jquery-ui.js')}}"></script>
    <script src="{{asset('assets/plugins/input-mask/jquery.maskedinput.js')}}"></script>

    <!-- FORMELEMENTS JS -->
    <script src="{{asset('assets/js/formelementadvnced.js')}}"></script>
    <script src="{{asset('assets/js/form-elements.js')}}"></script>
    <script>
        var token = $("meta[name=csrf-token]").attr("content");
        var current_date = "{{date('Y-m-d')}}";
        var datatable_name = "table_datatable";
        $('#table_datatable').DataTable({
            "responsive": true,
            "serverSide": true,
            "ordering": true,
            "searching": true,
            "bLengthChange": true,
            "info": false,
            "bSort": true,
            "order": [
                [0, 'desc']
            ],
            "columnDefs": [{
                "targets": [10],
                "orderable": false
            },
                {
                    "className": "text-center",
                    "targets": [0, 1, 2]
                },
                {
                    "className": "text-left",
                    "targets": [3, 4, 5, 6, 7, 8]
                },
                {
                    "className": "text-right",
                    "targets": [9]
                },

            ],
            "displayLength": 10,
            "ajax": {
                "url": "{{route('order_datattable')}}",
                "type": "post",
                "data": function (data) {
                    data._token = token;

                    return data;

                }
            },
            "AutoWidth": true,
            "columns": [{
                "data": "order_id",
                "name": "order_id"
            },
                {
                    "data": "order_date",
                    "name": "order_date"
                },
                {
                    "data": "order_time",
                    "name": "order_time"
                },
                {
                    "data": "order_customer_name",
                    "name": "order_customer_name"
                },
                {
                    "data": "order_id",
                    "name": "order_id"
                },
                {
                    "data": "order_id",
                    "name": "order_id"
                },
                {
                    "data": "order_id",
                    "name": "order_id"
                },
                {
                    "data": "order_id",
                    "name": "order_id"
                },
                {
                    "data": "order_id",
                    "name": "order_id"
                },
                {
                    "data": "order_customer_name",
                    "name": "order_customer_name"
                },
                {
                    "data": "order_grand_total",
                    "name": "order_grand_total"
                },
                {
                    "data": "order_id",
                    "name": "order_id"
                },
            ],

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                var info = this.dataTable().api().page.info();
                var page = info.page;
                var length = info.length;
                var index = (page * length + (iDataIndex + 1));
                var time = tConvert(aData.order_time);
                var order_price = aData.order_grand_total;
                var action = "";

                var action = action + '&nbsp;<button title="Edit"  onclick=View(' + aData.order_id +
                    ',"' + aData.order_tracking_status +
                    '") id="bEdit" type="button" class="btn btn-sm btn-success"><span class="fe fe-eye"> </span></button>';
                if (aData.order_tracking_status != "Cancelled") {
                    var action = action + '&nbsp;<button title="Track" title="Track Order"  onclick=tracking(' + aData.order_id + ') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class=" fa fa-truck"> </span></button>';
                }
                if (aData.order_tracking_status != "Preparing" && aData.order_tracking_status != "Pick Up" && aData.order_tracking_status != "Cancelled" && aData.order_tracking_status != "On transit" && aData.order_tracking_status != "Delivered") {
                    var action = action + '&nbsp;<button title="Cancel"  onclick=cancel_modal(' + aData.order_id +
                        ') id="bEdit" type="button" class="btn btn-sm btn-danger"><span class="fa fa-ban"> </span></button>';
                }

                switch (aData.order_tracking_status) {
                    case 'Failed':
                        var order_tracking_status =
                            '<span class="badge bg-dribbble badge-sm  me-1 mb-1 mt-1">Failed</span>';
                        break;
                    case 'Pending':
                        var order_tracking_status =
                            '<span class="badge bg-azure badge-sm  me-1 mb-1 mt-1">Pending</span>';
                        break;
                    case 'Cancelled':
                        var order_tracking_status =
                            '<span class="badge bg-danger badge-sm  me-1 mb-1 mt-1">Cancelled</span>';
                        break;
                    case 'Approved':
                        var order_tracking_status =
                            '<span class="badge bg-primary badge-sm  me-1 mb-1 mt-1">Approved</span>';
                        break;
                    case 'Placed':
                        var order_tracking_status =
                            '<span class="badge bg-success badge-sm  me-1 mb-1 mt-1">Placed</span>';
                        break;
                    case 'Preparing':
                        var order_tracking_status =
                            '<span class="badge bg-info badge-sm  me-1 mb-1 mt-1">Preparing</span>';
                        break;
                    case 'Pick Up':
                        var order_tracking_status =
                            '<span class="badge bg-warning badge-sm  me-1 mb-1 mt-1">Pick Up</span>';
                        break;
                    case 'On transit':
                        var order_tracking_status =
                            '<span class="badge bg-warning badge-sm  me-1 mb-1 mt-1">On transit</span>';
                        break;
                    case 'Delivered':
                        var order_tracking_status =
                            '<span class="badge bg-warning badge-sm  me-1 mb-1 mt-1">Delivered</span>';
                        break;
                    default:
                        var order_tracking_status =
                            '<span class="badge bg-warning badge-sm  me-1 mb-1 mt-1">Unknown</span>';
                }

                if (aData.is_modified_order == 1) {
                    var customer_name = aData.order_customer_name + '<i  title="Modified Order" class="text-danger p-2 fa fa-edit"></i>';
                } else {
                    var customer_name = aData.order_customer_name
                }

                $('td:eq(0)', nRow).html(index);
                $('td:eq(1)', nRow).html(aData.order_date);
                $('td:eq(2)', nRow).html(time);
                $('td:eq(3)', nRow).html(customer_name);
                // if(aData.table != null)
                // {
                //     $('td:eq(4)', nRow).html(aData.table.table_name);
                // }
                // else
                // {
                //     $('td:eq(4)', nRow).html('--');
                // }

                if (aData.customer_cart) {
                    $('td:eq(4)', nRow).html(aData.customer_cart.address);
                    $('td:eq(5)', nRow).html(aData.customer_cart.phone_number);
                    $('td:eq(6)', nRow).html(aData.customer_cart.note);
                    if (aData.customer_cart.delivery_type == 1) {
                        $('td:eq(7)', nRow).html('Pick Up');
                    } else {
                        $('td:eq(7)', nRow).html('Delivery');
                    }

                    if (aData.customer_cart.branch_id) {
                        $('td:eq(8)', nRow).html(aData.customer_cart.branch.name);
                    } else {
                        $('td:eq(8)', nRow).html('--');
                    }

                } else {
                    $('td:eq(4)', nRow).html('--');
                    $('td:eq(5)', nRow).html('--');
                    $('td:eq(6)', nRow).html('--');
                    $('td:eq(7)', nRow).html('--');
                    $('td:eq(8)', nRow).html('--');
                }

                // if(aData.branch_id != null)
                // {
                //     //$('td:eq(6)', nRow).html('Pick Up');
                //     $('td:eq(7)', nRow).html(aData.customer_cart.branch.name);
                // }else{
                //     //$('td:eq(6)', nRow).html('Delivery');
                //     $('td:eq(7)', nRow).html('--');
                // }

                $('td:eq(9)', nRow).html(order_price.toFixed(2) + " {{session('layout_data')->currency}}");
                $('td:eq(10)', nRow).html(order_tracking_status);
                $('td:eq(11)', nRow).html(action);


                if (aData.table && aData.order_date == current_date) {
                    var table_tracking_status = aData.table.table_tracking_status;
                    if (aData.order_tracking_status == "Placed" || aData.order_tracking_status == "Approved") {
                        if (table_tracking_status == "Reserved") {
                            $(nRow).css({
                                "background-color": "#c6d7c6",
                            });

                        }
                    }


                }
                if (aData.order_tracking_status == "Cancelled") {
                    $(nRow).css({
                        "background-color": "#eacecc",
                    });
                }


            }
        });

        function tracking(id) {
            $('#tracking_dropdown').html('');
            $.ajax({
                type: 'POST',
                data: {"_token": token, "id": id},
                url: '/admin/get_tracking',
                success: function (result) {
                    $('#order_id').val(id);
                    $('#order_tracking_modal_div').html(result);
                    $('#smallmodal_order_tracking').modal('show');

                }
            })

        }

        $('.tracking_status_change_btn').click(function () {
            var id = $('#order_id').val();
            var tracking_status = $('#tracking_dropdown').val();
            $.ajax({
                type: 'POST',
                data: {"_token": token, "id": id, "tracking_status": tracking_status},
                url: '/admin/change_tracking',
                success: function (result) {
                    toast(result, datatable_name);
                }
            });

        });

        function tConvert(time) {
            // Check correct time format and split into components
            time = time.toString().match(/^([01]\d|2[0-3])(:)([0-5]\d)(:[0-5]\d)?$/) || [time];

            if (time.length > 1) { // If time format correct
                time = time.slice(1); // Remove full string match value
                time[5] = +time[0] < 12 ? ' AM' : ' PM'; // Set AM/PM
                time[0] = +time[0] % 12 || 12; // Adjust hours
            }
            return time.join(''); // return adjusted time or original string
        }


        $('#reset_btn').click(function () {
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token
                },
                url: "{{route('reset_session')}}",
                success: function (result) {
                    $("#table_datatable").DataTable().ajax.reload(null, false);
                    $('.from_date').val('');
                    $('.to_date').val('');

                }
            })
        });

        function View(id, order_tracking_status) {
            $('#order_id').val(id);
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": id
                },
                url: "{{route('view-order')}}",
                success: function (result) {
                    $('.invoice_btn').addClass('d-none');
                    $(".invoice_btn").attr("href", "javascript:void(0)");
                    if (order_tracking_status == "Approved" || order_tracking_status == "Cancelled") {
                        if (order_tracking_status == "Approved") {
                            $('.invoice_btn').removeClass('d-none');
                            $(".invoice_btn").attr("href", "{{url('/admin/order-invoice/')}}/" + id);
                        }
                        $('.approve_btn').removeClass('d-none');
                    } else if (order_tracking_status == "Invoiced") {
                        $('.approve_btn').addClass('d-none');
                    } else {
                        $('.approve_btn').removeClass('d-none');
                    }
                    $('#view_modal_title').text('View Order Details');
                    $("#view_modal_body").html(result);
                    $("#scrollingmodal").modal('show');

                }
            })
        }

        function change_status(status) {
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "status": status
                },
                url: "{{route('change_status2')}}",
                success: function (result) {
                    $("#table_datatable").DataTable().ajax.reload(null, false);
                }
            })
        }

        function change_branch()
        {
            var branch_id = $('#branch_id').val();

            $.ajax({
                type: 'POST',
                data: {"_token": token, "branch_id": branch_id},
                url: '/admin/change_branch',
                success: function (result) {
                    $("#table_datatable").DataTable().ajax.reload(null, false);
                }
            })
        }

        function order_date_from_filter() {
            var from_date = $('.from_date').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "from_date": from_date
                },
                url: "{{route('order_from_date_filter')}}",
                success: function (result) {
                    $("#table_datatable").DataTable().ajax.reload(null, false);

                }
            })

        }

        function order_date_to_filter() {
            var to_date = $('.to_date').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "to_date": to_date
                },
                url: "{{route('order_to_date_filter')}}",
                success: function (result) {
                    $("#table_datatable").DataTable().ajax.reload(null, false);

                }
            })
        }

        function cancel_modal(order_id) {

            $('#order_id').val(order_id);
            $('#smallmodal').modal('show');
        }

        function cancel_order() {
            var order_id = $('#order_id').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": order_id
                },
                url: "{{route('cancel_order')}}",
                success: function (result) {
                    $('#smallmodal').modal('hide');
                    toast(result, datatable_name);
                }
            })
        }

        function approve_order() {
            var order_id = $('#order_id').val();
            $.ajax({
                type: 'POST',
                data: {
                    "_token": token,
                    "id": order_id
                },
                url: "{{route('approve_order')}}",
                success: function (result) {
                    $('#smallmodal').modal('hide');
                    toast(result, datatable_name);
                }
            })

        }

        function print_order() {
            var order_id = $('#order_id').val();
            var src = "{{route('print_order')}}" + '?order_id=' + order_id;

            $('#print_order_div').html('<iframe src="' + src + '"></iframe>');

        }
    </script>

@endsection
