@php

$layout_data=$data['layout_data'];

@endphp

@extends('layouts.app')
@section('styles')
<link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />
<!-- INTERNAL Switcher css -->
<link f="{{asset('assets/switcher/css/switcher.css')}}" rel="stylesheet" />
<link href="{{asset('assets/switcher/demo.css')}}" rel="stylesheet" />

<style>
.fav_icon_div div {
    width: 100%;
    height: 55%;
}

.input-color-picker {
    width: 25%;
}

.admin_logo_small div {
    width: 75%;
    height: 75%;
}

.admin_logo div {
    width: 100%;
    height: 50%;
}
</style>

@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Manage Layout</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Master Setting</a></li>
            <li class="breadcrumb-item active" aria-current="page">Manage Layout</li>
        </ol>
    </div>
</div>

@canany(['layout-create','layout-edit'])
<form method="POST" id="layoutForm" class="myform" enctype="multipart/form-data">
    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">


    @csrf
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">







                <div class="card-header">
                    <h3 class="card-title">Manage Website Layout</h3>
                </div>



                <!-- ############################Advanced Section####################                   -->
                <div style="    border: none;" class="card-body">


                    <div class="form-row">

                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip01">Website Name *</label>
                            <input data-parsley-required-message="Website Name Required" type="text"
                                class="form-control" name="website_name" id="website_name"
                                value="{{$layout_data->website_name}}" required>
                        </div>


                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip01">Website Link *</label>
                            <input data-parsley-required-message="Website Link Required" type="text"
                                class="form-control" name="website_link" id="website_link"
                                value="{{$layout_data->website_link}}" required>
                        </div>


                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip01">Website Email *</label>
                            <input data-parsley-required-message="Website Email Required" type="text"
                                class="form-control" name="website_email" id="website_email"
                                value="{{$layout_data->website_email}}" required>
                        </div>


                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip01">Website Phone *</label>
                            <input data-parsley-required-message="Website Phone Required" maxlength="8" type="text"
                                class="form-control" name="website_phone" id="website_phone"
                                value="{{$layout_data->website_phone}}" required>
                        </div>





                        <div class="col-xl-3 mb-3">

                            <label for="validationTooltip01">Website Address *</label>

                            <textarea class="form-control" data-parsley-required-message="Website Address Required"
                                name="website_address" id="website_address" cols="30" rows="2"
                                required>{{$layout_data->website_address}}</textarea>


                        </div>


                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip01">Choose Country *</label>
                            <select class="form-control select2-show-search form-select" name="country" id="country"
                                value="{{$layout_data->website_country}}" required
                                data-parsley-required-message="Country required">
                                <option value="">-- Choose Country --</option>
                                @foreach($data['country_data'] as $country)
                                @if($layout_data->website_country==$country['id'])
                                @php $selected="Selected"; @endphp
                                @else
                                @php $selected=""; @endphp
                                @endif
                                <option {{$selected}} value="{{$country['id']}}">{{$country['name']}}</option>
                                @endforeach

                            </select>
                        </div>


                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip01">Developed By *</label>
                            <input data-parsley-required-message="Developed By required" type="text"
                                class="form-control" name="developed_by" id="developed_by"
                                value="{{$layout_data->developed_by}}" required>
                        </div>





                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip01">Developed Company Link *</label>




                            <input data-parsley-required-message="Developed Company Link Required" type="text"
                                class="form-control" name="developed_compnay_link" id="developed_compnay_link"
                                value="{{$layout_data->developer_link}}" required>
                        </div>


                        <div class="col-xl-3 mb-3 fav_icon_div">

                            <label for="validationTooltip02">Website Logo
                                ({{env('WEBSITE_LOGO_SIZE')}})* </label>



                            <input type="file" name="website_logo" id="website_logo" class="dropify"
                                data-default-file="{{url('uploads/layouts/')}}/{{$layout_data->webste_logo}}"
                                data-bs-height="10%" />


                        </div>






                        <div class="col-xl-3 mb-3 fav_icon_div">

                            <label for="validationTooltip02">Fav Icon
                                ({{env('FAV_ICON_SIZE')}})*</label>



                            <input type="file" name="website_icon" id="website_icon" class="dropify"
                                data-default-file="{{url('uploads/layouts/')}}/{{$layout_data->website_icon}}"
                                data-bs-height="10%" />
                        </div>











                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip02">Theme Color</label>
                            <input class="form-control w-60p h-60 input-color-picker "
                                value="{{$layout_data->theme_color}}" id="colorID" type="color" data-id="bg-color"
                                data-id1="bg-hover" data-id2="bg-border" data-id7="transparentcolor"
                                name="primary_color">


                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Title *</label>
                            <input data-parsley-required-message="Title  required" type="text" class="form-control"
                                name="title" id="title" value="{{$layout_data->website_title}}" required="">
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Meta Description </label>
                            <input data-parsley-required-message="" type="text" class="form-control"
                                name="meta_description" id="meta_description" value="{{$layout_data->meta_data}}"
                                required="">

                        </div>
                        <!-- ################################## Social Media Sections ########################## -->
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Facebook </label>
                            <div class="input-group">
                                <span class="input-group-text" id="basic-addon1"><i class="fa fa-facebook"></i></span>
                                <input type="text" class="form-control" name="facebbok" placeholder="Facebook Link"
                                    aria-label="Username" value="{{$layout_data->facebook_link}}"
                                    aria-describedby="basic-addon1">
                            </div>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Instagram </label>
                            <div class="input-group">
                                <span class="input-group-text bg-pink" id="basic-addon1"><i
                                        class="fa fa-instagram"></i></span>
                                <input type="text" class="form-control" name="instagram" placeholder="Instagram Link"
                                    aria-label="Username" value="{{$layout_data->instagram_link}}"
                                    aria-describedby="basic-addon1">
                            </div>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Twitter </label>
                            <div class="input-group">
                                <span class="input-group-text bg-secondary" id="basic-addon1"><i
                                        class="fa fa-twitter"></i></span>
                                <input type="text" class="form-control" name="twitter" placeholder="Twitter Link"
                                    aria-label="Username" value="{{$layout_data->twitter_link}}"
                                    aria-describedby="basic-addon1">
                            </div>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Youtube</label>
                            <div class="input-group">
                                <span class="input-group-text bg-danger" id="basic-addon1"><i
                                        class="fa fa-youtube"></i></span>
                                <input type="text" class="form-control" name="youtube" placeholder="Youtube Link"
                                    aria-label="Username" value="{{$layout_data->youtube_link}}"
                                    aria-describedby="basic-addon1">
                            </div>

                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Whats App Number </label>
                            <div class="input-group">
                                <span class="input-group-text bg-teal" id="basic-addon1"><i
                                        class="fa fa-whatsapp"></i></span>
                                <input type="number" class="form-control" name="whatsapp" placeholder="Whats App Number"
                                    aria-label="Username" value="{{$layout_data->whats_app_number}}"
                                    aria-describedby="basic-addon1">
                            </div>

                        </div>

                        <!-- ################################## End Of Social Media Sections ########################## -->




                    </div>
                    @can('layout-create')
                    <a id="create_btn" href="#" onclick="createOrUpdate('add_website_layout', 'layoutForm', '', '','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan


                </div>


            </div>


        </div>
    </div>

    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">





                <div class="card-header">
                    <h3 class="card-title">Manage Admin Layout</h3>
                </div>



                <!-- ############################Advanced Section####################                   -->
                <div style="    border: none;" class="card-body">


                    <div class="form-row">

                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip02">Admin Theme Color</label>
                            <input class="form-control w-60p h-60 input-color-picker "
                                value="{{$layout_data->admin_theme_color}}" id="colorID" type="color" data-id="bg-color"
                                data-id1="bg-hover" data-id2="bg-border" data-id7="transparentcolor"
                                name="admin_primary_color">
                        </div>

                        <div class="col-xl-3 mb-3">
                            <label for="validationTooltip02">Choose Notification Sound *</label>
                            <!--//Notification Audio Section-->
                            <span id="notification_sound_span"></span>

                            <!--End of Notification Audio Section-->
                            <select class="form-control notification_change" name="notification_sound"
                                data-parsley-required-message="Notification Sound Required" Required>
                                <option value=""> --Choose Notification Sound --</option>
                                @php
                                $notification_sound=$layout_data->notification_sound;
                                @endphp
                                @for($i=1;$i<=8;$i++) @if($notification_sound==$i) @php $selected="Selected" ; @endphp
                                    @else @php $selected="" ; @endphp @endif <option value="{{$i}}" {{$selected}}>
                                    Notification Sound
                                    {{$i}}</option>
                                    @endfor


                            </select>
                        </div>

                        <div class="col-xl-3 mb-3 admin_logo">
                            <label for="validationTooltip02">Admin Logo
                                ({{env('ADMIN_LOGO_SIZE')}})*</label>
                            <input type="file" id="input-file-now-custom-1" name="admin_logo" class="dropify"
                                data-default-file="{{url('uploads/layouts/')}}/{{$layout_data->admin_logo}}" />
                        </div>
                        <div class="col-xl-3 mb-3 admin_logo">
                            <label for="validationTooltip02 admin_logo">Admin Logo Dark Mode
                                ({{env('ADMIN_LOGO_SIZE')}})*</label>
                            <input type="file" id="input-file-now-custom-1" name="admin_d_logo" class="dropify"
                                data-default-file="{{url('uploads/layouts/')}}/{{$layout_data->admin_d_logo}}" />
                        </div>



                        <div class="col-xl-3 mb-3 admin_logo_small">
                            <label for="validationTooltip02">Admin Logo Small
                                ({{env('ADMIN_LOGO_SM_SIZE')}})*</label>
                            <input type="file" name="admin_sm_logo" id="admin_sm_logo" class="dropify"
                                data-default-file="{{url('uploads/layouts/')}}/{{$layout_data->admin_logo_sm}}"
                                data-bs-height="180" />
                        </div>

                        <div class="col-xl-3 mb-3 admin_logo_small">
                            <label for="validationTooltip02"> Logo Small Dark Mode
                                ({{env('ADMIN_LOGO_SM_SIZE')}})*</label>
                            <input type="file" name="admin_d_sm_logo" id="admin_d_sm_logo" class="dropify"
                                data-default-file="{{url('uploads/layouts/')}}/{{$layout_data->admin_d_logo_sm}}"
                                data-bs-height="180" />
                        </div>

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Admin Login Page Background Image
                                ({{env('ADMIN_BACKGROUND_IMAGE')}})*</label>

                            <input type="file" name="admin_background_image" id="admin_background_image" class="dropify"
                                data-default-file="{{url('uploads/layouts/')}}/{{$layout_data->admin_background_image}}"
                                data-bs-height="180" />
                        </div>

                    </div>


                    <a id="create_btn" href="#" onclick="createOrUpdate('add_website_layout', 'layoutForm', '', '','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>

                    <!-- ############################Admin Advanced Section####################                   -->


                    @can('layout-create')

                    @endcan
                </div>


            </div>
        </div>
    </div>
</form>
@endcanany

<!-- //End Of Website Section -->






@endsection

@section('scripts')

<!-- Switcher js -->
<script src="{{asset('assets/switcher/js/switcher.js')}}"></script>

<!-- CUSTOM JS -->
<script src="{{asset('assets/js/custom1.js')}}"></script>


<!-- FILE UPLOADES JS -->
<script src="{{asset('assets/plugins/fileuploads/js/fileupload.js')}}"></script>
<script src="{{asset('assets/plugins/fileuploads/js/file-upload.js?v1')}}"></script>

<script>
$('.add_new_row').click(function() {
    var rowCount = $('.meta_table tr').length;
    $('.meta_table_body').append('<tr class="row_' + rowCount +
        '"><td><input type="text" class="form-control" name="meta_name[]"></td><td><input type="text" class="form-control" name="meta_content[]"></td><td class="text-center"><i class="fa fa-close" onclick="remove_row(' +
        rowCount + ')"></i></td></tr>');

});



function remove_row(row_id) {
    $('.row_' + row_id).remove();
}

$('.notification_change').change(function() {

    var notificaion_sound_value = $('.notification_change').val();
    $('#notification_sound_span').html('<audio id="notification_audio_change"><source src="/assets/sounds/' +
        notificaion_sound_value + '.mp3" class="notification_audio_change_source" type="audio/ogg"></audio>'
    );

    play_changed_audio();

});

function play_changed_audio() {
    var notification_audio_change = document.getElementById("notification_audio_change");
    notification_audio_change.play();
}
</script>


@endsection