@extends('layouts.app')

@section('styles')

@endsection

@section('content')

<style>
.switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    -webkit-transition: .4s;
    transition: .4s;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    -webkit-transition: .4s;
    transition: .4s;
}

input:checked+.slider {
    background-color: #1c1c1c;
}

input:focus+.slider {
    box-shadow: 0 0 1px #1c1c1c;
}

input:checked+.slider:before {
    -webkit-transform: translateX(26px);
    -ms-transform: translateX(26px);
    transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
    border-radius: 34px;
}

.slider.round:before {
    border-radius: 50%;
}
</style>


<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Image Resolution</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Setting</a></li>
            <li class="breadcrumb-item active" aria-current="page">Manage Image Resolution</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['image-resolution-list','image-resolution-edit'])
<div class="row">
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Manage Image Resolution</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="expanel expanel-default">
                                <div class="expanel-heading">Image Catergory</div>
                                <div class="expanel-body border">
                                    <div class="row fw-bold">
                                        <div class="col-md-2 text-center">#</div>
                                        <div class="col-md-4 text-center">Image Category</div>
                                        <div class="col-md-2 text-center">Width(px)</div>
                                        <div class="col-md-2 text-center">Height(px)</div>
                                        <div class="col-md-2 text-center">File Size(KB)</div>
                                    </div>
                                </div>
                                @php $j=1; @endphp
                                @foreach($data['image_resolutions'] as $image_resolution)
                                @php
                                $image_size= $image_resolution['image_resolution_dimenssion'];
                                $resolution_array = explode("x", $image_size);
                                @endphp
                                <div class="expanel-body ">
                                    <div class="row ">
                                        <div class="col-md-2 text-center">{{$j}}</div>
                                        <div class="col-md-4">{{$image_resolution['image_resolution_name']}}</div>
                                        <div class="col-md-2"> <input Type="number"
                                                name="image_width_{{$image_resolution['image_resolution_id']}}"
                                                class="form-control" value="{{$resolution_array[0]}}"
                                                data-parsley-required-message="Width Required" required> </div>
                                        <div class="col-md-2"> <input Type="number"
                                                name="image_height_{{$image_resolution['image_resolution_id']}}"
                                                class="form-control" value="{{$resolution_array[1]}}"
                                                data-parsley-required-message="Height Required" required> </div>
                                        <div class="col-md-2"><input Type="number"
                                                name="image_file_size_{{$image_resolution['image_resolution_id']}}"
                                                class="form-control" value="{{$image_resolution['image_size']}}"
                                                data-parsley-required-message="Size Required" required>
                                        </div>
                                    </div>
                                </div>
                                @php $j++; @endphp
                                @endforeach




                            </div>
                        </div>

                    </div>
                </form>
                @can('image-resolution-edit')
                <a id="update_btn" href="#"
                    onclick="createOrUpdate('{{route('image_resolution_update')}}', 'createForm', '', '','')"
                    class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                @endcan

            </div>
        </div>
    </div>
</div>
@endcanany


@endsection
@section('scripts')


@endsection