@extends('layouts.app')
@section('styles')
<link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />
@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Manage Giftcards</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Manage</a></li>
            <li class="breadcrumb-item active" aria-current="page">Giftcards</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['giftcard-create','giftcard-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Giftcard</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="giftcard_id" name="giftcard_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Giftcard Name *</label>
                            <input data-parsley-required-message="Giftcard Name Required" type="text"
                                class="form-control" name="gift_card_name" id="gift_card_name" value="" required>

                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Giftcard Amount *</label>
                            <input type="text" data-parsley-required-message="Giftcard amount  Required"
                                class="form-control" name="gift_card_amount" id="gift_card_amount" value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Giftcard validity (days) *</label>
                            <input type="text" data-parsley-required-message="Giftcard Validity Required"
                                class="form-control custom-input-file" name="gift_card_validity" id="gift_card_validity"
                                value="" required>
                        </div>
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02">Giftcard Status *</label>
                            <select data-parsley-required-message="Giftcard Status Required" class="form-control"
                                name="status" id="status" required>
                                <option value="">--Choose Status--</option>
                                <option value="0">Active</option>
                                <option value="1">Inactive</option>
                            </select>
                        </div>
                    </div>
                    @can('giftcard-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('{{route('add_giftcard')}}', 'createForm', '', 'giftcard_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('giftcard-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('{{route('update_giftcard')}}', 'createForm', '', 'giftcard_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->
<!-- Row -->
@can('giftcard-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Giftcards</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom " id="giftcard_datatable">
                        <thead class="text-center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0"> Name</th>
                                <th class="wd-15p border-bottom-0"> Amount</th>
                                <th class="wd-15p border-bottom-0"> Validity (Days) </th>
                                <th class="wd-10p border-bottom-0">Active/Inactive</th>
                                @canany(['giftcard-edit','giftcard-delete'])
                                <th class="wd-10p border-bottom-0">Actions</th>
                                @endcanany
                            </tr>
                        </thead>

                    </table>
                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>




@endsection

@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
<script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css?v1')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var coloumn_data = ['giftcard_id', 'giftcard_name', 'giftcard_amount', 'giftcard_validity', 'giftcard_active_status'];
@canany(['giftcard-edit', 'giftcard-delete'])
var coloumn_data = ['giftcard_id', 'giftcard_name', 'giftcard_amount', 'giftcard_validity', 'giftcard_active_status',
    'giftcard_id'
];
@endcanany
var coloumn_array = [];
for (let i = 0; i < coloumn_data.length; i++) {
    coloumn_array.push({
        "data": "" + coloumn_data[i] + "",
        "name": "" + coloumn_data[i] + ""
    });
}
$('#giftcard_datatable').DataTable({
    // "pagingType": "full_numbers",
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": false,
    "info": false,

    "columnDefs": [{
            "orderable": true
        },
        {
            "className": "text-center"
        }
    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('giftcard_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": false,
    "columns": coloumn_array,

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";
        if (aData.giftcard_active_status == 0) {
            var checked = "checked";
            var status = 1;
        } else {
            var checked = "";
            var status = 0;
        }
        //Edit Action
        @can('giftcard-edit')
        var action = action + '&nbsp;<button onclick=edit(' + aData.giftcard_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('giftcard-delete')
        var action = action + '&nbsp;<button onclick="delete_modal(' + aData.giftcard_id +
            ')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan
        var active_status = '<label class="switch"><input type="checkbox" onchange="change_status(' + aData
            .giftcard_id + ',' + status + ')" ' + checked + '><span class="slider"></span></label>';
        $('td:eq(0)', nRow).html(index).addClass('text-center');
        $('td:eq(1)', nRow).html(aData.giftcard_name).addClass('text-left');
        $('td:eq(2)', nRow).html(aData.giftcard_amount.toFixed(2)).addClass('text-end ');
        $('td:eq(3)', nRow).html(aData.giftcard_validity).addClass('text-center');
        $('td:eq(4)', nRow).html(active_status).addClass('text-center');
        @canany(['giftcard-edit', 'giftcard-delete'])
        $('td:eq(5)', nRow).html(action).addClass('text-center');
        @endcanany
    }
});

//####################Status  Change Section#################### 
function change_status(gift_card_id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "gift_card_id": gift_card_id,
            'status': status
        },
        url: "{{route('change_giftcard_status')}}",
        success: function(result) {
            toast(result, 'giftcard_datatable');
        }
    })
}
// #################### End Status  Change Section##############
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_giftcard')}}",
        success: function(result) {
            $('#gift_card_name').val(result.data.giftcard_name);
            $('#gift_card_amount').val(result.data.giftcard_amount);
            $('#gift_card_validity').val(result.data.giftcard_validity);
            $('#status').val(result.data.giftcard_active_status);
            $('#giftcard_id').val(result.data.giftcard_id);
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();

        }
    })
}
// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#giftcard_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#giftcard_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_giftcard')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, 'giftcard_datatable');
        }
    })
}
// #################### End Of Delete Section ##################
</script>
@endsection