@extends('layouts.app')

@section('styles')

@endsection

@section('content')

    <!-- PAGE-HEADER -->
    <div class="page-header">
        <h1 class="page-title">Visitors</h1>
        <div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Visitors</a></li>
            </ol>
        </div>
    </div>
    <!-- PAGE-HEADER END -->

    <!-- Row -->
    @can('customer-list')
        <div class="row row-sm">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">View Visitors</h3>
{{--                        <div class="card-options">--}}
{{--                            <a href="/admin/download_customer" class="btn btn-success" style="color: white"><i class="fa fa-download"></i>&nbsp;Export Customer</a>--}}
{{--                        </div>--}}

                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table  class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;" id="table_datatable">
                                <thead class="text-center">
                                <tr>
                                    <th class="wd-15p border-bottom-0">#</th>
                                    <th class="wd-15p border-bottom-0">Customer ID</th>
                                    <th class="wd-15p border-bottom-0">Name</th>
                                    <th class="wd-15p border-bottom-0">Mobile</th>
                                    <th class="wd-15p border-bottom-0">Email ID</th>
{{--                                    <th class="wd-10p border-bottom-0">Actions</th>--}}
                                </tr>
                                </thead>

                            </table>

                            <div class="col-sm-12 col-md-12">
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </div>
    @endcan
    <!-- End Row -->

    <!-- Modal -->



    <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete</h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Do you want to delete the Customer ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button onclick="delete_item()" class="btn btn-primary">Delete</button>
                </div>
            </div>
        </div>
    </div>


    {{-- #########################View Modal################################### --}}
    <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" style="font-weight: bold;" id="view_modal_title">Customer Details</h5>
                    <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body"  id="view_modal_body">

                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    {{-- #########################End Of View Modal############################ --}}




@endsection
@section('scripts')
    {{-- ################################Jquery Datatable########################### --}}
    <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
    <script src="{{asset('assets/jquery-datatable/jquery.dataTables.js?v1111111111113')}}"></script>
    {{-- ########################################################################## --}}
    <script>
        var public_url="{{url('/')}}/{{env('ADMIN_PANEL_ROUTE')}}";
        var token = $("meta[name=csrf-token]").attr("content");
        var datatable_name="table_datatable";
        var coloumn_data=['customer_id','customer_unique_id','customer_name','customer_mob','customer_mail_id'];
        var coloumn_array=[];
        for (let i = 0; i <coloumn_data.length; i++) {
            coloumn_array.push({"data": ""+coloumn_data[i]+"", "name": ""+coloumn_data[i]+""});
        }
        $('#table_datatable').DataTable({
            "responsive": true,
            "serverSide": true,
            "ordering": true,
            "searching": true,
            "bLengthChange": false,
            "info":false,
            "bSort": true,
            "order": [
                [0, 'desc']
            ],
            "columnDefs": [{
                "targets": [0,coloumn_data.length-1],
            },
                {"className": "text-center", "targets": [0,1]},
                {"className": "text-left", "targets": [2,3,4]},
                {"orderable": false, "targets": [1]}

            ],
            "displayLength":10,
            "ajax": {
                "url":  public_url+"/visitors_datatable",
                "type": "post",
                "data": function (data) {
                    data._token = token;

                    return data;

                }
            }, "AutoWidth": true,
            "columns":coloumn_array,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                var info = this.dataTable().api().page.info();
                var page = info.page;
                var length = info.length;
                var index = (page * length + (iDataIndex + 1));
                var action="";
                var created_at=aData.created_at.substring(0, 10);
                //View Function
                //var action=action+'&nbsp;<a title="View"  href="customer_orders/'+aData.customer_id+'" type="button" class="btn btn-sm custom-btn-warning">Orders</a>';
                //var action=action+'&nbsp;<a title="View"  href="cart_activities/'+aData.customer_id+'" type="button" class="btn btn-sm custom-btn-warning">Cart Activities</a>';
               // var action=action+'&nbsp;<button title="View"  onclick="" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
                //Edit Action
{{--                @can('customer-edit')--}}
{{--                var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.customer_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';--}}
{{--                @endcan--}}
                //Delete Action
{{--                @can('customer-delete')--}}
{{--                var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.customer_id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';--}}
{{--                @endcan--}}
                $('td:eq(0)', nRow).html(index);
                $('td:eq(5)', nRow).html(action).addClass('text-center');

            }
        });

        //        // #################### Edit Section ############################
        function edit(id){
            $.ajax({
                type: 'POST',
                data: {"_token": token,"id": id},
                url: public_url+'/edit_customer',
                success: function (result) {
                    $('#customer_id').val(result.customer_id);
                    $('#customer_name').val(result.customer_name);
                    $('#mobile_number').val(result.customer_mob);
                    $('#email').val(result.customer_mail_id);
                    $('#q_id').val(result.customer_q_id);
                    $('#company_name').val(result.company_name);
                    $('#address').val(result.customer_address);
                    $('#address').val(result.customer_address);
                    $('#create_btn').hide();
                    $('#update_btn').show();
                    $('#token_status').val(1);
                    $('#back-to-top').click();
                }
            })
        }
        //       // #################### End Of Edit Section ####################
        //      // #################### Delete Section ##########################
        function delete_modal(id){
            $('#customer_id').val(id);
            $('#smallmodal').modal('show');
        }
        function delete_item(){
            var id=$('#customer_id').val();
            $.ajax({
                type: 'POST',
                data: {"_token": token,"id": id},
                url: public_url+'/delete_customer',
                success: function (result) {
                    $('#smallmodal').modal('hide');
                    toast(result,datatable_name);
                }
            })
        }
        //      // #################### End Of Delete Section ##################

        // #########################View Section ##########################
        function View(id){
            $.ajax({
                type: 'POST',
                data: {"_token": token,"id": id},
                url: public_url+'/view_customer',
                success: function (result) {
                    $('#view_modal_body').html(result);
                    $('#scrollingmodal').modal('show');
                }
            })
        }
        // ###############################################################

    </script>
@endsection


