@extends('layouts.app')

@section('styles')


@endsection

@section('content')
<style>
input:checked+.slider {
    background-color: <?php echo session('layout_data')->admin_theme_color;
    ?> !important;
}
</style>
<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Banner</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Website</a></li>
            <li class="breadcrumb-item active" aria-current="page">Banner</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
@canany(['banner-create','banner-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Add Banner</h3>
            </div>
            <div class="card-body">
                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">
                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                    <input id="banner_id" name="banner_id" type="hidden" value="">

                    @csrf
                    <div class="form-row">


                        @foreach($available_languages as $available_language)
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Banner Heading
                                {{$available_language['language_short_code']}} *</label>
                            <input
                                data-parsley-required-message="Banner Heeading {{$available_language['language_name']}} Required"
                                type="text" class="form-control"
                                name="banner_heading_{{$available_language['language_id']}}"
                                id="banner_heading_{{$available_language['language_id']}}" value="" required>

                        </div>
                        @endforeach

                        @foreach($available_languages as $available_language)
                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip01">Banner Description
                                {{$available_language['language_short_code']}} *</label>
                            <textarea
                                data-parsley-required-message="Banner Description {{$available_language['language_name']}} Required"
                                class="form-control" name="banner_description_{{$available_language['language_id']}}"
                                id="banner_description_{{$available_language['language_id']}}" value="" required>
                        </textarea>

                        </div>
                        @endforeach

                        <div class="col-xl-4 mb-3">
                            <label for="validationTooltip02"> Banner ({{env('CATEGORYBANNERIMAGESIZE')}}px)
                                *</label>
                            <input type="file" data-parsley-required-message="Banner Requied" required
                                class="form-control custom-input-file" name="banner" id="banner" value="">
                        </div>

                    </div>
                    @can('banner-create')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('{{route('add_banner')}}', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                    @endcan
                    @can('banner-edit')
                    <a id="update_btn" style="display: none" href="#"
                        onclick="createOrUpdate('{{route('update_banner')}}', 'createForm', '', 'table_datatable','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </form>
            </div>
        </div>
    </div>
</div>
@endcanany
<!-- /ROW-1 CLOSED -->

<!-- Row -->
@can('banner-list')
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">View Banners</h3>
                <div class="card-options">
                    <button type="button" onclick="$('#change_order').modal('show');"
                        class="btn btn-sm btn-primary    btn-icon btn-facebook"><i
                            class="fa fa-sort"></i>&nbsp;&nbsp;Change
                        Order</button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom dataTable no-footer "
                        style="width: 100% !important;" id="table_datatable">
                        <thead class="text-center">
                            <tr>
                                <th class="wd-15p border-bottom-0">#</th>
                                <th class="wd-15p border-bottom-0">Name</th>
                                <th class="wd-15p border-bottom-0">Banner</th>
                                <th class="wd-15p border-bottom-0">Status</th>
                                <th class="wd-15p border-bottom-0">Added By</th>
                                <th class="wd-10p border-bottom-0">Actions</th>
                            </tr>
                        </thead>

                    </table>

                    <div class="col-sm-12 col-md-12">
                    </div>
                </div>
            </div>


        </div>

    </div>
</div>
@endcan
<!-- End Row -->



<!-- ####################################delete Modal ########################### -->
<div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder">Delete</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Do you want to delete the Banner ?</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="delete_item()" class="btn btn-primary">Delete</button>
            </div>
        </div>
    </div>
</div>
<!-- ################################ delete Modal################################## -->
<!-- ############################################Change Sort  Order ##########################              -->
<div class="modal  fade" id="change_order" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">

                <h5 class="modal-title fw-bolder">Change Banner Sort Order</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">


                <div id="imageListId" class="row">
                    @foreach($banners as $banner)
                    <div id="imageNo{{ $banner->banner_id }}" class="col-md-12 col-lg-6 col-xl-3 listitemClass">
                        <div class="thumbnail text-center">
                            <a href="javascript:void(0)">
                                <img src="{{ asset('/uploads/banner_images/'.$banner->banner_image) }}" alt="thumb1"
                                    class="thumbimg">
                            </a>
                            <div class="caption ">
                                <h4><strong>{{ $banner->banner_name }}</strong></h4>
                            </div>
                        </div>
                    </div>

                    @endforeach
                </div>



                <input type="hidden" id="outputvalues">

            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button class="btn btn-primary" data-bs-dismiss="modal" onclick="saveorder()">Update Order</button>
            </div>
        </div>
    </div>
</div>
<!-- ##################################################End Of Change View Order ############################ -->

<!-- {{-- #########################View Modal################################### --}} -->
<div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bolder" id="view_modal_title"></h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body" id="view_modal_body">

            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- {{-- #########################End Of View Modal############################ --}} -->



@endsection
@section('scripts')
{{-- ################################Jquery Datatable########################### --}}
{{-- <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script> --}}
<link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css')}}">
<script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>

<script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>

{{-- ########################################################################## --}}
<script>
var token = $("meta[name=csrf-token]").attr("content");
var datatable_name = "table_datatable";
$('#table_datatable').DataTable({
    "responsive": true,
    "serverSide": true,
    "ordering": true,
    "searching": true,
    "bLengthChange": true,
    "info": false,
    "bSort": true,
    "order": [
        [0, 'desc']
    ],
    "columnDefs": [{
            "targets": [0, 4],
            "orderable": true
        },
        {
            "className": "text-center",
            "targets": [0, 2, 3, 4, 5]
        },
        {
            "className": "text-left",
            "targets": []
        }

    ],
    "displayLength": 10,
    "ajax": {
        "url": "{{route('banner_datatable')}}",
        "type": "post",
        "data": function(data) {
            data._token = token;

            return data;

        }
    },
    "AutoWidth": true,
    "columns": [{
            "data": "banner_id",
            "name": "banner_id"
        },
        {
            "data": "banner_name",
            "name": "banner_name"
        },
        {
            "data": "banner_id",
            "name": "banner_id"
        },
        {
            "data": "banner_id",
            "name": "banner_id"
        },
        {
            "data": "name",
            "name": "name"
        },
        {
            "data": "banner_id",
            "name": "banner_id"
        },
    ],

    "fnCreatedRow": function(nRow, aData, iDataIndex) {
        var info = this.dataTable().api().page.info();
        var page = info.page;
        var length = info.length;
        var index = (page * length + (iDataIndex + 1));
        var action = "";

        //Change Active Status Section
        if (aData.active_status == 0) {

            var change_status =
                '<label class="switch bg-primary"><input type="checkbox"  onclick="change_active_status(' +
                aData
                .banner_id + ',1)"><span class="slider"></span></label>';
        } else {
            var change_status =
                '<label class="switch bg-primary"><input type="checkbox" onclick="change_active_status(' +
                aData
                .banner_id + ',0)" checked ><span class="slider"></span></label>';
        }




        if (aData.banner_image == "" || aData.banner_image == null) {
            aData.banner_image = "no_image.png";
        }
        var image = '<a href="/uploads/banner_images/' + aData.banner_image +
            '" target="_blank"><img style="width:100px; " src="/uploads/banner_images/' + aData
            .banner_image + '"></a>';
        //Edit Action
        var action = action + '&nbsp;<button title="View"  onclick=View(' + aData.banner_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-success"><span class="fe fe-eye"> </span></button>';
        @can('banner-edit')
        var action = action + '&nbsp;<button title="Edit"  onclick=edit(' + aData.banner_id +
            ') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
        @endcan
        //Delete Action
        @can('banner-delete')
        var action = action + '&nbsp;<button title="Delete" onclick="delete_modal(' + aData.banner_id +
            ')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
        @endcan
        $('td:eq(0)', nRow).html(index);
        $('td:eq(2)', nRow).html(image);
        $('td:eq(3)', nRow).html(change_status);
        $('td:eq(5)', nRow).html(action);
    }
});

// #################### View Section ############################
function View(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('view_banner')}}",
        success: function(result) {
            $('#view_modal_title').text('Banner Details');
            $('#view_modal_body').html(result);
            $('#scrollingmodal').modal('show');
        }
    })
}

//#######################End Of View Section ##################
// #################### Edit Section ############################
function edit(id) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('edit_banner')}}",
        success: function(result) {
            $('#banner_id').val(result.banner_id);
            // ################# Name Section########
            var multi_languae = JSON.parse(result.banner_name_multi);
            $.each(multi_languae, function(index, value) {
                $('#banner_heading_' + index).val(value);
            });
            // ######################End Of  Name Section############

            // ################# banner Description  Section########
            var multi_languae = JSON.parse(result.banner_description_multi);
            $.each(multi_languae, function(index, value) {
                $('#banner_description_' + index).val(value);
            });
            // ######################End Of  banner Descrtion Section############
            $('#banner').removeAttr('required');
            $('#create_btn').hide();
            $('#update_btn').show();
            $('#back-to-top').click();

        }
    })
}
// #################### End Of Edit Section ####################
// #################### Delete Section ##########################
function delete_modal(id) {
    $('#banner_id').val(id);
    $('#smallmodal').modal('show');
}

function delete_item() {
    var id = $('#banner_id').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "id": id
        },
        url: "{{route('delete_banner')}}",
        success: function(result) {
            $('#smallmodal').modal('hide');
            toast(result, datatable_name);
        }
    })
}
// #################### End Of Delete Section ##################


$(function() {
    $("#imageListId").sortable({
        update: function(event, ui) {
            getIdsOfImages();
        } //end update         
    });
});

function getIdsOfImages() {
    var values = [];
    $('.listitemClass').each(function(index) {
        values.push($(this).attr("id")
            .replace("imageNo", ""));
    });

    $('#savebtnget').css('display', 'inline-block')
    $('#outputvalues').val(values);
}

function saveorder() {
    var array = $('#outputvalues').val();
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "array": array
        },
        url: "{{route('banner_change_order')}}",
        success: function(result) {
            $('#change_order').modal('hide');
            toast(result, datatable_name);
            setTimeout(function() {
                location.reload();
            }, 1000);

        }
    });
}

function change_active_status(id, status) {
    $.ajax({
        type: 'POST',
        data: {
            "_token": token,
            "banner_id": id,
            "status": status
        },
        url: "{{route('change_banner_status')}}",
        success: function(result) {
            toast(result, datatable_name);
        }
    })
}
</script>


@endsection