@php

$layout_data=$data['layout_data'];
@endphp

@extends('layouts.app')
@section('styles')
<link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />
<!-- INTERNAL Switcher css -->
<link href="{{asset('assets/switcher/css/switcher.css')}}" rel="stylesheet" />
<link href="{{asset('assets/switcher/demo.css')}}" rel="stylesheet" />
@endsection

@section('content')

<!-- PAGE-HEADER -->
<div class="page-header">
    <h1 class="page-title">Automation</h1>
    <div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="dashboard">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Master Setting</a></li>
            <li class="breadcrumb-item active" aria-current="page">Automation</li>
        </ol>
    </div>
</div>
<!-- PAGE-HEADER END -->

<!-- ROW-1 OPEN -->
<!-- //Website Section           -->
@canany(['automation-create','automation-edit'])
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Manage Automation</h3>
            </div>

            <form method="POST" id="layoutForm" class="myform" enctype="multipart/form-data">
                <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">


                @csrf


                <!-- ############################Mail  Section####################                   -->
                <div style="    border: none;" class="card-body">
                    <div class="panel-group1" id="accordion1">
                        <div class="panel panel-default mb-4">
                            <div class="panel-heading1 ">
                                <h4 class="panel-title1">
                                    <a class="accordion-toggle collapsed" data-bs-toggle="collapse"
                                        data-bs-parent="#accordion" href="#collapsesix" aria-expanded="false">Email
                                        Automation</a>
                                </h4>
                            </div>
                            <div id="collapsesix" class="panel-collapse collapse" role="tabpanel" aria-expanded="false">
                                <div class="panel-body">

                                    <div class="form-row">

                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">Mail Mailer</label>
                                            <input data-parsley-required-message="Mail Mailer Required" type="text"
                                                class="form-control" name="mail_mailer" id="mail_mailer"
                                                value="{{$layout_data['mail_mailer']}}" required="">
                                        </div>

                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">Mail Host</label>
                                            <input data-parsley-required-message="Mail Host Required" type="text"
                                                class="form-control" name="mail_host" id="mail_host"
                                                value="{{$layout_data['mail_host']}}" required="">
                                        </div>


                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">Mail Port</label>
                                            <input data-parsley-required-message="Mail Port Required" type="text"
                                                class="form-control" name="mail_port" id="mail_port"
                                                value="{{$layout_data['mail_port']}}" required="">
                                        </div>


                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">Mail Username</label>
                                            <input data-parsley-required-message="Mail Username Required" type="text"
                                                class="form-control" name="mail_username" id="mail_username"
                                                value="{{$layout_data['mail_username']}}" required="">
                                        </div>

                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">Mail Password</label>
                                            <input data-parsley-required-message="Mail Password Required" type="text"
                                                class="form-control" name="mail_password" id="mail_password"
                                                value="{{$layout_data['mail_password']}}" required="">
                                        </div>


                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">Mail Encription</label>
                                            <input data-parsley-required-message="Mail Encription Required" type="text"
                                                class="form-control" name="mail_encription" id="mail_encription"
                                                value="{{$layout_data['mail_encription']}}" required="">
                                        </div>



                                    </div>



                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- #################End Of Mail  Section ############## -->

                    <!-- ####################################SMS Integration Section ################## -->

                    <div class="panel-group1" id="accordion1">
                        <div class="panel panel-default mb-4">
                            <div class="panel-heading1 ">
                                <h4 class="panel-title1">
                                    <a class="accordion-toggle collapsed" data-bs-toggle="collapse"
                                        data-bs-parent="#accordion" href="#collapseseven" aria-expanded="false">SMS
                                        Automation</a>
                                </h4>
                            </div>
                            <div id="collapseseven" class="panel-collapse collapse" role="tabpanel"
                                aria-expanded="false">
                                <div class="panel-body">

                                    <div class="form-row">

                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">User Name</label>
                                            <input data-parsley-required-message="Username Required" type="text"
                                                class="form-control" name="sms_username" id="sms_username"
                                                value="{{$layout_data['sms_username']}}" required="">
                                        </div>

                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">Password</label>
                                            <input data-parsley-required-message="Password Required" type="text"
                                                class="form-control" name="sms_password" id="sms_password"
                                                value="{{$layout_data['sms_password']}}" required="">
                                        </div>


                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">SID</label>
                                            <input data-parsley-required-message="SID Required" type="text"
                                                class="form-control" name="sms_SID" id="sms_SID"
                                                value="{{$layout_data['sms_sid']}}" required="">
                                        </div>


                                        <div class="col-xl-4 mb-3">
                                            <label for="validationTooltip02">M Type</label>
                                            <input data-parsley-required-message="Mtype Required" type="text"
                                                class="form-control" name="sms_m_type" id="sms_m_type"
                                                value="{{$layout_data['sms_m_type']}}" required="">
                                        </div>





                                    </div>



                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- ################################End Of SMS Integration Section ############## -->

                </div>


                <div style="    border: none;" class="card-body">
                    @can('automation-edit')
                    <a id="create_btn" href="#"
                        onclick="createOrUpdate('update_automation_integration', 'layoutForm', '', '','')"
                        class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                    @endcan
                </div>
            </form>

        </div>
    </div>
</div>
@endcanany

<!-- //End Of Website Section -->






@endsection

@section('scripts')

<!-- Switcher js -->
<script src="{{asset('assets/switcher/js/switcher.js')}}"></script>

<!-- CUSTOM JS -->
<script src="{{asset('assets/js/custom1.js')}}"></script>


@endsection