function createOrUpdate(
    url,
    formId,
    modalId,
    dataTable,
    redirectUrl,
    validation
) {
    if (validation != false) {
        $("#" + formId)
            .parsley()
            .validate();
        if (
            !$("#" + formId)
                .parsley()
                .isValid()
        ) {
            return false;
        }
    }
    var formData = new FormData($("#" + formId)[0]);
    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        async: true,
        cache: false,
        contentType: false,
        enctype: "multipart/form-data",
        processData: false,
        success: function (result) {
            if (modalId) {
                $("#" + modalId).modal("hide");
            }

            toast(result, dataTable, formId, redirectUrl);
            custom_styles(formId);
        },
        error: function () {},
    });

    return false;
}

function toast(data, datatable = "", formId = "", redirectUrl = "") {
    if (data.status == 0) {
        //Success Anel
        $.toast({
            heading: data.heading,
            text: data.msg,
            position: "top-right",
            loaderBg: theme_color,
            bgColor: theme_color,
            icon: "success",
            hideAfter: 1500,
            stack: 6,
        });
        if (formId) {
            $("#" + formId)
                .parsley()
                .reset();
            $("#" + formId)[0].reset();
            $("#create_btn").show();
            $("#update_btn").hide();
        }
        //Multi select uncheckall
        var array = ["permission", "roles", "section_recipies"];
        $.each(array, function (index, value) {
            var iNum = parseInt(value);
            $select = $("#" + value);
            $select.multipleSelect("uncheckAll");
        });
        //End Of Uncheck All
    } else if (data.status == 1) {
        $.toast({
            heading: data.heading,
            text: data.msg,
            position: "top-right",
            loaderBg: "red",
            icon: "error",
            hideAfter: 1500,
            stack: 6,
        });
    }
    if (datatable == "") {
        if (redirectUrl && data.status == 0) {
            window.onload = setTimeout(function () {
                window.location.replace(redirectUrl);
            }, 2000);
        } else if (data.status == 1) {
        } else {
            window.onload = setTimeout(function () {
                location.reload();
            }, 1500);
        }
    } else {
        $("#" + datatable)
            .DataTable()
            .ajax.reload(null, false);
    }
}

// #######################Table Scrolling Section #########
$(document).ready(function () {
    pageScroll();
    $("#table_status_scrolling")
        .mouseover(function () {
            clearTimeout(my_time);
        })
        .mouseout(function () {
            pageScroll();
        });
    getWidthHeader("table_fixed", "table_scroll");
});
var my_time;

function pageScroll() {
    var objDiv = document.getElementById("table_status_scrolling");
    objDiv.scrollTop = objDiv.scrollTop + 1;
    if (objDiv.scrollTop + 200 == objDiv.scrollHeight) {
        objDiv.scrollTop = 0;
    }
    my_time = setTimeout("pageScroll()", 25);
}

function getWidthHeader(id_header, id_scroll) {
    var colCount = 0;
    $("#" + id_scroll + " tr:nth-child(1) td").each(function () {
        if ($(this).attr("colspan")) {
            colCount += +$(this).attr("colspan");
        } else {
            colCount++;
        }
    });

    for (var i = 1; i <= colCount; i++) {
        var th_width = $(
            "#" +
                id_scroll +
                " > tbody > tr:first-child > td:nth-child(" +
                i +
                ")"
        ).width();
        $("#" + id_header + " > thead th:nth-child(" + i + ")").css(
            "width",
            th_width + "px"
        );
    }
}
// ###################End Of Table Scrolling Section #######

// #################Top Customer Scrolling ############
$(document).ready(function () {
    pageScroll_top_customer();
    $("#table_fixed_top_customer")
        .mouseover(function () {
            clearTimeout(my_time_1);
        })
        .mouseout(function () {
            pageScroll_top_customer();
        });
    getWidthHeader_top_customer("table_fixed", "table_scroll");
});
var my_time_1;

function pageScroll_top_customer() {
    var objDiv = document.getElementById("top_customer_scrolling");
    objDiv.scrollTop = objDiv.scrollTop + 1;

    if (objDiv.scrollTop + 250 == objDiv.scrollHeight) {
        objDiv.scrollTop = 0;
    }
    my_time_1 = setTimeout("pageScroll_top_customer()", 25);
}

function getWidthHeader_top_customer(id_header, id_scroll) {
    var colCount = 0;
    $("#" + id_scroll + " tr:nth-child(1) td").each(function () {
        if ($(this).attr("colspan")) {
            colCount += +$(this).attr("colspan");
        } else {
            colCount++;
        }
    });

    for (var i = 1; i <= colCount; i++) {
        var th_width = $(
            "#" +
                id_scroll +
                " > tbody > tr:first-child > td:nth-child(" +
                i +
                ")"
        ).width();
        $("#" + id_header + " > thead th:nth-child(" + i + ")").css(
            "width",
            th_width + "px"
        );
    }
}

// #####################End Of Customer scrolling ############

//Custome Form Styles
function custom_styles(formId) {
    if (formId == "createrecipeForm") {
        //Recipe Adding Section
        $(".panel-collapse").removeClass("show");
        window.onload = setTimeout(function () {
            set_add_on_options(add_on_array, 0);
        }, 500);
    }
}
//End Of Custom Form Styles
