<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblSubscriptionHistoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_subscription_history', function (Blueprint $table) {
            $table->integer('subscription_history_id', true);
            $table->integer('subscription_history_status')->nullable();
            $table->integer('subscription_id')->nullable();
            $table->string('subscription_name', 100)->nullable();
            $table->float('subscription_price', 10)->nullable();
            $table->integer('subscription_days')->nullable();
            $table->string('subscription_from_date', 10)->nullable();
            $table->string('subscription_to_date', 10)->nullable();
            $table->string('subscription_current_status', 100)->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_subscription_history');
    }
}
