<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblStockLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_stock_log', function (Blueprint $table) {
            $table->integer('stock_log_id', true);
            $table->integer('stock_log_status');
            $table->string('stock_log_date', 10)->nullable();
            $table->string('stock_log_time', 20)->nullable();
            $table->string('stock_log_item_name', 100);
            $table->integer('stock_log_item_id');
            $table->integer('stock_log_type')->comment('0->out,1->in');
            $table->integer('stock_log_current_stock');
            $table->integer('stock_log_changing_qty');
            $table->integer('stock_log_updated_qty');
            $table->string('stock_log_comment', 200);
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_stock_log');
    }
}
