<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblRecipeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_recipe', function (Blueprint $table) {
            $table->integer('recipe_id', true);
            $table->integer('recipe_status')->default(0);
            $table->string('recipe_ip', 30)->nullable();
            $table->string('recipe_name', 100);
            $table->string('recipe_name_multi_language', 200)->nullable();
            $table->integer('recipe_category_id');
            $table->integer('recipe_subcategory_id')->nullable();
            $table->integer('recipe_veg_or_non')->nullable()->comment('1->veg,->non veg');
            $table->float('recipe_price', 10);
            $table->float('recipe_offer_price', 10)->nullable()->default(0);
            $table->string('recipe_description', 2000)->nullable();
            $table->string('recipe_description_multi_language', 1000)->nullable();
            $table->integer('recipe_preparation_time')->nullable();
            $table->text('recipe_image');
            $table->text('recipe_sub_image_1')->nullable();
            $table->text('recipe_sub_image_2')->nullable();
            $table->text('recipe_sub_image_3')->nullable();
            $table->text('recipe_sub_image_4')->nullable();
            $table->text('recipe_video')->nullable();
            $table->integer('recipe_active_status')->comment('0>not active,1->active');
            $table->string('recipe_recommended_status', 100)->default('0');
            $table->string('recipe_permalink', 1000)->nullable();
            $table->string('recipe_add_ons', 200)->nullable();
            $table->string('recipe_properties', 999)->nullable();
            $table->integer('recipe_stock_reminder')->nullable();
            $table->integer('recipe_stock')->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_recipe');
    }
}
