<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblRecipeAddsOnTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_recipe_adds_on', function (Blueprint $table) {
            $table->integer('add_on_id', true);
            $table->integer('add_on_status')->nullable();
            $table->string('add_on_ip', 100)->nullable();
            $table->string('add_on_name', 100)->nullable();
            $table->string('add_on_multi_name', 999)->nullable();
            $table->float('add_on_price', 10)->nullable();
            $table->string('add_on_image', 100)->nullable();
            $table->integer('add_on_active_status')->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->default(0);
            $table->integer('updated_by')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_recipe_adds_on');
    }
}
