<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblOrderItemVarientTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_order_item_varient', function (Blueprint $table) {
            $table->integer('order_item_varient_id', true);
            $table->integer('order_item_varient_status')->nullable();
            $table->integer('order_item_id');
            $table->integer('varient_id');
            $table->string('order_item_varient_name', 100);
            $table->float('order_item_varient_price', 10);
            $table->integer('order_item_varient_quantity');
            $table->float('order_item_varient_total_price', 10);
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->nullable()->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_order_item_varient');
    }
}
