<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblLanguagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_languages', function (Blueprint $table) {
            $table->integer('language_id', true);
            $table->string('language_ip', 100);
            $table->integer('language_status');
            $table->integer('language_active_status')->default(0);
            $table->string('language_short_code', 100);
            $table->string('language_name', 100);
            $table->string('language_permalink', 100)->nullable();
            $table->integer('created_by');
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_languages');
    }
}
