<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_countries', function (Blueprint $table) {
            $table->integer('id', true);
            $table->char('code', 2);
            $table->string('name', 100);
            $table->integer('phone');
            $table->string('symbol', 10)->nullable();
            $table->string('capital', 80)->nullable();
            $table->string('currency', 3)->nullable();
            $table->string('continent', 30)->nullable();
            $table->string('continent_code', 2)->nullable();
            $table->char('alpha_3', 3)->nullable();
            $table->integer('mobile_number_length');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_countries');
    }
}
