<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblBannerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_banner', function (Blueprint $table) {
            $table->integer('banner_id', true);
            $table->string('banner_ip', 100);
            $table->integer('banner_status');
            $table->string('banner_name', 100)->nullable();
            $table->string('banner_name_multi', 200)->nullable();
            $table->string('banner_description', 1000)->nullable();
            $table->string('banner_description_multi', 1000)->nullable();
            $table->string('banner_image', 100);
            $table->integer('active_status');
            $table->integer('priority')->default(0);
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_banner');
    }
}
