<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblAdminNotificationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_admin_notification', function (Blueprint $table) {
            $table->integer('notification_id', true);
            $table->integer('notification_status')->default(0);
            $table->integer('notification_seen_status')->default(0)->comment('0->not seen,1->seen');
            $table->string('notification_date', 10);
            $table->string('notification_time', 10);
            $table->integer('notification_branch')->default(1);
            $table->integer('notification_type')->comment('1->Order Related');
            $table->string('notification_name', 100);
            $table->text('notification_desc');
            $table->integer('priviliage');
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_admin_notification');
    }
}
