<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblSubcategoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_subcategory', function (Blueprint $table) {
            $table->integer('subcategory_id', true);
            $table->integer('subcategory_status')->default(0);
            $table->string('subcategory_ip', 100);
            $table->integer('subcategory_cid');
            $table->text('subcategory_name');
            $table->string('subcategory_name_multi_language', 250);
            $table->text('subcategory_image');
            $table->integer('priority');
            $table->string('subcategory_banner_heading', 1000)->nullable();
            $table->string('subcategory_multi_banner_heading', 1000);
            $table->string('subcategory_banner_description', 1000)->nullable();
            $table->string('subcategory_multi_banner_description', 1000);
            $table->string('subcategory_banner', 1000)->nullable();
            $table->string('subcategory_permalink', 1000);
            $table->timestamp('created_at')->useCurrent();
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at')->useCurrent();
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_subcategory');
    }
}
